/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.subsystem.refrig.RefrigTest;

public class RefrigTestSim
extends RefrigTest {
    private static final long UPDATE_PERIOD = 1000L;
    private int lastChanState = 0;
    private ChanSim[] simData;
    private long baseTime = System.currentTimeMillis();
    private static final int PROP_ON_VALUE = 0;
    private static final int PROP_ON_TIME = 1;
    private static final int PROP_OFF_VALUE = 2;
    private static final int PROP_OFF_TIME = 3;
    private static final int N_PROPS = 4;

    @Override
    void addStructure(Properties struct) {
        String[] names = new String[]{"onvalues", "ontimes", "offvalues", "offtimes"};
        this.simData = new ChanSim[this.nChan];
        String[][] pValues = new String[4][];
        for (int jp = 0; jp < 4; ++jp) {
            String pValue = struct.getProperty("org.lsst.ccs.refrig." + names[jp]);
            if (pValue != null) {
                pValues[jp] = pValue.split(",", -1);
                continue;
            }
            log.error((Object)("Simulator structure is missing " + names[jp] + " property"));
            pValues[jp] = new String[this.nChan];
            for (int jc = 0; jc < this.nChan; ++jc) {
                pValues[jp][jc] = "0";
            }
        }
        float[] values = new float[4];
        for (int jc = 0; jc < this.nChan; ++jc) {
            for (int jp = 0; jp < 4; ++jp) {
                try {
                    values[jp] = Float.valueOf(pValues[jp][jc]).floatValue();
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.error((Object)("Simulator structure is missing " + names[jp] + " value for " + this.chanData[jc].name));
                    values[jp] = 0.0f;
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Simulator structure contains invalid " + names[jp] + " value for " + this.chanData[jc].name));
                    values[jp] = 0.0f;
                }
            }
            this.simData[jc] = new ChanSim(values[0], values[1], values[2], values[3]);
        }
    }

    @Override
    void addDefaultConfiguration(Properties dfltConfig) {
    }

    @Override
    void addConfiguration() {
    }

    @Override
    void initSensors() {
        for (int j = 0; j < this.nChan; ++j) {
            ChanSim sim = this.simData[j];
            sim.startVal = sim.offValue;
            sim.endVal = sim.offValue;
            this.chanData[j].value = sim.offValue;
        }
        new Timer().schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    @Override
    void readSensors() {
        int cState = (1 << this.nChan) - 1;
        for (int j = 0; j < this.nChan; ++j) {
            RefrigTest.Channel ch = this.chanData[j];
            ChanSim sim = this.simData[j];
            float intvl = (float)((double)(System.currentTimeMillis() - this.baseTime) / 1000.0);
            ch.value = sim.startVal + sim.rate * intvl;
            if (sim.rate < 0.0f) {
                if (ch.value < sim.endVal) {
                    ch.value = sim.endVal;
                }
            } else if (ch.value > sim.endVal) {
                ch.value = sim.endVal;
            }
            if (!(ch.checkLo && ch.value < ch.limitLo) && (!ch.checkHi || !(ch.value > ch.limitHi))) continue;
            cState &= ~(1 << j);
        }
        this.chanState = cState;
    }

    @Override
    void configAlarm(int id) {
    }

    @Override
    void setMainPower() {
        this.baseTime = System.currentTimeMillis();
        for (int j = 0; j < this.nChan; ++j) {
            RefrigTest.Channel ch = this.chanData[j];
            ChanSim sim = this.simData[j];
            sim.rate = 0.0f;
            if (this.mainPower) {
                sim.endVal = sim.onValue;
                if (sim.onTime != 0.0f) {
                    sim.rate = (sim.onValue - sim.offValue) / sim.onTime;
                }
            } else {
                sim.endVal = sim.offValue;
                if (sim.offTime != 0.0f) {
                    sim.rate = (sim.offValue - sim.onValue) / sim.offTime;
                }
            }
            sim.startVal = sim.rate != 0.0f ? ch.value : sim.endVal;
        }
    }

    @Override
    void setLoadPower() {
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            if (!RefrigTestSim.this.running) {
                return;
            }
            RefrigTestSim.this.readSensors();
            if (RefrigTestSim.this.chanState != RefrigTestSim.this.lastChanState) {
                RefrigTestSim.this.lastChanState = RefrigTestSim.this.chanState;
                RefrigTestSim.this.tick();
            }
        }
    }

    private static class ChanSim {
        float onValue;
        float onTime;
        float offValue;
        float offTime;
        float startVal;
        float endVal;
        float rate;

        public ChanSim(float onValue, float onTime, float offValue, float offTime) {
            this.onValue = onValue;
            this.onTime = onTime;
            this.offValue = offValue;
            this.offTime = offTime;
            this.startVal = 0.0f;
            this.endVal = 0.0f;
            this.rate = 0.0f;
        }
    }
}

