/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.usb.UsbException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.utilities.conv.Convert;

public class RefrigTestHdw
extends RefrigTest
implements WattsUp.Listener {
    private static final int MCC_DEV_TC_AI = 0;
    private static final int MCC_DEV_TC = 1;
    private static final int MCC_DEV_TEMP = 2;
    private static final int N_MCC_DEVS = 3;
    private static final int N_MCC_DEV_CHANS = 8;
    private static final int N_MCC_CHANS = 24;
    private static final int TC_CHAN_MASK = 0xFFFF0F;
    private static final int RT_CHAN_MASK = 0xFF0000;
    private static final int V_CHAN_MASK = 240;
    private static final int N_ALARMS = 6;
    private static final int MAIN_POWER_DEV = 0;
    private static final int MAIN_POWER_BIT = 7;
    private static final int LOAD_POWER_DEV = 0;
    private static final int LOAD_POWER_BIT = 6;
    private static final int ALARMS_MASK = 63;
    private static final int LEDS_MASK = 127;
    private static final int LOAD_POWER_CHAN = 0;
    private static final int CMPR_POWER_CHAN = 1;
    private static final int CHAN_TYPE_UNKNOWN = -1;
    private static final int CHAN_TYPE_TEMP = 0;
    private static final int CHAN_TYPE_VOLTS = 1;
    private static final int CHAN_TYPE_POWER = 2;
    private static final int CHAN_TYPE_SWITCH = 3;
    private static final long UPDATE_PERIOD = 1000L;
    private static final float[] RTD_COEFFS = new float[]{100.0f, 0.003908f, -5.8019E-7f, -4.2735E-12f};
    private static final String[] DEV_NAMES = new String[3];
    private MccUsb[] mcc = new MccUsb[3];
    private WattsUp wtu;
    private float[] power = new float[]{-1.0f, -1.0f};
    private boolean[] mccInited = new boolean[3];
    private boolean wattsInited;
    private ChanHdw[] hdwData;
    private static final int PROP_TYPE = 0;
    private static final int PROP_SUBTYPE = 1;
    private static final int PROP_HWCHAN = 2;
    private static final int PROP_ALARM = 3;
    private static final int PROP_OFFSET = 4;
    private static final int PROP_SCALE = 5;
    private static final int N_PROPS = 6;
    private static final String[] propNames;
    private static final HashMap<String, Integer> typeMap;
    private static final HashMap<String, Integer> tSubtypeMap;
    private static final HashMap<String, Integer> tcSubtypeMap;
    private static final HashMap<String, Integer> rtSubtypeMap;
    private static final HashMap<String, Integer> vSubtypeMap;

    @Override
    void addStructure(Properties struct) {
        this.hdwData = new ChanHdw[this.nChan];
        String[][] pValues = new String[6][];
        for (int jp = 0; jp < 6; ++jp) {
            String pValue = struct.getProperty("org.lsst.ccs.refrig." + propNames[jp]);
            if (pValue != null) {
                pValues[jp] = pValue.split(",", -1);
                continue;
            }
            log.error((Object)("Hardware structure is missing " + propNames[jp] + " property"));
            pValues[jp] = new String[this.nChan];
            for (int jc = 0; jc < this.nChan; ++jc) {
                pValues[jp][jc] = "-1";
            }
        }
        Object[] values = new Object[6];
        for (int jc = 0; jc < this.nChan; ++jc) {
            int type = -1;
            int subtype = -1;
            for (int jp = 0; jp < 6; ++jp) {
                try {
                    if (jp == 0) {
                        String cType = pValues[jp][jc].toUpperCase();
                        Integer typ = typeMap.get(cType);
                        if (typ == null) {
                            throw new NumberFormatException();
                        }
                        type = typ;
                        continue;
                    }
                    if (jp == 1) {
                        String csType = pValues[jp][jc].toUpperCase();
                        if (type == 0) {
                            String[] csTypes = csType.split(":", -1);
                            if (csTypes.length < 2) {
                                throw new NumberFormatException();
                            }
                            Integer stp = tSubtypeMap.get(csTypes[0]);
                            if (stp == null) {
                                throw new NumberFormatException();
                            }
                            subtype = stp;
                            if ((stp = stp == 0 ? rtSubtypeMap.get(csTypes[1]) : tcSubtypeMap.get(csTypes[1])) == null) {
                                throw new NumberFormatException();
                            }
                            subtype |= stp << 8;
                            continue;
                        }
                        if (type != 1) continue;
                        Integer stp = vSubtypeMap.get(csType);
                        if (stp == null) {
                            throw new NumberFormatException();
                        }
                        subtype = stp;
                        continue;
                    }
                    if (jp == 2) {
                        values[jp] = -1;
                        int value = Integer.decode(pValues[jp][jc]);
                        if (type == 0) {
                            int mask;
                            int n = mask = (subtype & 0xFF) == 0 ? 0xFF0000 : 0xFFFF0F;
                            if ((1 << value & mask) == 0) {
                                throw new NumberFormatException();
                            }
                        } else if (type == 1 ? (1 << value & 0xF0) == 0 : type == 3 && (value < 0 || value >= 24)) {
                            throw new NumberFormatException();
                        }
                        values[jp] = value;
                        continue;
                    }
                    if (jp == 3) {
                        values[jp] = -1;
                        int value = Integer.decode(pValues[jp][jc]);
                        if (value >= 6) {
                            throw new NumberFormatException();
                        }
                        values[jp] = value;
                        continue;
                    }
                    values[jp] = Float.valueOf(jp == 4 ? 0.0f : 1.0f);
                    values[jp] = Float.valueOf(pValues[jp][jc]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.error((Object)("Hardware structure is missing " + propNames[jp] + " value for " + this.chanData[jc].name));
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Hardware structure contains invalid " + propNames[jp] + " value for " + this.chanData[jc].name));
                }
            }
            this.hdwData[jc] = new ChanHdw(type, subtype, (Integer)values[2], (Integer)values[3], ((Float)values[4]).floatValue(), ((Float)values[5]).floatValue());
        }
    }

    @Override
    void addDefaultConfiguration(Properties dfltConfig) {
    }

    @Override
    void addConfiguration() {
    }

    @Override
    void initSensors() {
        int dev = 0;
        try {
            dev = 0;
            this.mcc[dev] = new MccUsb();
            this.mcc[dev].open(0, null, true);
            this.mcc[dev].blink();
            for (int j = 0; j < 6; ++j) {
                this.mcc[dev].configAlarm(j, 0, 0, 0.0f, 0.0f);
            }
            this.mcc[dev].dioConfig(0);
            this.mcc[dev].dioOut(0);
            this.mccInited[dev] = true;
        }
        catch (UsbException e) {
            log.error((Object)("Error initializing " + DEV_NAMES[dev] + " module: " + (Object)((Object)e)));
        }
        try {
            dev = 1;
            this.mcc[dev] = new MccUsb();
            this.mcc[dev].open(1, null, true);
            this.mcc[dev].blink();
            this.mcc[dev].dioConfig(0);
            this.mcc[dev].dioOut(0);
            this.mccInited[dev] = true;
        }
        catch (UsbException e) {
            log.error((Object)("Error initializing " + DEV_NAMES[dev] + " module: " + (Object)((Object)e)));
        }
        try {
            dev = 2;
            this.mcc[dev] = new MccUsb();
            this.mcc[dev].open(2, null, true);
            this.mcc[dev].blink();
            this.mcc[dev].dioConfig(0);
            this.mcc[dev].dioOut(0);
            for (int j = 0; j < 8; j += 2) {
                this.mcc[dev].setSensorType(j, 4);
            }
            this.mccInited[dev] = true;
        }
        catch (UsbException e) {
            log.error((Object)("Error initializing " + DEV_NAMES[dev] + " module: " + (Object)((Object)e)));
        }
        try {
            this.wtu = new WattsUp();
            this.wtu.addListener((WattsUp.Listener)this);
            this.wtu.open();
            this.wattsInited = true;
            this.power[0] = 0.0f;
        }
        catch (Exception e) {
            log.error((Object)("Cannot access WattsUp meter: " + e));
        }
        for (int j = 0; j < this.nChan; ++j) {
            RefrigTest.Channel ch = this.chanData[j];
            ChanHdw hw = this.hdwData[j];
            dev = hw.chan / 8;
            if (!this.mccInited[dev]) continue;
            int chan = hw.chan % 8;
            try {
                if (hw.type == 0) {
                    int sType = hw.subtype & 0xFF;
                    int tType = hw.subtype >> 8;
                    this.mcc[dev].setSensorType(chan, sType);
                    if (sType == 0) {
                        this.mcc[dev].setThermConnType(chan, tType);
                        this.mcc[dev].setExcitation(chan, 2);
                        this.mcc[dev].setGain(chan, 2);
                        for (int k = 0; k < RTD_COEFFS.length; ++k) {
                            this.mcc[dev].setCoefficient(chan, k, RTD_COEFFS[k]);
                        }
                    } else {
                        this.mcc[dev].setTCType(chan, tType);
                    }
                } else if (hw.type == 1) {
                    this.mcc[dev].setGain(chan, hw.subtype);
                    this.mcc[dev].setVoltageConnType(chan, 0);
                } else if (hw.type == 3) {
                    this.mcc[dev].dioConfigBit(chan, 1);
                }
                this.configAlarm(j);
                continue;
            }
            catch (UsbException e) {
                log.error((Object)("Error configuring " + DEV_NAMES[dev] + " module: " + (Object)((Object)e)));
                this.mccInited[dev] = false;
            }
        }
        new RemotePower().start();
        new Timer().schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    @Override
    void readSensors() {
        for (int j = 0; j < this.nChan; ++j) {
            RefrigTest.Channel ch = this.chanData[j];
            ChanHdw hw = this.hdwData[j];
            int dev = hw.chan / 8;
            if (hw.type != 0 && hw.type != 1 || dev != 0 || hw.alarm < 0) continue;
            try {
                ch.value = this.mcc[dev].adcIn(hw.chan % 8, 0);
                ch.value = hw.offset + hw.scale * ch.value;
                continue;
            }
            catch (UsbException e) {
                if (!this.mccInited[dev]) continue;
                log.error((Object)("Error reading ADC: " + (Object)((Object)e)));
            }
        }
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(1);
                this.wtu.setExternalLogging(1);
            }
            catch (Exception e) {
                log.error((Object)("Cannot initialize WattsUp meter: " + e));
            }
        } else {
            this.power[0] = 0.0f;
        }
    }

    public void setClosed() {
        this.power[0] = -1.0f;
        this.wattsInited = false;
    }

    public void processData(float[] data) {
        this.power[0] = data[0];
    }

    @Override
    void configAlarm(int id) {
        block10: {
            RefrigTest.Channel ch = this.chanData[id];
            ChanHdw hw = this.hdwData[id];
            if (hw.type != 0 && hw.type != 1 || hw.alarm < 0) {
                return;
            }
            int dev = hw.chan / 8;
            if (dev != 0) {
                return;
            }
            int inOptn = hw.chan % 8;
            int outOptn = 0;
            float value1 = 0.0f;
            float value2 = 0.0f;
            if (ch.checkLo) {
                outOptn = 3;
                value1 = ch.limitLo;
                if (ch.checkHi) {
                    inOptn |= 0x40;
                    value2 = ch.limitHi;
                } else {
                    inOptn |= 0x20;
                }
            } else if (ch.checkHi) {
                outOptn = 3;
                value1 = ch.limitHi;
            }
            value1 = (value1 - hw.offset) / hw.scale;
            value2 = (value2 - hw.offset) / hw.scale;
            try {
                this.mcc[dev].configAlarm(hw.alarm, inOptn, outOptn, value1, value2);
                if (outOptn == 0) {
                    this.mcc[dev].dioOutBit(hw.alarm, 0);
                }
            }
            catch (UsbException e) {
                if (!this.mccInited[dev]) break block10;
                log.error((Object)("Error configuring alarm: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setMainPower() {
        block2: {
            try {
                this.mcc[0].dioOutBit(7, this.mainPower ? 1 : 0);
            }
            catch (UsbException e) {
                if (!this.mccInited[0]) break block2;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setLoadPower() {
        block2: {
            try {
                this.mcc[0].dioOutBit(6, this.loadPower ? 1 : 0);
            }
            catch (UsbException e) {
                if (!this.mccInited[0]) break block2;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    static {
        RefrigTestHdw.DEV_NAMES[0] = "USB_TC_AI";
        RefrigTestHdw.DEV_NAMES[1] = "USB_TC";
        RefrigTestHdw.DEV_NAMES[2] = "USB_TEMP";
        propNames = new String[6];
        RefrigTestHdw.propNames[0] = "types";
        RefrigTestHdw.propNames[1] = "subtypes";
        RefrigTestHdw.propNames[2] = "hwchans";
        RefrigTestHdw.propNames[3] = "alarms";
        RefrigTestHdw.propNames[4] = "offsets";
        RefrigTestHdw.propNames[5] = "scales";
        typeMap = new HashMap();
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("POWER", 2);
        typeMap.put("SWITCH", 3);
        tSubtypeMap = new HashMap();
        tSubtypeMap.put("TC", 2);
        tSubtypeMap.put("RTD", 0);
        tcSubtypeMap = new HashMap();
        tcSubtypeMap.put("J", 0);
        tcSubtypeMap.put("K", 1);
        tcSubtypeMap.put("T", 2);
        tcSubtypeMap.put("E", 3);
        tcSubtypeMap.put("R", 4);
        tcSubtypeMap.put("S", 5);
        tcSubtypeMap.put("B", 6);
        tcSubtypeMap.put("N", 7);
        rtSubtypeMap = new HashMap();
        rtSubtypeMap.put("2WIRE1", 0);
        rtSubtypeMap.put("2WIRE2", 1);
        rtSubtypeMap.put("3WIRE", 2);
        rtSubtypeMap.put("4WIRE", 3);
        vSubtypeMap = new HashMap();
        vSubtypeMap.put("10V", 2);
        vSubtypeMap.put("5V", 3);
        vSubtypeMap.put("2.5V", 4);
        vSubtypeMap.put("1.25V", 5);
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            int lines;
            int cState;
            block20: {
                cState = 0;
                for (int j = 0; j < RefrigTestHdw.this.nChan; ++j) {
                    boolean ok;
                    ChanHdw hw;
                    RefrigTest.Channel ch;
                    block19: {
                        ch = RefrigTestHdw.this.chanData[j];
                        hw = RefrigTestHdw.this.hdwData[j];
                        if (hw.type == 2) {
                            ch.value = RefrigTestHdw.this.power[hw.chan];
                        } else {
                            int dev = hw.chan / 8;
                            int chan = hw.chan % 8;
                            if (hw.type == 3) {
                                try {
                                    ch.value = RefrigTestHdw.this.mcc[dev].dioInBit(chan);
                                }
                                catch (UsbException e) {
                                    if (RefrigTestHdw.this.mccInited[dev]) {
                                        log.error((Object)("Error reading DIO line: " + (Object)((Object)e)));
                                    }
                                    break block19;
                                }
                            }
                            if (hw.alarm >= 0 && dev == 0) continue;
                            try {
                                ch.value = hw.offset + hw.scale * RefrigTestHdw.this.mcc[dev].adcIn(chan, 0);
                            }
                            catch (UsbException e) {
                                if (!RefrigTestHdw.this.mccInited[dev]) break block19;
                                log.error((Object)("Error reading ADC: " + (Object)((Object)e)));
                            }
                        }
                    }
                    boolean bl = ok = (!ch.checkLo || ch.value >= ch.limitLo) && (!ch.checkHi || ch.value <= ch.limitHi);
                    if (ok) {
                        cState |= 1 << j;
                    }
                    if (hw.alarm < 0) continue;
                    try {
                        RefrigTestHdw.this.mcc[0].dioOutBit(hw.alarm, ok ? 0 : 1);
                        continue;
                    }
                    catch (UsbException e) {
                        if (!RefrigTestHdw.this.mccInited[0]) continue;
                        log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
                    }
                }
                lines = 0;
                try {
                    lines = RefrigTestHdw.this.mcc[0].dioIn();
                    try {
                        RefrigTestHdw.this.mcc[1].dioOut((lines ^ 0x7F) & 0x7F);
                    }
                    catch (UsbException e) {
                        if (RefrigTestHdw.this.mccInited[1]) {
                            log.error((Object)("Error writing DIO lines: " + (Object)((Object)e)));
                        }
                    }
                }
                catch (UsbException e) {
                    if (!RefrigTestHdw.this.mccInited[0]) break block20;
                    log.error((Object)("Error reading DIO lines: " + (Object)((Object)e)));
                }
            }
            for (int j = 0; j < RefrigTestHdw.this.nChan; ++j) {
                int alarm = ((RefrigTestHdw)RefrigTestHdw.this).hdwData[j].alarm;
                if (alarm < 0 || (1 << alarm & lines) != 0) continue;
                cState |= 1 << j;
            }
            if (cState != RefrigTestHdw.this.chanState && RefrigTestHdw.this.running) {
                RefrigTestHdw.this.chanState = cState;
                RefrigTestHdw.this.tick();
            }
        }
    }

    private class RemotePower
    extends Thread {
        private RemotePower() {
        }

        @Override
        public void run() {
            ServerSocket server;
            try {
                server = new ServerSocket(7070, 1);
            }
            catch (IOException e) {
                log.error((Object)("Error creating remote power listener: " + e));
                return;
            }
            byte[] data = new byte[8];
            block8: while (true) {
                InputStream netInp;
                try {
                    netInp = server.accept().getInputStream();
                }
                catch (IOException e) {
                    log.error((Object)("Error creating remote power socket: " + e));
                    continue;
                }
                while (true) {
                    int nRead;
                    try {
                        nRead = netInp.read(data);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error reading remote power data: " + e));
                        nRead = -2;
                    }
                    if (nRead < 0) {
                        try {
                            netInp.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        ((RefrigTestHdw)RefrigTestHdw.this).power[1] = -1.0f;
                        continue block8;
                    }
                    if (nRead < data.length || Convert.bytesToInt((byte[])data, (int)0) != 13572468) continue;
                    ((RefrigTestHdw)RefrigTestHdw.this).power[1] = Convert.bytesToFloat((byte[])data, (int)4);
                }
                break;
            }
        }
    }

    private static class ChanHdw {
        int type;
        int subtype;
        int chan;
        int alarm;
        float offset;
        float scale;

        public ChanHdw(int type, int subtype, int chan, int alarm, float offset, float scale) {
            this.type = type;
            this.subtype = subtype;
            this.chan = chan;
            this.alarm = alarm;
            this.offset = offset;
            this.scale = scale;
        }
    }
}

