/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.status.RefrigStateStatus;

public abstract class RefrigTest
extends Module {
    static final int MAX_CHANS = 16;
    static final String PREFIX = "org.lsst.ccs.refrig.";
    static final String HLT_CHAN_NAME = "LoadTmp";
    String structFile = "structure.properties";
    String configFile = "config.properties";
    Properties config;
    Channel[] chanData;
    int nChan;
    int hltChan = -1;
    int loLimChange = 0;
    int hiLimChange = 0;
    int chanState = 0;
    boolean running = false;
    boolean mainPower = false;
    boolean loadPower = false;
    boolean loadTrip = false;
    private static final int PROP_NAME = 0;
    private static final int PROP_DESC = 1;
    private static final int PROP_UNITS = 2;
    private static final int PROP_LO_CHECK = 3;
    private static final int PROP_HI_CHECK = 4;
    private static final int N_PROPS = 5;

    public void initModule() {
        this.initStructure();
        this.initConfiguration();
        this.initSensors();
        this.setLoadLine();
    }

    public void tick() {
        if (!this.running) {
            System.out.println("Refrigeration test system started");
            this.publishState();
            this.publishLimits();
            this.running = true;
        }
        long timeStamp = System.currentTimeMillis();
        this.readSensors();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        for (int j = 0; j < this.nChan; ++j) {
            Channel chan = this.chanData[j];
            trendingValues.add(new ValueNotification(chan.name, (Object)Float.valueOf(chan.value), timeStamp));
        }
        trendingValues.add(new ValueNotification("state", (Object)this.getState()));
        this.publishData(trendingValues);
        this.setLoadLine();
    }

    public void setStructFile(String name) {
        this.structFile = name;
    }

    public void setConfigFile(String name) {
        this.configFile = name;
    }

    public void setTickMillis(int value) {
        super.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void setPowerEnable(int value) {
        this.mainPower = value != 0;
        this.setMainPower();
        this.setLoadLine();
        this.publishState();
    }

    public void setLoadTripEnable(int value) {
        this.loadTrip = value != 0;
        this.setLoadLine();
        this.publishState();
    }

    public int getState() {
        int value = this.chanState;
        if (this.mainPower) {
            value |= 0x10000;
        }
        if (this.loadPower) {
            value |= 0x20000;
        }
        if (this.loadTrip) {
            value |= 0x40000;
        }
        return value;
    }

    public void setLowLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        float fLimit = (float)limit;
        if (fLimit == chan.limitLo) {
            return;
        }
        chan.limitLo = fLimit;
        String sLimit = String.valueOf(fLimit);
        this.config.setProperty(PREFIX + chan.limitLoName, sLimit);
        this.configAlarm(id);
        this.loLimChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "alarmLow", sLimit);
    }

    public void setHighLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        float fLimit = (float)limit;
        if (fLimit == chan.limitHi) {
            return;
        }
        chan.limitHi = fLimit;
        String sLimit = String.valueOf(fLimit);
        this.config.setProperty(PREFIX + chan.limitHiName, sLimit);
        this.configAlarm(id);
        this.hiLimChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "alarmHigh", sLimit);
    }

    public void saveConfiguration() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.configFile);
        }
        catch (IOException e) {
            log.error((Object)("Error opening configuration file: " + e));
        }
        if (writer != null) {
            try {
                this.config.store(writer, "Refrigeration long lines test configuration");
                this.hiLimChange = 0;
                this.loLimChange = 0;
            }
            catch (IOException e) {
                log.error((Object)("Error writing configuration: " + e));
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                log.error((Object)("Error closing configuration file: " + e));
            }
        }
        this.publishState();
    }

    public RefrigFullState getFullState() {
        RefrigFullState status = new RefrigFullState();
        for (int i = 0; i < this.nChan; ++i) {
            Channel c = this.chanData[i];
            status.addChannel(new RefrigChannel(c.name, c.description, c.units, (double)c.limitLo, (double)c.limitHi, c.value));
        }
        status.setRefrigState(new RefrigState(this.getState(), this.loLimChange, this.hiLimChange, this.getTickMillis()));
        return status;
    }

    public void publishState() {
        RefrigState refrigState = new RefrigState(this.getState(), this.loLimChange, this.hiLimChange, this.getTickMillis());
        this.sendToStatus((Status)new RefrigStateStatus(refrigState));
    }

    public void publishLimits() {
        for (int i = 0; i < this.nChan; ++i) {
            Channel c = this.chanData[i];
            this.getSubsystem().publishMetaData(c.name, "alarmLow", String.valueOf(c.limitLo));
            this.getSubsystem().publishMetaData(c.name, "alarmHigh", String.valueOf(c.limitHi));
        }
    }

    private void initStructure() {
        Properties struct = this.loadProperties(this.structFile, null);
        try {
            this.nChan = Integer.decode(struct.getProperty("org.lsst.ccs.refrig.nchan"));
            if (this.nChan <= 0 || this.nChan > 16) {
                throw new NumberFormatException();
            }
        }
        catch (NullPointerException e) {
            log.error((Object)"General structure is missing nchan property");
            this.nChan = 0;
            return;
        }
        catch (NumberFormatException e) {
            log.error((Object)"Invalid number of channels specified");
            this.nChan = 0;
            return;
        }
        String[] names = new String[]{"names", "descs", "units", "lolimchecks", "hilimchecks"};
        this.chanData = new Channel[this.nChan];
        String[][] pValues = new String[5][];
        for (int jp = 0; jp < 5; ++jp) {
            String pValue = struct.getProperty(PREFIX + names[jp]);
            if (pValue != null) {
                pValues[jp] = pValue.split(",", -1);
                continue;
            }
            log.error((Object)("General structure is missing " + names[jp] + " property"));
            pValues[jp] = new String[this.nChan];
            for (int jc = 0; jc < this.nChan; ++jc) {
                pValues[jp][jc] = jp == 3 || jp == 4 ? "1" : "";
            }
        }
        String[] values = new String[5];
        for (int jc = 0; jc < this.nChan; ++jc) {
            boolean loCheck = true;
            boolean hiCheck = true;
            for (int jp = 0; jp < 5; ++jp) {
                if (jc < pValues[jp].length) {
                    values[jp] = pValues[jp][jc];
                    if (jp != 3 && jp != 4) continue;
                    boolean value = true;
                    try {
                        value = Integer.decode(values[jp]) != 0;
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("General structure contains invalid " + names[jp] + " value for channel " + jc));
                    }
                    if (jp == 3) {
                        loCheck = value;
                        continue;
                    }
                    hiCheck = value;
                    continue;
                }
                log.error((Object)("General structure is missing " + names[jp] + " value for channel " + jc));
                values[jp] = "";
            }
            this.chanData[jc] = new Channel(values[0], values[1], values[2], loCheck, hiCheck);
            if (!values[0].equals(HLT_CHAN_NAME)) continue;
            this.hltChan = jc;
        }
        this.addStructure(struct);
    }

    private void initConfiguration() {
        Channel chan;
        int j;
        Properties dfltConfig = new Properties();
        for (j = 0; j < this.nChan; ++j) {
            chan = this.chanData[j];
            dfltConfig.setProperty(PREFIX + chan.limitLoName, "0.0");
            dfltConfig.setProperty(PREFIX + chan.limitHiName, "0.0");
        }
        this.addDefaultConfiguration(dfltConfig);
        this.config = this.loadProperties(this.configFile, dfltConfig);
        for (j = 0; j < this.nChan; ++j) {
            chan = this.chanData[j];
            chan.limitLo = Float.valueOf(this.config.getProperty(PREFIX + chan.limitLoName)).floatValue();
            chan.limitHi = Float.valueOf(this.config.getProperty(PREFIX + chan.limitHiName)).floatValue();
        }
        this.addConfiguration();
    }

    private Properties loadProperties(String file, Properties dflt) {
        Properties propList = dflt == null ? new Properties() : new Properties(dflt);
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error opening properties file: " + e));
        }
        try {
            propList.load(reader);
        }
        catch (IOException e) {
            log.error((Object)("Error reading properties file: " + e));
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            log.error((Object)("Error closing properties file: " + e));
        }
        return propList;
    }

    private void setLoadLine() {
        this.loadPower = this.mainPower & (this.loadTrip ? (this.chanState & 1 << this.hltChan) != 0 : true);
        this.setLoadPower();
    }

    abstract void addStructure(Properties var1);

    abstract void addDefaultConfiguration(Properties var1);

    abstract void addConfiguration();

    abstract void initSensors();

    abstract void readSensors();

    abstract void configAlarm(int var1);

    abstract void setMainPower();

    abstract void setLoadPower();

    static class Channel {
        String name;
        String description;
        String units;
        boolean checkLo;
        boolean checkHi;
        float limitLo;
        float limitHi;
        String limitLoName;
        String limitHiName;
        float value;

        public Channel(String name, String desc, String units, boolean loCheck, boolean hiCheck) {
            this.name = name;
            this.description = desc;
            this.units = units;
            this.checkLo = loCheck;
            this.checkHi = hiCheck;
            this.limitLoName = name + "LoLim";
            this.limitHiName = name + "HiLim";
        }
    }
}

