/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.usb.UsbException;
import org.lsst.ccs.drivers.mcc.MccTc;
import org.lsst.ccs.drivers.mcc.MccTcAi;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.refrig.RefrigTest;
import org.lsst.ccs.utilities.conv.Convert;

public class RefrigTestHdw
extends RefrigTest
implements WattsUp.Listener {
    private static final int N_MCC_CHANS = 16;
    private static final int N_MCC_CHAN0 = 8;
    private static final int MCC_V_CHAN0 = 4;
    private static final int V_CHAN_MASK = 240;
    private static final int N_ALARMS = 6;
    private static final int MAIN_POWER_BIT = 7;
    private static final int LOAD_POWER_BIT = 6;
    private static final int ALARMS_MASK = 63;
    private static final int LEDS_MASK = 127;
    private static final int LOAD_POWER_CHAN = 0;
    private static final int CMPR_POWER_CHAN = 1;
    private static final int CHAN_TYPE_UNKNOWN = -1;
    private static final int CHAN_TYPE_TEMP = 0;
    private static final int CHAN_TYPE_VOLTS = 1;
    private static final int CHAN_TYPE_POWER = 2;
    private static final int CHAN_TYPE_SWITCH = 3;
    private static final long UPDATE_PERIOD = 1000L;
    private MccTcAi tcai;
    private MccTc tc;
    private WattsUp wtu;
    private float[] power = new float[]{-1.0f, -1.0f};
    private boolean mccTcAiInited;
    private boolean mccTcInited;
    private boolean wattsInited;
    private ChanHdw[] hdwData;
    private static final int PROP_TYPE = 0;
    private static final int PROP_HWCHAN = 1;
    private static final int PROP_ALARM = 2;
    private static final int PROP_OFFSET = 3;
    private static final int PROP_SCALE = 4;
    private static final int N_PROPS = 5;

    @Override
    void addStructure(Properties struct) {
        String[] names = new String[]{"types", "hwchans", "alarms", "offsets", "scales"};
        this.hdwData = new ChanHdw[this.nChan];
        String[][] pValues = new String[5][];
        for (int jp = 0; jp < 5; ++jp) {
            String pValue = struct.getProperty("org.lsst.ccs.refrig." + names[jp]);
            if (pValue != null) {
                pValues[jp] = pValue.split(",", -1);
                continue;
            }
            log.error((Object)("Hardware structure is missing " + names[jp] + " property"));
            pValues[jp] = new String[this.nChan];
            for (int jc = 0; jc < this.nChan; ++jc) {
                pValues[jp][jc] = "-1";
            }
        }
        Object[] values = new Object[5];
        for (int jc = 0; jc < this.nChan; ++jc) {
            int type = 0;
            for (int jp = 0; jp < 5; ++jp) {
                try {
                    if (jp == 0) {
                        String cType = pValues[jp][jc].toUpperCase();
                        int n = cType.equals("TEMP") ? 0 : (cType.equals("VOLTS") ? 1 : (cType.equals("POWER") ? 2 : (type = cType.equals("SWITCH") ? 3 : -1)));
                        if (type != -1) continue;
                        throw new NumberFormatException();
                    }
                    if (jp == 1 || jp == 2) {
                        values[jp] = -1;
                        int value = Integer.decode(pValues[jp][jc]);
                        if (jp == 1 ? (type == 0 ? value < 0 || value >= 16 || (1 << value & 0xF0) != 0 : type == 1 && (value < 0 || value >= 16 || (1 << value & 0xF0) == 0)) : value >= 6) {
                            throw new NumberFormatException();
                        }
                        values[jp] = value;
                        continue;
                    }
                    values[jp] = Float.valueOf(jp == 3 ? 0.0f : 1.0f);
                    values[jp] = Float.valueOf(pValues[jp][jc]);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.error((Object)("Hardware structure is missing " + names[jp] + " value for " + this.chanData[jc].name));
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Hardware structure contains invalid " + names[jp] + " value for " + this.chanData[jc].name));
                }
            }
            this.hdwData[jc] = new ChanHdw(type, (Integer)values[1], (Integer)values[2], ((Float)values[3]).floatValue(), ((Float)values[4]).floatValue());
        }
    }

    @Override
    void addDefaultConfiguration(Properties dfltConfig) {
    }

    @Override
    void addConfiguration() {
    }

    @Override
    void initSensors() {
        try {
            this.tcai = new MccTcAi();
            this.tcai.open(null, true);
            this.tcai.blink();
            for (int j = 0; j < 6; ++j) {
                this.tcai.configAlarm(j, 0, 0, 0.0f, 0.0f);
            }
            this.tcai.dioConfig(0);
            this.tcai.dioOut(0);
            boolean dioCfg = false;
            for (int j = 0; j < this.nChan; ++j) {
                RefrigTest.Channel ch = this.chanData[j];
                ChanHdw hw = this.hdwData[j];
                if (hw.chan >= 8) continue;
                if (hw.type == 0) {
                    this.tcai.setTCType(hw.chan, 2);
                } else if (hw.type == 1) {
                    this.tcai.setGain(hw.chan, 5);
                    this.tcai.setVoltageConnType(hw.chan, 0);
                } else if (hw.type == 3) {
                    this.tcai.dioConfigBit(hw.chan, 1);
                }
                this.configAlarm(j);
            }
            this.mccTcAiInited = true;
        }
        catch (UsbException e) {
            log.error((Object)("Error initializing USB-TC-AI module: " + (Object)((Object)e)));
        }
        try {
            this.tc = new MccTc();
            this.tc.open(null, true);
            this.tc.blink();
            this.tc.dioConfig(0);
            this.tc.dioOut(0);
            for (int j = 0; j < this.nChan; ++j) {
                RefrigTest.Channel ch = this.chanData[j];
                ChanHdw hw = this.hdwData[j];
                int hwChan = hw.chan - 8;
                if (hwChan < 0) continue;
                if (hw.type == 0) {
                    this.tc.setTCType(hwChan, 2);
                    continue;
                }
                if (hw.type != 3) continue;
                this.tc.dioConfigBit(hwChan, 1);
            }
            this.mccTcInited = true;
        }
        catch (UsbException e) {
            log.error((Object)("Error initializing USB_TC module: " + (Object)((Object)e)));
        }
        try {
            this.wtu = new WattsUp();
            this.wtu.addListener((WattsUp.Listener)this);
            this.wtu.open();
            this.wattsInited = true;
            this.power[0] = 0.0f;
        }
        catch (Exception e) {
            log.error((Object)("Cannot access WattsUp meter: " + e));
        }
        new RemotePower().start();
        new Timer().schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    @Override
    void readSensors() {
        for (int j = 0; j < this.nChan; ++j) {
            RefrigTest.Channel ch = this.chanData[j];
            ChanHdw hw = this.hdwData[j];
            if (hw.type != 0 && hw.type != 1 || hw.alarm < 0 || hw.chan >= 8) continue;
            try {
                ch.value = this.tcai.adcIn(hw.chan, 0);
                ch.value = hw.offset + hw.scale * ch.value;
                continue;
            }
            catch (UsbException e) {
                if (!this.mccTcAiInited) continue;
                log.error((Object)("Error reading ADC: " + (Object)((Object)e)));
            }
        }
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(1);
                this.wtu.setExternalLogging(1);
            }
            catch (Exception e) {
                log.error((Object)("Cannot initialize WattsUp meter: " + e));
            }
        } else {
            this.power[0] = 0.0f;
        }
    }

    public void setClosed() {
        this.power[0] = -1.0f;
        this.wattsInited = false;
    }

    public void processData(float[] data) {
        this.power[0] = data[0];
    }

    @Override
    void configAlarm(int id) {
        block10: {
            RefrigTest.Channel ch = this.chanData[id];
            ChanHdw hw = this.hdwData[id];
            if (hw.type != 0 && hw.type != 1) {
                return;
            }
            if (hw.chan >= 8 || hw.alarm < 0) {
                return;
            }
            int inOptn = hw.chan;
            int outOptn = 0;
            float value1 = 0.0f;
            float value2 = 0.0f;
            if (ch.checkLo) {
                outOptn = 3;
                value1 = ch.limitLo;
                if (ch.checkHi) {
                    inOptn |= 0x40;
                    value2 = ch.limitHi;
                } else {
                    inOptn |= 0x20;
                }
            } else if (ch.checkHi) {
                outOptn = 3;
                value1 = ch.limitHi;
            }
            value1 = (value1 - hw.offset) / hw.scale;
            value2 = (value2 - hw.offset) / hw.scale;
            try {
                this.tcai.configAlarm(hw.alarm, inOptn, outOptn, value1, value2);
                if (outOptn == 0) {
                    this.tcai.dioOutBit(hw.alarm, 0);
                }
            }
            catch (UsbException e) {
                if (!this.mccTcAiInited) break block10;
                log.error((Object)("Error configuring alarm: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setMainPower() {
        block2: {
            try {
                this.tcai.dioOutBit(7, this.mainPower ? 1 : 0);
            }
            catch (UsbException e) {
                if (!this.mccTcAiInited) break block2;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    @Override
    void setLoadPower() {
        block2: {
            try {
                this.tcai.dioOutBit(6, this.loadPower ? 1 : 0);
            }
            catch (UsbException e) {
                if (!this.mccTcAiInited) break block2;
                log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
            }
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            int lines;
            int cState;
            block21: {
                cState = 0;
                for (int j = 0; j < RefrigTestHdw.this.nChan; ++j) {
                    boolean ok;
                    ChanHdw hw;
                    RefrigTest.Channel ch;
                    block20: {
                        ch = RefrigTestHdw.this.chanData[j];
                        hw = RefrigTestHdw.this.hdwData[j];
                        if (hw.alarm >= 0 && hw.chan >= 0 && hw.chan < 8) continue;
                        if (hw.type == 0 || hw.type == 1) {
                            try {
                                ch.value = hw.chan < 8 ? RefrigTestHdw.this.tcai.adcIn(hw.chan, 0) : RefrigTestHdw.this.tc.adcIn(hw.chan - 8, 0);
                                ch.value = hw.offset + hw.scale * ch.value;
                            }
                            catch (UsbException e) {
                                if (hw.chan < 8 && RefrigTestHdw.this.mccTcAiInited || hw.chan >= 8 && RefrigTestHdw.this.mccTcInited) {
                                    log.error((Object)("Error reading ADC: " + (Object)((Object)e)));
                                }
                                break block20;
                            }
                        }
                        if (hw.type == 3) {
                            try {
                                if (hw.chan < 8) {
                                    ch.value = RefrigTestHdw.this.tcai.dioInBit(hw.chan);
                                    break block20;
                                }
                                ch.value = RefrigTestHdw.this.tc.dioInBit(hw.chan - 8);
                            }
                            catch (UsbException e) {
                                if (hw.chan < 8 && RefrigTestHdw.this.mccTcAiInited || hw.chan >= 8 && RefrigTestHdw.this.mccTcInited) {
                                    log.error((Object)("Error reading DIO line: " + (Object)((Object)e)));
                                }
                                break block20;
                            }
                        }
                        ch.value = RefrigTestHdw.this.power[hw.chan];
                    }
                    boolean bl = ok = (!ch.checkLo || ch.value >= ch.limitLo) && (!ch.checkHi || ch.value <= ch.limitHi);
                    if (ok) {
                        cState |= 1 << j;
                    }
                    if (hw.alarm < 0) continue;
                    try {
                        RefrigTestHdw.this.tcai.dioOutBit(hw.alarm, ok ? 0 : 1);
                        continue;
                    }
                    catch (UsbException e) {
                        if (!RefrigTestHdw.this.mccTcAiInited) continue;
                        log.error((Object)("Error setting DIO line: " + (Object)((Object)e)));
                    }
                }
                lines = 0;
                try {
                    lines = RefrigTestHdw.this.tcai.dioIn();
                    try {
                        RefrigTestHdw.this.tc.dioOut((lines ^ 0x7F) & 0x7F);
                    }
                    catch (UsbException e) {
                        if (RefrigTestHdw.this.mccTcInited) {
                            log.error((Object)("Error writing DIO lines: " + (Object)((Object)e)));
                        }
                    }
                }
                catch (UsbException e) {
                    if (!RefrigTestHdw.this.mccTcAiInited) break block21;
                    log.error((Object)("Error reading DIO lines: " + (Object)((Object)e)));
                }
            }
            for (int j = 0; j < RefrigTestHdw.this.nChan; ++j) {
                int alarm = ((RefrigTestHdw)RefrigTestHdw.this).hdwData[j].alarm;
                if (alarm < 0 || (1 << alarm & lines) != 0) continue;
                cState |= 1 << j;
            }
            if (cState != RefrigTestHdw.this.chanState && RefrigTestHdw.this.running) {
                RefrigTestHdw.this.chanState = cState;
                RefrigTestHdw.this.tick();
            }
        }
    }

    private class RemotePower
    extends Thread {
        private RemotePower() {
        }

        @Override
        public void run() {
            ServerSocket server;
            try {
                server = new ServerSocket(7070, 1);
            }
            catch (IOException e) {
                log.error((Object)("Error creating remote power listener: " + e));
                return;
            }
            byte[] data = new byte[8];
            block8: while (true) {
                InputStream netInp;
                try {
                    netInp = server.accept().getInputStream();
                }
                catch (IOException e) {
                    log.error((Object)("Error creating remote power socket: " + e));
                    continue;
                }
                while (true) {
                    int nRead;
                    try {
                        nRead = netInp.read(data);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error reading remote power data: " + e));
                        nRead = -2;
                    }
                    if (nRead < 0) {
                        try {
                            netInp.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        ((RefrigTestHdw)RefrigTestHdw.this).power[1] = -1.0f;
                        continue block8;
                    }
                    if (nRead < data.length || Convert.bytesToInt((byte[])data, (int)0) != 13572468) continue;
                    ((RefrigTestHdw)RefrigTestHdw.this).power[1] = Convert.bytesToFloat((byte[])data, (int)4);
                }
                break;
            }
        }
    }

    private static class ChanHdw {
        int type;
        int chan;
        int alarm;
        float offset;
        float scale;

        public ChanHdw(int type, int chan, int alarm, float offset, float scale) {
            this.type = type;
            this.chan = chan;
            this.alarm = alarm;
            this.offset = offset;
            this.scale = scale;
        }
    }
}

