/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.utilities.conv.Convert;

public class RefrigPower
implements WattsUp.Listener {
    static final int POWER_PORT = 7070;
    static final int POWER_ID = 13572468;
    private final int UPDATE_PERIOD = 1;
    private static final PrintStream out = System.out;
    private OutputStream netOut;
    private WattsUp wtu;
    private Thread mainThread = Thread.currentThread();
    private float power = 0.0f;

    public static void main(String[] args) {
        if (args.length < 1) {
            out.println("No DAQ IP address supplied");
            System.exit(0);
        }
        new RefrigPower().run(args[0]);
        System.exit(0);
    }

    private void run(String daqNode) {
        try {
            this.wtu = new WattsUp();
            this.wtu.open();
            this.wtu.addListener((WattsUp.Listener)this);
        }
        catch (Exception e) {
            out.println("Cannot access WattsUp meter: " + e);
            return;
        }
        new Timer().schedule((TimerTask)new SendPower(), 0L, 1000L);
        while (this.wtu != null) {
            try {
                this.netOut = new Socket(daqNode, 7070).getOutputStream();
                out.println("Connected to DAQ node (" + daqNode + ")");
            }
            catch (UnknownHostException e) {
                out.println(e);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
            do {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.netOut != null);
        }
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(1);
                this.wtu.setExternalLogging(1);
            }
            catch (Exception e) {
                out.println("Cannot initialize WattsUp meter: " + e);
            }
        } else {
            this.power = 0.0f;
            this.sendData(0.0f);
        }
    }

    public void setClosed() {
        out.println("WattsUp meter disconnected");
        this.wtu = null;
        this.power = -1.0f;
        this.sendData(-1.0f);
        this.closeNet();
    }

    public void processData(float[] data) {
        this.power = data[0];
    }

    private void sendData(float value) {
        if (this.netOut != null) {
            byte[] mesg = new byte[8];
            Convert.intToBytes((int)13572468, (byte[])mesg, (int)0);
            Convert.floatToBytes((float)value, (byte[])mesg, (int)4);
            try {
                this.netOut.write(mesg);
            }
            catch (IOException e) {
                out.println("Lost connection to DAQ node");
                this.closeNet();
            }
        }
    }

    private void closeNet() {
        try {
            this.netOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.netOut = null;
        this.mainThread.interrupt();
    }

    private class SendPower
    extends TimerTask {
        private SendPower() {
        }

        @Override
        public void run() {
            RefrigPower.this.sendData(RefrigPower.this.power);
        }
    }
}

