package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;

/**
 *  Implements a heater sub-panel.
 *
 *  @author saxton
 */
public class BulkSupplyPanel extends JPanel implements UiUtilities.ActionHandler {

    private static final String[] labelNames = {"Bulk Power:"};
    private static final int HORZ_INSET = UiUtilities.getLabelSize("M").width / 2;

    private final CommandSender sender;
    private final int labelWidth, stateWidth;
    private final UiUtilities uiUtils;

    private JLabel controlState;
    private ButtonGroup controlBG;
    private JRadioButton controlOffRB, controlOnRB;

    static int getLabelWidth() {
        return UiUtilities.maxLabelWidth(labelNames, ":");
    }

    static int getStateWidth() {
        return UiUtilities.maxEnumLabelWidth(SwitchState.class);
    }

    BulkSupplyPanel(CommandSender sender, int labelWidth, int stateWidth) {
        this.sender = sender;
        this.labelWidth = labelWidth;
        this.stateWidth = stateWidth;
        uiUtils = new UiUtilities(this);
        initComponents();
    }

    public void updatePanel(SwitchState ss) {
        controlState.setEnabled(true);
        controlState.setText(ss.name());
        controlState.setForeground(ss == SwitchState.ON ? UiConstants.GREEN : ss == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE);
        controlOffRB.setEnabled(true);
        controlOnRB.setEnabled(true);
        JRadioButton selButton = ss == SwitchState.ON ? controlOnRB : ss == SwitchState.OFF ? controlOffRB : null;
        if (selButton != null) {
            selButton.setSelected(true);
        }
        //controlOffRB.setEnabled(selButton == controlOffRB);
        //controlOnRB.setEnabled(selButton == controlOffRB);
        repaint();
    }

    public void disablePanel() {
        controlState.setEnabled(false);
        controlOffRB.setEnabled(false);
        controlOnRB.setEnabled(false);
        repaint();
    }

    private void initComponents() {
        controlState = UiUtilities.newLabel("OFF", stateWidth);
        controlOffRB = uiUtils.newRadioButton("Off", "F");
        controlOnRB = uiUtils.newRadioButton("On", "N");
        controlBG = new ButtonGroup();
        controlBG.add(controlOffRB);
        controlBG.add(controlOnRB);

        // Lay out the panel
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, HORZ_INSET, 0, HORZ_INSET);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;

        // Add bulk power control to panel
        add(UiUtilities.newLabel(labelNames[0], labelWidth), gbc);
        gbc.gridx++;
        add(controlState, gbc);
        gbc.gridx++;
        add(controlOffRB, gbc);
        gbc.gridx++;
        gbc.insets.right = 0;
        add(controlOnRB, gbc);
    }

    @Override
    public void handleRadioButton(String name) {
        controlOffRB.setEnabled(false);
        controlOnRB.setEnabled(false);
        sender.sendCommand(null, "bulkPowerOn", name.charAt(0) == 'N');
    }

    private static final long serialVersionUID = 1L;
}
