/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Comparator;
import org.openide.util.lookup.AbstractLookup;

final class ALPairComparator
implements Comparator<AbstractLookup.Pair<?>> {
    public static final Comparator<AbstractLookup.Pair<?>> DEFAULT = new ALPairComparator();

    private ALPairComparator() {
    }

    @Override
    public int compare(AbstractLookup.Pair<?> i1, AbstractLookup.Pair<?> i2) {
        int result = i1.getIndex() - i2.getIndex();
        if (result == 0) {
            if (i1 != i2) {
                throw new DuplicatedPairException(i1, i2);
            }
            return 0;
        }
        return result;
    }

    private static final class DuplicatedPairException
    extends IllegalStateException {
        private final AbstractLookup.Pair<?> i1;
        private final AbstractLookup.Pair<?> i2;

        public DuplicatedPairException(AbstractLookup.Pair<?> i1, AbstractLookup.Pair<?> i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public String getMessage() {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            ps.println("Duplicate pair in treePair1: " + this.i1 + " pair2: " + this.i2 + " index1: " + this.i1.getIndex() + " index2: " + this.i2.getIndex() + " item1: " + this.i1.getInstance() + " item2: " + this.i2.getInstance() + " id1: " + Integer.toHexString(System.identityHashCode(this.i1)) + " id2: " + Integer.toHexString(System.identityHashCode(this.i2)));
            ps.close();
            return bs.toString();
        }
    }
}

