/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class DataDictionaryByType
implements DataProviderDictionary {
    private final String[] types;
    private final DataProviderDictionary[] dictionaries;
    private static final long serialVersionUID = 1L;

    public DataDictionaryByType(DataProviderDictionary other, Function<List<DataProviderInfo>, DataProviderDictionary> maker) {
        this(other.getDataProviderInfos(), maker);
    }

    public DataDictionaryByType(List<DataProviderInfo> allData, Function<List<DataProviderInfo>, DataProviderDictionary> maker) {
        HashMap<String, ArrayList<DataProviderInfo>> dataByType = new HashMap<String, ArrayList<DataProviderInfo>>(8);
        ArrayList<DataProviderInfo> dataWithNoType = new ArrayList<DataProviderInfo>();
        for (DataProviderInfo dpi : allData) {
            String type = dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            if (type == null) {
                dataWithNoType.add(dpi);
                continue;
            }
            LinkedHashMap<DataProviderInfo.Attribute, String> attributes = new LinkedHashMap<DataProviderInfo.Attribute, String>();
            for (DataProviderInfo.Attribute att : dpi.getAttributes()) {
                if (att == DataProviderInfo.Attribute.DATA_TYPE) continue;
                attributes.put(att, dpi.getAttributeValue(att));
            }
            DataProviderInfo copy = new DataProviderInfo(dpi.getPath(), dpi.getKey(), attributes);
            ArrayList<DataProviderInfo> data = (ArrayList<DataProviderInfo>)dataByType.get(type);
            if (data == null) {
                data = new ArrayList<DataProviderInfo>();
                dataByType.put(type, data);
            }
            data.add(copy);
        }
        int n = dataByType.size();
        if (dataWithNoType.isEmpty()) {
            this.types = new String[n];
            this.dictionaries = new DataProviderDictionary[n];
        } else {
            this.types = new String[n + 1];
            this.dictionaries = new DataProviderDictionary[n + 1];
            this.dictionaries[n] = maker.apply(dataWithNoType);
        }
        int i = 0;
        for (Map.Entry e : dataByType.entrySet()) {
            this.types[i] = (String)e.getKey();
            this.dictionaries[i++] = maker.apply((List)e.getValue());
        }
    }

    public List<DataProviderInfo> getDataProviderInfos() {
        int n = this.types.length;
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<DataProviderInfo> out = new ArrayList<DataProviderInfo>(this.size());
        for (int i = 0; i < n; ++i) {
            String type = this.types[i];
            List data = this.dictionaries[i].getDataProviderInfos();
            if (type == null) {
                out.addAll(data);
                continue;
            }
            for (DataProviderInfo dpi : data) {
                dpi.addAttribute(DataProviderInfo.Attribute.DATA_TYPE, type);
                out.add(dpi);
            }
        }
        return out;
    }

    public DataProviderInfo getDataProviderInfoForPath(String path) {
        int n = this.types.length;
        if (n == 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            DataProviderInfo dpi = this.dictionaries[i].getDataProviderInfoForPath(path);
            if (dpi == null) continue;
            String type = this.types[i];
            if (type != null) {
                dpi.addAttribute(DataProviderInfo.Attribute.DATA_TYPE, type);
            }
            return dpi;
        }
        return null;
    }

    @Deprecated
    public Set<String> getGroups() {
        return Collections.singleton("");
    }

    @Deprecated
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group) {
        return group == null || !group.isEmpty() ? Collections.emptyList() : this.getDataProviderInfos();
    }

    @Deprecated
    public CCSTimeStamp getCCSTimeStamp() {
        return CCSTimeStamp.currentTime();
    }

    public int size() {
        int size = 0;
        for (DataProviderDictionary d : this.dictionaries) {
            size += d.size();
        }
        return size;
    }
}

