/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.rt.transports;

import java.io.Closeable;
import java.io.DataInput;
import java.net.InetAddress;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.NioClient;
import org.jgroups.blocks.cs.NioServer;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.jgroups.blocks.cs.TcpBaseServer;
import org.jgroups.blocks.cs.TcpClient;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.tests.rt.RtReceiver;
import org.jgroups.tests.rt.RtTransport;
import org.jgroups.util.Util;

public class ServerTransport
extends ReceiverAdapter
implements RtTransport {
    protected BaseServer srv;
    protected RtReceiver receiver;
    protected InetAddress host;
    protected int port = 7800;
    protected boolean server;
    protected boolean nio;
    protected boolean tcp_nodelay;
    protected int out_buf_size = 8192;
    protected int in_buf_size = 8192;
    protected final Log log = LogFactory.getLog(ServerTransport.class);

    @Override
    public String[] options() {
        return new String[]{"-host <host>", "-port <port>", "-server", "-nio", "-tcp-nodelay <boolean>", "-outbuf <size>", "-inbuf <size>"};
    }

    @Override
    public void options(String ... options) throws Exception {
        if (options == null) {
            return;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].equals("-server")) {
                this.server = true;
                continue;
            }
            if (options[i].equals("-host")) {
                this.host = InetAddress.getByName(options[++i]);
                continue;
            }
            if (options[i].equals("-port")) {
                this.port = Integer.parseInt(options[++i]);
                continue;
            }
            if (options[i].equals("-nio")) {
                this.nio = true;
                continue;
            }
            if (options[i].equals("-tcp-nodelay")) {
                this.tcp_nodelay = Boolean.parseBoolean(options[++i]);
                continue;
            }
            if (options[i].equals("-outbuf")) {
                this.out_buf_size = Integer.parseInt(options[++i]);
                continue;
            }
            if (!options[i].equals("-inbuf")) continue;
            this.in_buf_size = Integer.parseInt(options[++i]);
        }
        if (this.host == null) {
            this.host = InetAddress.getLocalHost();
        }
    }

    @Override
    public void receiver(RtReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Object localAddress() {
        return null;
    }

    public List<Object> clusterMembers() {
        return null;
    }

    @Override
    public void start(String ... options) throws Exception {
        this.options(options);
        if (this.server) {
            BaseServer baseServer = this.srv = this.nio ? new NioServer(this.host, this.port) : new TcpServer(this.host, this.port).connExpireTimeout(0L).tcpNodelay(this.tcp_nodelay).receiver(this);
            if (this.srv instanceof TcpBaseServer) {
                ((TcpBaseServer)this.srv).setBufferedOutputStreamSize(this.out_buf_size).setBufferedInputStreamSize(this.in_buf_size);
            }
            this.srv.start();
            System.out.printf("server started on %s (ctrl-c to terminate)\n", this.srv.localAddress());
        } else {
            BaseServer baseServer = this.srv = this.nio ? new NioClient(null, 0, this.host, this.port) : new TcpClient(null, 0, this.host, this.port).tcpNodelay(false).receiver(this);
            if (this.srv instanceof TcpBaseServer) {
                ((TcpBaseServer)this.srv).setBufferedOutputStreamSize(this.out_buf_size).setBufferedInputStreamSize(this.in_buf_size);
            }
            this.srv.start();
        }
    }

    @Override
    public void stop() {
        Util.close((Closeable)this.srv);
    }

    @Override
    public void send(Object dest, byte[] buf, int offset, int length) throws Exception {
        this.srv.send((Address)dest, buf, offset, buf.length);
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        if (this.receiver != null) {
            this.receiver.receive(sender, buf, offset, length);
        }
    }

    @Override
    public void receive(Address sender, DataInput in, int length) throws Exception {
        if (this.receiver == null) {
            return;
        }
        byte[] buf = new byte[11];
        in.readFully(buf);
        this.receiver.receive(sender, buf, 0, buf.length);
    }
}

