/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class LeapSecondReader {
    private static final Logger LOG = Logger.getLogger(LeapSecondReader.class.getName());
    private static final long EPOCH_OFFSET = 2208988800L;
    static String defaultURL = "https://hpiers.obspm.fr/iers/bul/bulc/ntp/leap-seconds.list";
    private final TreeMap<Long, Integer> leapMap;
    private long expiryDate;
    private long lastModDate;

    LeapSecondReader() throws IOException {
        this(new URL(defaultURL));
    }

    LeapSecondReader(URL source) throws IOException {
        this.leapMap = this.readLeaps(source);
        LOG.log(Level.WARNING, "Falling back to reading leap-second file from {0}", source);
    }

    private TreeMap<Long, Integer> readLeaps(URL source) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(source.openStream()));){
            String inputLine;
            TreeMap<Long, Integer> localLeapMap = new TreeMap<Long, Integer>();
            while ((inputLine = in.readLine()) != null) {
                String[] split = inputLine.split("#", 2);
                if (split[0].isEmpty()) {
                    if (inputLine.startsWith("#@")) {
                        this.expiryDate = LeapSecondReader.parseTimestamp(inputLine.substring(2).trim());
                        continue;
                    }
                    if (!inputLine.startsWith("#$")) continue;
                    this.lastModDate = LeapSecondReader.parseTimestamp(inputLine.substring(2).trim());
                    continue;
                }
                String[] tokens = split[0].split("\\s+");
                if (tokens.length != 2) {
                    throw new IOException("Malformed line in leap second file: " + inputLine);
                }
                long leap = LeapSecondReader.parseTimestamp(tokens[0]);
                int nSeconds = Integer.parseInt(tokens[1]);
                localLeapMap.put(leap, nSeconds);
            }
            TreeMap<Long, Integer> treeMap = localLeapMap;
            return treeMap;
        }
    }

    private static long parseTimestamp(String token) throws NumberFormatException {
        return 1000L * (Long.parseLong(token) - 2208988800L);
    }

    int getNumberOfLeapSeconds() {
        return this.getNumberOfLeapSeconds(System.currentTimeMillis());
    }

    int getNumberOfLeapSeconds(long timestamp) {
        Map.Entry<Long, Integer> leapSecond = this.leapMap.floorEntry(timestamp);
        if (leapSecond == null) {
            throw new RuntimeException("Cannot compute leap-second offset for timestamp before beginning of leap second file");
        }
        return leapSecond.getValue();
    }

    TreeMap<Long, Integer> getLeapMap() {
        return this.leapMap;
    }

    long getExpiryDate() {
        return this.expiryDate;
    }

    long getLastModificationDate() {
        return this.lastModDate;
    }
}

