/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import com.wittams.gritty.CharacterUtils;
import com.wittams.gritty.Mode;
import com.wittams.gritty.TtyChannel;
import java.io.IOException;
import java.util.ArrayList;

public class ControlSequence {
    private int argc = 0;
    private int[] argv = new int[10];
    private Mode[] modeTable = normalModes;
    private byte finalChar;
    private int startInBuf;
    private int lengthInBuf;
    private int bufferVersion;
    private static Mode[] normalModes = new Mode[0];
    private static Mode[] questionMarkModes = new Mode[]{Mode.Null, Mode.CursorKey, Mode.ANSI, Mode.WideColumn, Mode.SmoothScroll, Mode.ReverseScreen, Mode.RelativeOrigin, Mode.WrapAround, Mode.AutoRepeat, Mode.Interlace};
    private ArrayList<Byte> unhandledChars;

    ControlSequence(TtyChannel channel) throws IOException {
        this.readControlSequence(channel);
    }

    private void readControlSequence(TtyChannel channel) throws IOException {
        byte b;
        this.argc = 0;
        int digit = 0;
        int seenDigit = 0;
        int pos = -1;
        this.bufferVersion = channel.serial;
        this.startInBuf = channel.offset;
        while (true) {
            if ((b = channel.getChar()) == 63 && ++pos == 0) {
                this.modeTable = questionMarkModes;
                continue;
            }
            if (b == 59) {
                if (digit <= 0) continue;
                ++this.argc;
                this.argv[this.argc] = 0;
                digit = 0;
                continue;
            }
            if (48 <= b && b <= 57) {
                this.argv[this.argc] = this.argv[this.argc] * 10 + b - 48;
                ++digit;
                seenDigit = 1;
                continue;
            }
            if (58 <= b && b <= 63) {
                this.addUnhandled(b);
                continue;
            }
            if (64 <= b && b <= 126) break;
            this.addUnhandled(b);
        }
        this.finalChar = b;
        this.lengthInBuf = this.bufferVersion == channel.serial ? channel.offset - this.startInBuf : -1;
        this.argc += seenDigit;
    }

    private void addUnhandled(byte b) {
        if (this.unhandledChars == null) {
            this.unhandledChars = new ArrayList();
        }
        this.unhandledChars.add(b);
    }

    public boolean pushBackReordered(TtyChannel channel) throws IOException {
        if (this.unhandledChars == null) {
            return false;
        }
        byte[] bytes = new byte[1024];
        int i = 0;
        for (byte b : this.unhandledChars) {
            bytes[i++] = b;
        }
        bytes[i++] = 27;
        bytes[i++] = 91;
        if (this.modeTable == questionMarkModes) {
            bytes[i++] = 63;
        }
        for (int argi = 0; argi < this.argc; ++argi) {
            if (argi != 0) {
                bytes[i++] = 59;
            }
            for (byte b : Integer.toString(this.argv[argi]).getBytes()) {
                bytes[i++] = b;
            }
        }
        bytes[i++] = this.finalChar;
        channel.pushBackBuffer(bytes, i);
        return true;
    }

    int getCount() {
        return this.argc;
    }

    final int getArg(int index, int def) {
        if (index >= this.argc) {
            return def;
        }
        return this.argv[index];
    }

    public final void appendToBuffer(StringBuffer sb) {
        sb.append("ESC[");
        if (this.modeTable == questionMarkModes) {
            sb.append("?");
        }
        String sep = "";
        for (int i = 0; i < this.argc; ++i) {
            sb.append(sep);
            sb.append(this.argv[i]);
            sep = ";";
        }
        sb.append((char)this.finalChar);
        if (this.unhandledChars != null) {
            sb.append(" Unhandled:");
            CharacterUtils.CharacterType last = CharacterUtils.CharacterType.NONE;
            for (byte b : this.unhandledChars) {
                last = CharacterUtils.appendChar(sb, last, (char)b);
            }
        }
    }

    public final void appendActualBytesRead(StringBuffer sb, TtyChannel buffer) {
        if (this.lengthInBuf == -1) {
            sb.append("TermIOBuffer filled in reading");
        } else if (this.bufferVersion != buffer.serial) {
            sb.append("TermIOBuffer filled after reading");
        } else {
            buffer.appendBuf(sb, this.startInBuf, this.lengthInBuf);
        }
    }

    public byte getFinalChar() {
        return this.finalChar;
    }

    public Mode[] getModeTable() {
        return this.modeTable;
    }
}

