/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.File;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.taitime.TimeStorage;

class TAITime {
    private static final Logger logger = Logger.getLogger(TAITime.class.getName());
    private static boolean libFound = true;
    private static UnsatisfiedLinkError loadException;
    private final long leapSeconds;
    private final boolean leapSecondsAreReasonable;
    private static final boolean strict;
    private static final String libName;
    private static final int minLeapSeconds;

    TAITime() {
        if (libFound) {
            TimeStorage storage = this.getTime();
            this.leapSeconds = storage.getTimeSecsTAI() - storage.getTimeSecsUTC();
            this.leapSecondsAreReasonable = this.leapSeconds >= (long)minLeapSeconds;
        } else {
            this.leapSeconds = 0L;
            this.leapSecondsAreReasonable = false;
        }
    }

    boolean isConfigured() {
        if (strict) {
            if (!libFound) {
                throw new RuntimeException("Kernel library could not be loaded", loadException);
            }
            if (!this.leapSecondsAreReasonable) {
                throw new RuntimeException("Kernal leap second offset was too small: " + this.leapSeconds + "<" + minLeapSeconds);
            }
        }
        return libFound && this.leapSecondsAreReasonable;
    }

    private native int timeaccess(TimeStorage var1);

    final TimeStorage getTime() {
        TimeStorage result = new TimeStorage();
        int rc = this.timeaccess(result);
        if (rc != 0) {
            throw new RuntimeException("Unexpected return code from gettime: " + rc);
        }
        return result;
    }

    static boolean isStrict() {
        return strict;
    }

    static {
        strict = Boolean.getBoolean("org.lsst.ccs.utilities.taitime.useStrict");
        libName = System.getProperty("org.lsst.ccs.utilities.taitime.libName", "timeaccess");
        minLeapSeconds = Integer.getInteger("org.lsst.ccs.utilities.taitime.minLeapSeconds", 30);
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            libFound = false;
            loadException = e;
            logger.log(Level.WARNING, "c++ shared library {0} not found in java.library.path : " + System.getProperty("java.library.path"), libName);
            String path = System.getProperty("java.library.path");
            StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreTokens()) {
                String libPath = st.nextToken() + "lib" + libName + ".so";
                File f = new File(libPath);
                sb.append("File ").append(libPath).append(" (exists: ").append(f.exists()).append(" can read: ").append(f.canRead()).append(")\n");
            }
            logger.log(Level.WARNING, sb.toString());
        }
    }
}

