/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;
import org.lsst.ccs.subsystem.refrig.data.ChillerControlState;

public class ChillerControlPanelOld
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private static final String CMND_GET_STATE = "getControlState";
    private static final Map<ChillerState, Color> stateColors = new HashMap<ChillerState, Color>();
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private JPanel mainPanel;
    private JPanel chillerStatePnl;
    private JLabel chillerStateLbl;
    private TextFieldX flowRateTf;
    private JButton setFlowRateBtn;
    private TextFieldX tankPressTf;
    private JButton setTankPressBtn;
    private TextFieldX tempSetPointTf;
    private JLabel defaultRampLbl;
    private JButton setTempBtn;
    private TextFieldX tempWithRampTf;
    private TextFieldX rampRateTf;
    private JButton setTempWithRampBtn;
    private JButton quitControlBtn;
    private double flowRate;
    private double tankPress;
    private double tempSetPoint;
    private double rampRate;
    private static final long serialVersionUID = 1L;

    public ChillerControlPanelOld(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((ChillerControlState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void onCommandError(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(ChillerControlState cs) {
        SwingUtilities.invokeLater(new UpdateChillerState(cs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.chillerStateLbl = UiUtilities.newLabel((String)"XXXXX", (int)UiUtilities.maxEnumLabelWidth(ChillerState.class));
        this.flowRateTf = this.uiUtils.newTextFieldX("999999.9", "F", 2);
        this.flowRateTf.update((Object)this.flowRate, true);
        this.setFlowRateBtn = this.uiUtils.newButton("Set", "F", false);
        this.tankPressTf = this.uiUtils.newTextFieldX("999999.9", "P", 2);
        this.tankPressTf.update((Object)this.tankPress, true);
        this.setTankPressBtn = this.uiUtils.newButton("Set", "P", false);
        this.tempSetPointTf = this.uiUtils.newTextFieldX("999999.9", "T", 2);
        this.tempSetPointTf.update((Object)this.tempSetPoint, true);
        this.defaultRampLbl = UiUtilities.newLabel((String)"99999.9", (int)0);
        this.defaultRampLbl.setHorizontalAlignment(0);
        this.defaultRampLbl.setText("0.0");
        this.setTempBtn = this.uiUtils.newButton("Set", "T", false);
        this.tempWithRampTf = this.uiUtils.newTextFieldX("999999.9", "U", 2);
        this.tempWithRampTf.update((Object)this.tempSetPoint, true);
        this.rampRateTf = this.uiUtils.newTextFieldX("99999.9", "R", 2);
        this.rampRateTf.update((Object)this.rampRate, true);
        this.setTempWithRampBtn = this.uiUtils.newButton("Set", "R", false);
        this.quitControlBtn = this.uiUtils.newButton("Quit", "Q", false);
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.chillerStatePnl = new JPanel();
        this.chillerStatePnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 4, 0, 4);
        this.chillerStatePnl.add((Component)UiUtilities.newLabel((String)"Chiller state:", (int)0), gbc);
        ++gbc.gridx;
        this.chillerStatePnl.add((Component)this.chillerStateLbl, gbc);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 17;
        gbm.insets = new Insets(0, 0, 4, 5);
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Flow rate:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.flowRateTf, gbm);
        ++gbm.gridx;
        gbm.gridwidth = 2;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"gal/min", (int)0), gbm);
        gbm.gridx += 4;
        gbm.gridwidth = 1;
        this.mainPanel.add((Component)this.setFlowRateBtn, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Tank press:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tankPressTf, gbm);
        ++gbm.gridx;
        gbm.gridwidth = 2;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"psig", (int)0), gbm);
        gbm.gridx += 4;
        gbm.gridwidth = 1;
        this.mainPanel.add((Component)this.setTankPressBtn, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Temperature:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tempSetPointTf, gbm);
        ++gbm.gridx;
        gbm.insets.right = 20;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C", (int)0), gbm);
        ++gbm.gridx;
        gbm.insets.right = 5;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Default ramp:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.defaultRampLbl, gbm);
        ++gbm.gridx;
        gbm.insets.right = 20;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C/min", (int)0), gbm);
        ++gbm.gridx;
        gbm.insets.right = 5;
        this.mainPanel.add((Component)this.setTempBtn, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Temp with ramp:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tempWithRampTf, gbm);
        ++gbm.gridx;
        gbm.insets.right = 20;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C", (int)0), gbm);
        ++gbm.gridx;
        gbm.insets.right = 5;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Ramp:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.rampRateTf, gbm);
        ++gbm.gridx;
        gbm.insets.right = 20;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C/min", (int)0), gbm);
        ++gbm.gridx;
        gbm.insets.right = 5;
        this.mainPanel.add((Component)this.setTempWithRampBtn, gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Quit controlling:", (int)0), gbm);
        gbm.gridx += 6;
        this.mainPanel.add((Component)this.quitControlBtn, gbm);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 4, 0, 0);
        gbp.anchor = 11;
        gbp.gridx = 0;
        gbp.gridy = 0;
        this.add((Component)this.statusPanel, gbp);
        ++gbp.gridy;
        gbp.insets.bottom = 8;
        this.add((Component)this.chillerStatePnl, gbp);
        ++gbp.gridy;
        gbp.insets.bottom = 4;
        this.add((Component)this.mainPanel, gbp);
    }

    public void handleTextFieldX(String name, Object value) {
        switch (name) {
            case "F": {
                this.flowRate = (Double)value;
                this.flowRateTf.update(value, true);
                break;
            }
            case "P": {
                this.tankPress = (Double)value;
                this.tankPressTf.update(value, true);
                break;
            }
            case "T": {
                this.tempSetPoint = (Double)value;
                this.tempSetPointTf.update(value, true);
                break;
            }
            case "U": {
                this.tempSetPoint = (Double)value;
                this.tempWithRampTf.update(value, true);
                break;
            }
            case "R": {
                this.rampRate = (Double)value;
                this.rampRateTf.update(value, true);
            }
        }
    }

    public void handleButton(String name) {
        switch (name) {
            case "F": {
                this.sender.sendCommand(null, "setFlow", new Object[]{this.flowRate});
                break;
            }
            case "P": {
                this.sender.sendCommand(null, "setTankPressure", new Object[]{this.tankPress});
                break;
            }
            case "T": {
                this.sender.sendCommand(null, "setTemperature", new Object[]{this.tempSetPoint});
                break;
            }
            case "R": {
                this.sender.sendCommand(null, "setTemperatureWithRamp", new Object[]{this.tempSetPoint, this.rampRate});
                break;
            }
            case "Q": {
                this.sender.sendCommand(null, "quitControllingTemperature", new Object[0]);
            }
        }
    }

    static {
        stateColors.put(ChillerState.OFFLINE, UiConstants.BLUE);
        stateColors.put(ChillerState.SETPOINT, UiConstants.GREEN);
        stateColors.put(ChillerState.CONTROLLING, UiConstants.YELLOW);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            ChillerControlPanelOld.this.statusPanel.disablePanel();
            ChillerControlPanelOld.this.flowRateTf.setDisabled();
            ChillerControlPanelOld.this.setFlowRateBtn.setEnabled(false);
            ChillerControlPanelOld.this.tempSetPointTf.setDisabled();
            ChillerControlPanelOld.this.setTempBtn.setEnabled(false);
            ChillerControlPanelOld.this.tempWithRampTf.setDisabled();
            ChillerControlPanelOld.this.rampRateTf.setDisabled();
            ChillerControlPanelOld.this.setTempWithRampBtn.setEnabled(false);
            ChillerControlPanelOld.this.quitControlBtn.setEnabled(false);
            ChillerControlPanelOld.this.repaint();
        }
    }

    class UpdateChillerState
    implements Runnable {
        private final ChillerControlState cs;

        UpdateChillerState(ChillerControlState cs) {
            this.cs = cs;
        }

        @Override
        public void run() {
            ChillerControlPanelOld.this.statusPanel.updatePanel(this.cs.getFastPeriod());
            ChillerControlPanelOld.this.chillerStateLbl.setText(this.cs.getChillerState().name());
            ChillerControlPanelOld.this.chillerStateLbl.setForeground(stateColors.getOrDefault(this.cs.getChillerState(), Color.BLACK));
            if (!Double.isNaN(this.cs.getFlowSet())) {
                ChillerControlPanelOld.this.flowRate = this.cs.getFlowSet();
            }
            ChillerControlPanelOld.this.flowRateTf.update((Object)ChillerControlPanelOld.this.flowRate, true);
            ChillerControlPanelOld.this.setFlowRateBtn.setEnabled(true);
            if (!Double.isNaN(this.cs.getSetPoint())) {
                ChillerControlPanelOld.this.tempSetPoint = this.cs.getSetPoint();
            }
            ChillerControlPanelOld.this.tempSetPointTf.update((Object)ChillerControlPanelOld.this.tempSetPoint, true);
            if (!Double.isNaN(this.cs.getDefaultRamp())) {
                ChillerControlPanelOld.this.defaultRampLbl.setText(String.valueOf(this.cs.getDefaultRamp()));
            }
            ChillerControlPanelOld.this.setTempBtn.setEnabled(true);
            ChillerControlPanelOld.this.tempWithRampTf.update((Object)ChillerControlPanelOld.this.tempSetPoint, true);
            ChillerControlPanelOld.this.rampRateTf.update((Object)ChillerControlPanelOld.this.rampRate, true);
            ChillerControlPanelOld.this.setTempWithRampBtn.setEnabled(true);
            ChillerControlPanelOld.this.quitControlBtn.setEnabled(true);
            ChillerControlPanelOld.this.repaint();
        }
    }
}

