package org.lsst.ccs.subsystem.refrig.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.refrig.constants.RefrigAgentProperties;
import org.lsst.ccs.subsystem.refrig.data.PcpSysState;
import org.lsst.ccs.subsystem.refrig.ui.PcpControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "Prototype Cold Plate Control Plugin", description = "Prototype Cold Plate Control Plugin")
public class PcpControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage.getService().add(new MonOptionalPage(RefrigAgentProperties.PCP_TYPE, PcpControl.class, null, true));
    }
    
    public static class PcpControl extends ControlPanel implements StatusMessageListener {

        private PcpControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(PcpSysState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(String agent) {
            return ctrlPanel = new PcpControlPanel(agent);
        }

        @Override
        public void initControlPanel() {
            ctrlPanel.initPanel();
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updatePanel((PcpSysState)obj);
        }

        @Override
        public void disableControlPanel() {
            ctrlPanel.disablePanel();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
