/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelSingle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTable;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.gconsole.util.swing.SComboBox;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;
import org.lsst.ccs.subsystem.common.ui.focalplane.view.FocalPlaneView;

public class DiagramView
extends AbstractMonitorView
implements FocalPlaneView {
    private static MonitorField DEF = new MonitorField(null, "Default", null);
    private final Descriptor descriptor;
    private List<MonitorField> filterGroupFields;
    private List<MonitorField> filterPlainFields;
    private List<String> groups;
    private JPanel rootPanel;
    private JPanel centerPanel;
    private JButton backButton;
    private JComboBox<String> groupCombo;
    private JComboBox<MonitorField> fieldCombo;
    private Table table;
    private SectionedTable plainTable;
    private JScrollPane plainTableScrollPane;
    private JLabel statusLabel;
    private boolean armed = true;
    private Segment level = Segment.RAFT;
    private MonitorField field = MonitorField.AVERAGE_VALUE;
    private int[] indices;
    private String statusPrefix;
    private String group;
    private List<DisplayChannel> plainTableChannels;

    @Create(category="FocalPlaneView", name="Focal Plane Diagram", path="Built-In/Diagram", description="Focal plane hierarchical diagram.")
    public DiagramView() {
        this.descriptor = new Descriptor();
    }

    public DiagramView(Descriptor descriptor) {
        this.descriptor = descriptor.clone();
        this.indices = this.decodeSegment(this.descriptor.getSegment());
        this.group = this.descriptor.getGroup();
    }

    public JComponent getPanel() {
        if (this.rootPanel == null) {
            this.constructGUI();
        }
        return this.rootPanel;
    }

    @Override
    public FocalPlaneFilter getFilter() {
        return (FocalPlaneFilter)super.getFilter();
    }

    public void setFilter(AgentChannelsFilter filter) {
        if (!(filter instanceof FocalPlaneFilter)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only accepts FocalPlaneFilter filters");
        }
        super.setFilter(filter);
    }

    public void install() {
        ThreadUtil.invokeLater(this::start);
        super.install();
    }

    public void uninstall() {
        super.uninstall();
        ThreadUtil.invokeLater(this::stop);
    }

    private void start() {
        if (this.filter == null) {
            throw new IllegalStateException("Trying to initialize FocalPlaneDiagramView without a filter.");
        }
        List attributes = this.filter.getFields(false);
        this.filterPlainFields = attributes == null ? MonitorTable.DEFAULT_FIELDS : new ArrayList(MonitorField.getDefaultFields((Collection)attributes));
    }

    private void stop() {
        if (this.table != null) {
            this.table.getModel().destroy();
            this.table = null;
        }
    }

    private void constructGUI() {
        this.rootPanel = new JPanel(new BorderLayout());
        Box top = Box.createHorizontalBox();
        this.rootPanel.add((Component)top, "North");
        top.setBorder(BorderFactory.createEtchedBorder());
        this.backButton = new JButton("Back");
        top.add(this.backButton);
        this.backButton.addActionListener(e -> this.upLevel());
        top.add(Box.createRigidArea(Const.HDIM));
        top.add(new JLabel("Channel group: "));
        this.groupCombo = new JComboBox();
        this.groupCombo.addActionListener(e -> {
            int i = this.groupCombo.getSelectedIndex();
            if (this.armed || i >= 0) {
                this.group = this.groups.get(i);
                this.descriptor.setGroup(this.group);
                if (this.filterGroupFields != null && this.filterGroupFields.get(i) != null) {
                    this.field = this.filterGroupFields.get(i);
                    this.armed = false;
                    this.fieldCombo.setSelectedItem(this.field);
                    this.armed = true;
                    this.descriptor.setField(null);
                }
                this.rebuildTable();
            }
        });
        top.add(this.groupCombo);
        top.add(Box.createRigidArea(Const.HDIM));
        top.add(new JLabel("Field: "));
        this.fieldCombo = new JComboBox();
        this.fieldCombo.setToolTipText("What to display for this channel");
        this.fieldCombo.addActionListener(e -> {
            if (this.armed) {
                this.field = (MonitorField)this.fieldCombo.getSelectedItem();
                if (this.field == DEF || this.field == null) {
                    this.descriptor.setField(null);
                    if (this.filterGroupFields != null) {
                        int i = this.groupCombo.getSelectedIndex();
                        this.field = this.filterGroupFields.get(i);
                        if (this.field == null) {
                            this.field = MonitorField.DEFAULT_GROUP_FIELD;
                        }
                    } else {
                        this.field = MonitorField.DEFAULT_GROUP_FIELD;
                    }
                    this.armed = false;
                    this.fieldCombo.setSelectedItem(this.field);
                    this.armed = true;
                } else {
                    this.descriptor.setField(this.field.getTitle());
                }
                this.table.getModel().clear();
            }
        });
        top.add(this.fieldCombo);
        top.add(Box.createRigidArea(Const.HDIM));
        top.add(Box.createHorizontalGlue());
        this.centerPanel = new JPanel(new GridBagLayout());
        this.rootPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.setMinimumSize(new Dimension(15, 15));
        this.centerPanel.setOpaque(true);
        this.table = new Table();
        this.centerPanel.add(this.table);
        this.plainTableScrollPane = new JScrollPane();
        this.statusLabel = new JLabel();
        this.rootPanel.add((Component)this.statusLabel, "South");
        this.statusLabel.setBorder(BorderFactory.createEtchedBorder());
    }

    protected void resetChannels() {
        this.armed = false;
        this.groups = this.getGroups();
        this.groupCombo.setModel(new DefaultComboBoxModel<String>(this.groups.toArray(new String[0])));
        if (this.groups.isEmpty()) {
            this.groupCombo.setEnabled(false);
        } else {
            this.groupCombo.setEnabled(true);
            this.group = this.descriptor.getGroup();
            if (this.group == null || !this.groups.contains(this.group)) {
                this.group = this.groups.get(0);
                this.descriptor.setGroup(this.group);
                this.descriptor.setField(null);
            }
            this.groupCombo.setSelectedItem(this.group);
        }
        SComboBox.setPrototypeDisplayValue(this.groupCombo);
        if (this.groups.isEmpty()) {
            this.fieldCombo.setModel(new DefaultComboBoxModel<MonitorField>(new MonitorField[0]));
            this.fieldCombo.setEnabled(false);
        } else {
            int i;
            this.filterGroupFields = this.getGroupFields();
            if (this.filterGroupFields != null && this.filterGroupFields.size() != this.groups.size()) {
                this.filterGroupFields = null;
            }
            if (this.filterGroupFields == null) {
                this.fieldCombo.setModel(new DefaultComboBoxModel<MonitorField>(MonitorField.GROUP_FIELDS));
            } else {
                MonitorField[] ff = new MonitorField[MonitorField.GROUP_FIELDS.length + 1];
                ff[0] = DEF;
                for (i = 0; i < MonitorField.GROUP_FIELDS.length; ++i) {
                    ff[i + 1] = MonitorField.GROUP_FIELDS[i];
                }
                this.fieldCombo.setModel(new DefaultComboBoxModel<MonitorField>(ff));
            }
            SComboBox.setPrototypeDisplayValue(this.fieldCombo);
            String descField = this.descriptor.getField();
            if (descField == null) {
                if (this.filterGroupFields == null) {
                    this.field = MonitorField.DEFAULT_GROUP_FIELD;
                } else {
                    i = this.groupCombo.getSelectedIndex();
                    this.field = this.filterGroupFields.get(i);
                    if (this.field == null) {
                        this.field = MonitorField.DEFAULT_GROUP_FIELD;
                    }
                }
            } else {
                this.field = MonitorField.stringToField((String)descField);
            }
            this.fieldCombo.setSelectedItem(this.field);
        }
        this.indices = this.groups.isEmpty() ? this.decodeSegment(null) : this.decodeSegment(this.descriptor.getSegment());
        this.rebuildTable();
        this.armed = true;
    }

    protected void update() {
        if (this.plainTableChannels == null) {
            if (this.table != null) {
                this.table.getModel().fireTableDataChanged();
            }
        } else {
            for (DisplayChannel dc : this.plainTableChannels) {
                dc.update(null);
            }
        }
    }

    private void rebuildTable() {
        Model model;
        this.table.getModel().destroy();
        if (this.plainTable != null) {
            this.plainTable.destroy();
            this.plainTable = null;
            this.plainTableChannels = null;
        }
        if (this.indices[0] == -1) {
            this.level = Segment.RAFT;
            model = this.buildModel();
            if (model == null) {
                this.level = Segment.REB;
                model = this.buildModel();
            }
        } else if (this.indices[3] == -1) {
            if (this.indices[0] % 4 == 0 && this.indices[1] % 4 == 0 && this.indices[2] != -1) {
                this.level = null;
                model = null;
            } else {
                this.level = Segment.CCD;
                model = this.buildModel();
            }
        } else if (this.indices[5] == -1) {
            this.level = Segment.AMP;
            model = this.buildModel();
        } else {
            this.level = null;
            model = null;
        }
        if (model == null) {
            if (!this.displayPlainTable()) {
                this.upLevel();
                this.rebuildTable();
            }
        } else {
            this.table.setModel(model);
            if (this.centerPanel.getParent() == null) {
                this.rootPanel.remove(this.plainTableScrollPane);
                this.rootPanel.add((Component)this.centerPanel, "Center");
                this.rootPanel.revalidate();
                this.rootPanel.repaint();
            }
        }
        this.backButton.setEnabled(this.indices[0] != -1);
        this.fieldCombo.setEnabled(this.plainTable == null);
        String pref = Segment.getPathPrefix(this.indices);
        this.statusPrefix = "<html><b><font color=blue> " + (pref.isEmpty() ? "/" : pref) + "</font></b>";
        this.statusLabel.setText(this.statusPrefix);
    }

    private void upLevel() {
        if (this.indices[5] != -1) {
            this.indices[4] = -1;
            this.indices[5] = -1;
        } else if (this.indices[2] != -1) {
            this.indices[2] = -1;
            this.indices[3] = -1;
        } else {
            this.indices[0] = -1;
            this.indices[1] = -1;
        }
        this.descriptor.setSegment(this.encodeSegment(this.indices));
        this.rebuildTable();
    }

    private boolean displayPlainTable() {
        String prefix = Segment.getPathPrefix(this.indices);
        int i = prefix.length();
        ArrayList channels = new ArrayList();
        for (Map.Entry e : this.data.entrySet()) {
            String string = (String)e.getKey();
            if (!string.startsWith(prefix) || !this.group.equals(this.getGroup(string))) continue;
            channels.addAll(((DisplayChannel)e.getValue()).getChannels());
        }
        if (channels.isEmpty()) {
            return false;
        }
        TreeMap<String, DisplayChannelSingle> tableData = new TreeMap<String, DisplayChannelSingle>();
        for (AgentChannel agentChannel : channels) {
            tableData.put(agentChannel.getPath(), new DisplayChannelSingle(agentChannel.getPath(), agentChannel, null));
        }
        this.plainTableChannels = new ArrayList<DisplayChannel>(channels.size());
        for (Map.Entry entry : tableData.entrySet()) {
            this.plainTableChannels.add((DisplayChannel)entry.getValue());
        }
        this.plainTable = SectionedTable.getInstance(tableData.entrySet(), this.filterPlainFields, null);
        this.plainTableScrollPane.setViewportView(this.plainTable.getTable());
        if (this.plainTableScrollPane.getParent() == null) {
            this.rootPanel.remove(this.centerPanel);
            this.rootPanel.add((Component)this.plainTableScrollPane, "Center");
        }
        return true;
    }

    @Override
    public List<String> getGroups() {
        List out = FocalPlaneView.super.getGroups();
        if (out == null) {
            out = super.getGroups();
        }
        return out;
    }

    private Model buildModel() {
        Model model = new Model();
        if (!this.data.isEmpty() && this.group != null) {
            int[] ind;
            if (this.indices[2] == -1) {
                ind = this.indices;
            } else {
                ind = Arrays.copyOf(this.indices, 6);
                ind[2] = -1;
            }
            int switchToReb = 0;
            String pref = Segment.getPathPrefix(ind);
            for (Map.Entry e : this.data.entrySet()) {
                int[] ii;
                String path = (String)e.getKey();
                if (!path.startsWith(pref) || !this.group.equals(this.getGroup(path)) || (ii = Segment.getIndices(path)) == null) continue;
                try {
                    Cell cell = null;
                    switch (this.level) {
                        case RAFT: {
                            if (switchToReb < 2) {
                                if (ii[2] == -1) {
                                    switchToReb = 2;
                                } else if (ii[3] == -1) {
                                    switchToReb = 1;
                                }
                            }
                            cell = model.cells[4 - ii[0]][ii[1]];
                            break;
                        }
                        case REB: {
                            if (ii[2] == -1) {
                                model.destroy();
                                return null;
                            }
                            int row = ii[0] == 0 && (ii[1] == 0 || ii[1] == 4) ? 12 + ii[2] : (ii[0] == 4 && (ii[1] == 0 || ii[1] == 4) ? 2 - ii[2] : 14 - (ii[0] * 3 + ii[2]));
                            cell = model.cells[row][ii[1]];
                            break;
                        }
                        case CCD: {
                            if (ii[3] == -1) {
                                model.destroy();
                                return null;
                            }
                            if (ii[0] == 0 && ii[1] == 0) {
                                if (ii[2] == 0) {
                                    cell = model.cells[0][2];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[1][2] : model.cells[0][1];
                                break;
                            }
                            if (ii[0] == 0 && ii[1] == 4) {
                                if (ii[2] == 0) {
                                    cell = model.cells[0][0];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[0][1] : model.cells[1][0];
                                break;
                            }
                            if (ii[0] == 4 && ii[1] == 0) {
                                if (ii[2] == 0) {
                                    cell = model.cells[2][2];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[2][1] : model.cells[1][2];
                                break;
                            }
                            if (ii[0] == 4 && ii[1] == 4) {
                                if (ii[2] == 0) {
                                    cell = model.cells[2][0];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[1][0] : model.cells[2][1];
                                break;
                            }
                            cell = model.cells[2 - ii[2]][ii[3]];
                            break;
                        }
                        case AMP: {
                            if (ii[4] == -1) {
                                model.destroy();
                                return null;
                            }
                            if (ii[0] == 0 && ii[1] == 0) {
                                if (ii[2] == 0) {
                                    cell = ii[3] == 0 ? model.cells[0][ii[5]] : model.cells[1][7 - ii[5]];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[7 - ii[5]][1 - ii[4]] : model.cells[ii[4]][7 - ii[5]];
                                break;
                            }
                            if (ii[0] == 0 && ii[1] == 4) {
                                if (ii[2] == 0) {
                                    cell = ii[3] == 0 ? model.cells[7 - ii[5]][0] : model.cells[ii[5]][1];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[ii[4]][7 - ii[5]] : model.cells[ii[5]][ii[4]];
                                break;
                            }
                            if (ii[0] == 4 && ii[1] == 0) {
                                if (ii[2] == 0) {
                                    cell = ii[3] == 0 ? model.cells[ii[5]][1] : model.cells[7 - ii[5]][0];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[1 - ii[4]][ii[5]] : model.cells[7 - ii[5]][1 - ii[4]];
                                break;
                            }
                            if (ii[0] == 4 && ii[1] == 4) {
                                if (ii[2] == 0) {
                                    cell = ii[3] == 0 ? model.cells[1][7 - ii[5]] : model.cells[0][ii[5]];
                                    break;
                                }
                                cell = ii[3] == 0 ? model.cells[ii[5]][ii[4]] : model.cells[1 - ii[4]][ii[5]];
                                break;
                            }
                            cell = model.cells[1 - ii[4]][ii[5]];
                        }
                    }
                    DisplayChannel dc = (DisplayChannel)e.getValue();
                    ((ArrayList)cell.getChannels()).add(dc);
                    dc.setTarget((Updatable)cell);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            if (switchToReb == 1) {
                model.destroy();
                return null;
            }
        }
        model.trimToSize();
        return model;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Descriptor save() {
        this.descriptor.setSegment(this.indices == null ? null : this.encodeSegment(this.indices));
        this.descriptor.setGroup(this.group);
        return this.descriptor.clone();
    }

    private Integer encodeSegment(int[] indices) {
        int out = 0;
        int shift = 1;
        for (int i = 0; i < 4; ++i) {
            int k = indices[i];
            if (k == -1) {
                k = 9;
            }
            out += k * shift;
            shift *= 10;
        }
        return out == 9999 ? null : Integer.valueOf(out);
    }

    private int[] decodeSegment(Integer code) {
        int[] out = new int[]{-1, -1, -1, -1, -1, -1};
        if (code == null) {
            return out;
        }
        for (int i = 0; i < 4; ++i) {
            int k = code % 10;
            if (k != 9) {
                out[i] = k;
            }
            code = code / 10;
        }
        return out;
    }

    public static class Descriptor
    extends FocalPlaneView.Descriptor {
        private String group;
        private String field;
        private Integer segment;

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Integer getSegment() {
            return this.segment;
        }

        public void setSegment(Integer segment) {
            this.segment = segment;
        }

        public Descriptor clone() {
            return (Descriptor)super.clone();
        }
    }

    private final class Table
    extends JTable {
        private final Dimension prefSize;

        Table() {
            super(new Model(0, 0));
            this.prefSize = new Dimension(0, 0);
            this.setDefaultRenderer(FormattedValue.class, (TableCellRenderer)new MonitorTableCellRenderer());
            this.setCellSelectionEnabled(true);
            this.setShowGrid(true);
            this.setFillsViewportHeight(true);
            this.setBorder(BorderFactory.createLineBorder(this.gridColor));
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Table.this.mouseClick(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    Table.this.setSegmentString(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DiagramView.this.statusLabel.setText(DiagramView.this.statusPrefix);
                }
            };
            this.addMouseMotionListener(mouseListener);
            this.addMouseListener(mouseListener);
        }

        @Override
        public Model getModel() {
            return (Model)super.getModel();
        }

        @Override
        public Dimension getPreferredSize() {
            int h;
            int w;
            Container parent = this.getParent();
            if (parent == null) {
                return new Dimension(0, 0);
            }
            int nRows = this.getRowCount();
            if (DiagramView.this.level == Segment.AMP) {
                Dimension p = super.getPreferredSize();
                w = Math.min(p.width, parent.getWidth());
                h = Math.min(parent.getHeight(), w);
            } else {
                h = w = Math.min(parent.getWidth(), parent.getHeight());
            }
            if (nRows > 0) {
                int rowH = h / nRows;
                h = rowH * nRows;
                this.setRowHeight(rowH);
            }
            this.prefSize.height = h;
            this.prefSize.width = w;
            return this.prefSize;
        }

        private void mouseClick(MouseEvent e) {
            int y;
            int nClick = e.getClickCount();
            Point point = e.getPoint();
            Table table = (Table)e.getSource();
            int x = table.rowAtPoint(point);
            Cell cell = table.getModel().cells[x][y = table.columnAtPoint(point)];
            if (((ArrayList)cell.getChannels()).isEmpty()) {
                return;
            }
            x = table.getRowCount() - x - 1;
            if (nClick == 2) {
                switch (DiagramView.this.level) {
                    case RAFT: {
                        ((DiagramView)DiagramView.this).indices[0] = x;
                        ((DiagramView)DiagramView.this).indices[1] = y;
                        break;
                    }
                    case REB: {
                        ((DiagramView)DiagramView.this).indices[0] = x / 3;
                        ((DiagramView)DiagramView.this).indices[1] = y;
                        if (DiagramView.this.indices[0] == 0 && (DiagramView.this.indices[1] == 0 || DiagramView.this.indices[1] == 4)) {
                            ((DiagramView)DiagramView.this).indices[2] = 2 - x;
                            break;
                        }
                        ((DiagramView)DiagramView.this).indices[2] = x % 3;
                        break;
                    }
                    case CCD: {
                        if (DiagramView.this.indices[0] == 0 && DiagramView.this.indices[1] == 0) {
                            if (x == 2 && y == 2) {
                                ((DiagramView)DiagramView.this).indices[2] = 0;
                                break;
                            }
                            ((DiagramView)DiagramView.this).indices[2] = 1;
                            ((DiagramView)DiagramView.this).indices[3] = x == 2 ? 1 : 0;
                            break;
                        }
                        if (DiagramView.this.indices[0] == 0 && DiagramView.this.indices[1] == 4) {
                            if (x == 2 && y == 0) {
                                ((DiagramView)DiagramView.this).indices[2] = 0;
                                break;
                            }
                            ((DiagramView)DiagramView.this).indices[2] = 1;
                            ((DiagramView)DiagramView.this).indices[3] = x == 2 ? 0 : 1;
                            break;
                        }
                        if (DiagramView.this.indices[0] == 4 && DiagramView.this.indices[1] == 0) {
                            if (x == 0 && y == 2) {
                                ((DiagramView)DiagramView.this).indices[2] = 0;
                                break;
                            }
                            ((DiagramView)DiagramView.this).indices[2] = 1;
                            ((DiagramView)DiagramView.this).indices[3] = x == 0 ? 0 : 1;
                            break;
                        }
                        if (DiagramView.this.indices[0] == 4 && DiagramView.this.indices[1] == 4) {
                            if (x == 0 && y == 0) {
                                ((DiagramView)DiagramView.this).indices[2] = 0;
                                break;
                            }
                            ((DiagramView)DiagramView.this).indices[2] = 1;
                            ((DiagramView)DiagramView.this).indices[3] = x == 0 ? 1 : 0;
                            break;
                        }
                        ((DiagramView)DiagramView.this).indices[2] = x;
                        ((DiagramView)DiagramView.this).indices[3] = y;
                        break;
                    }
                    case AMP: {
                        ((DiagramView)DiagramView.this).indices[4] = x;
                        ((DiagramView)DiagramView.this).indices[5] = y;
                    }
                }
                DiagramView.this.descriptor.setSegment(DiagramView.this.encodeSegment(DiagramView.this.indices));
                DiagramView.this.rebuildTable();
            }
        }

        private void setSegmentString(MouseEvent e) {
            Point point = e.getPoint();
            Table table = (Table)e.getSource();
            int x = table.getRowCount() - table.rowAtPoint(point) - 1;
            int y = table.columnAtPoint(point);
            switch (DiagramView.this.level) {
                case RAFT: {
                    DiagramView.this.statusLabel.setText(DiagramView.this.statusPrefix + Segment.RAFT.toString() + x + y);
                    break;
                }
                case REB: {
                    int raftX = x / 3;
                    x %= 3;
                    int raftY = y;
                    String reb = null;
                    if (raftX == 0 && (raftY == 0 || raftY == 4)) {
                        if (x == 1) {
                            reb = "G";
                        } else if (x == 2) {
                            reb = "W";
                        }
                    } else if (raftX == 4 && (raftY == 0 || raftY == 4)) {
                        if (x == 1) {
                            reb = "G";
                        } else if (x == 0) {
                            reb = "W";
                        }
                    } else {
                        reb = Integer.toString(x);
                    }
                    StringBuilder sb = new StringBuilder(DiagramView.this.statusPrefix);
                    if (reb != null) {
                        sb.append((Object)Segment.RAFT).append(raftX).append(raftY).append("/").append((Object)Segment.REB).append(reb);
                    }
                    DiagramView.this.statusLabel.setText(sb.toString());
                    break;
                }
                case CCD: {
                    String s = null;
                    if (DiagramView.this.indices[0] == 0 && DiagramView.this.indices[1] == 0) {
                        if (x == 2 && y == 2) {
                            s = (Object)((Object)Segment.REB) + "W/" + (Object)((Object)Segment.CCD) + "W";
                        } else if (x == 2 && y == 1) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G1";
                        } else if (x == 1 && y == 2) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G0";
                        }
                    } else if (DiagramView.this.indices[0] == 0 && DiagramView.this.indices[1] == 4) {
                        if (x == 2 && y == 0) {
                            s = Segment.REB.toString() + "W";
                        } else if (x == 1 && y == 0) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G1";
                        } else if (x == 2 && y == 1) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G0";
                        }
                    } else if (DiagramView.this.indices[0] == 4 && DiagramView.this.indices[1] == 0) {
                        if (x == 0 && y == 2) {
                            s = Segment.REB.toString() + "W";
                        } else if (x == 1 && y == 2) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G1";
                        } else if (x == 0 && y == 1) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G0";
                        }
                    } else if (DiagramView.this.indices[0] == 4 && DiagramView.this.indices[1] == 4) {
                        if (x == 0 && y == 0) {
                            s = (Object)((Object)Segment.REB) + "W/" + (Object)((Object)Segment.CCD) + "W";
                        } else if (x == 0 && y == 1) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G1";
                        } else if (x == 1 && y == 0) {
                            s = (Object)((Object)Segment.REB) + "G/" + (Object)((Object)Segment.CCD) + "G0";
                        }
                    } else {
                        s = Segment.REB.toString() + x + "/" + (Object)((Object)Segment.CCD) + x + y;
                    }
                    DiagramView.this.statusLabel.setText(s == null ? DiagramView.this.statusPrefix : DiagramView.this.statusPrefix + s);
                    break;
                }
                case AMP: {
                    DiagramView.this.statusLabel.setText(DiagramView.this.statusPrefix + (Object)((Object)Segment.AMP) + x + y);
                }
            }
        }
    }

    private class Model
    extends AbstractTableModel {
        int nRows;
        int nColumns;
        Cell[][] cells;

        Model(int rows, int columns) {
            this.nRows = rows;
            this.nColumns = columns;
            this.cells = new Cell[this.nRows][this.nColumns];
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    this.cells[row][col] = new Cell();
                }
            }
        }

        Model() {
            switch (DiagramView.this.level) {
                case RAFT: {
                    this.nRows = 5;
                    this.nColumns = 5;
                    break;
                }
                case REB: {
                    this.nRows = 15;
                    this.nColumns = 5;
                    break;
                }
                case CCD: {
                    this.nRows = 3;
                    this.nColumns = 3;
                    break;
                }
                case AMP: {
                    boolean vertical = true;
                    if (DiagramView.this.indices[0] == 0) {
                        if (DiagramView.this.indices[1] == 0) {
                            if (DiagramView.this.indices[2] == 1 && DiagramView.this.indices[3] == 0) {
                                vertical = false;
                            }
                        } else if (DiagramView.this.indices[1] == 4 && (DiagramView.this.indices[2] == 0 || DiagramView.this.indices[2] == 1 && DiagramView.this.indices[3] == 1)) {
                            vertical = false;
                        }
                    } else if (DiagramView.this.indices[0] == 4) {
                        if (DiagramView.this.indices[1] == 0) {
                            if (DiagramView.this.indices[2] == 0 || DiagramView.this.indices[2] == 1 && DiagramView.this.indices[3] == 1) {
                                vertical = false;
                            }
                        } else if (DiagramView.this.indices[1] == 4 && DiagramView.this.indices[2] == 1 && DiagramView.this.indices[3] == 0) {
                            vertical = false;
                        }
                    }
                    this.nRows = vertical ? 2 : 8;
                    this.nColumns = vertical ? 8 : 2;
                }
            }
            this.cells = new Cell[this.nRows][this.nColumns];
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    this.cells[row][col] = new Cell();
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.nRows;
        }

        @Override
        public int getColumnCount() {
            return this.nColumns;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Cell cell = this.cells[rowIndex][columnIndex];
            FormattedValue fv = cell.getFormattedValue();
            if (fv == null) {
                MonitorFormat.DEFAULT.format((MonitorCell)cell);
                fv = cell.getFormattedValue();
            }
            return fv;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return FormattedValue.class;
        }

        void destroy() {
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    Cell cell = this.cells[row][col];
                    for (DisplayChannel dc : cell.getChannels()) {
                        dc.setTarget(null);
                    }
                }
            }
        }

        void clear() {
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    this.cells[row][col].setFormattedValue(null);
                }
            }
            this.fireTableDataChanged();
        }

        void trimToSize() {
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    ((ArrayList)this.cells[row][col].getChannels()).trimToSize();
                }
            }
        }
    }

    private class Cell
    implements MonitorCell,
    Updatable {
        private final ArrayList<DisplayChannel> channels;
        private FormattedValue formattedValue;

        Cell(ArrayList<DisplayChannel> channels) {
            this.channels = channels;
        }

        Cell() {
            this.channels = new ArrayList();
        }

        public ArrayList<DisplayChannel> getChannels() {
            return this.channels;
        }

        public MonitorField getField() {
            return DiagramView.this.field;
        }

        public FormattedValue getFormattedValue() {
            return this.formattedValue;
        }

        public void setFormattedValue(FormattedValue formattedValue) {
            if (formattedValue != null) {
                formattedValue.horizontalAlignment = 0;
            }
            this.formattedValue = formattedValue;
        }

        public void update(DisplayChannel channelHandle) {
            this.formattedValue = null;
        }
    }
}

