/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;
import org.lsst.ccs.subsystem.refrig.data.ChillerControlState;

public class ChillerControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private static final String CMND_GET_STATE = "getControlState";
    private static final Map<ChillerState, Color> stateColors = new HashMap<ChillerState, Color>();
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private JPanel mainPanel;
    private JPanel chillerStatePnl;
    private JLabel chillerStateLbl;
    private TextFieldX flowRateTf;
    private TextFieldX tankPressTf;
    private TextFieldX tempSetPointTf;
    private JLabel defaultRampLbl;
    private TextFieldX tempWithRampTf;
    private TextFieldX rampRateTf;
    private JButton quitControlBtn;
    private double flowRate;
    private double tankPress;
    private double tempSetPoint;
    private double rampRate;
    private static final long serialVersionUID = 1L;

    public ChillerControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((ChillerControlState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void onCommandError(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(ChillerControlState cs) {
        SwingUtilities.invokeLater(new UpdateChillerState(cs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.chillerStateLbl = UiUtilities.newLabel((String)"XXXXX", (int)UiUtilities.maxEnumLabelWidth(ChillerState.class));
        this.flowRateTf = this.uiUtils.newTextFieldX("999999.9", "F", 2);
        this.flowRateTf.update((Object)this.flowRate, true);
        this.tankPressTf = this.uiUtils.newTextFieldX("999999.9", "P", 2);
        this.tankPressTf.update((Object)this.tankPress, true);
        this.tempSetPointTf = this.uiUtils.newTextFieldX("999999.9", "T", 2);
        this.tempSetPointTf.update((Object)this.tempSetPoint, true);
        this.defaultRampLbl = UiUtilities.newLabel((String)"99999.9", (int)0);
        this.defaultRampLbl.setHorizontalAlignment(0);
        this.defaultRampLbl.setText("0.0");
        this.tempWithRampTf = this.uiUtils.newTextFieldX("999999.9", "U", 2);
        this.tempWithRampTf.update((Object)this.tempSetPoint, true);
        this.rampRateTf = this.uiUtils.newTextFieldX("99999.9", "R", 2);
        this.rampRateTf.update((Object)this.rampRate, true);
        this.quitControlBtn = this.uiUtils.newButton("Quit", "Q", false);
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.chillerStatePnl = new JPanel();
        this.chillerStatePnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 4, 0, 4);
        this.chillerStatePnl.add((Component)UiUtilities.newLabel((String)"Chiller state:", (int)0), gbc);
        ++gbc.gridx;
        this.chillerStatePnl.add((Component)this.chillerStateLbl, gbc);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 17;
        gbm.insets = new Insets(0, 0, 4, 5);
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Flow rate:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.flowRateTf, gbm);
        ++gbm.gridx;
        gbm.gridwidth = 2;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"gal/min", (int)0), gbm);
        gbm.gridwidth = 1;
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Tank pressure:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tankPressTf, gbm);
        ++gbm.gridx;
        gbm.gridwidth = 2;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"psig", (int)0), gbm);
        gbm.gridwidth = 1;
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Temperature:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tempSetPointTf, gbm);
        ++gbm.gridx;
        gbm.insets.right = 20;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C", (int)0), gbm);
        ++gbm.gridx;
        gbm.insets.right = 5;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Default ramp:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.defaultRampLbl, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C/min", (int)0), gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Temp with ramp:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.tempWithRampTf, gbm);
        ++gbm.gridx;
        gbm.insets.right = 20;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C", (int)0), gbm);
        ++gbm.gridx;
        gbm.insets.right = 5;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Ramp:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.rampRateTf, gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"C/min", (int)0), gbm);
        gbm.gridx = 0;
        ++gbm.gridy;
        this.mainPanel.add((Component)UiUtilities.newLabel((String)"Quit controlling:", (int)0), gbm);
        ++gbm.gridx;
        this.mainPanel.add((Component)this.quitControlBtn, gbm);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 4, 0, 0);
        gbp.anchor = 11;
        gbp.gridx = 0;
        gbp.gridy = 0;
        this.add((Component)this.statusPanel, gbp);
        ++gbp.gridy;
        gbp.insets.bottom = 8;
        this.add((Component)this.chillerStatePnl, gbp);
        ++gbp.gridy;
        gbp.insets.bottom = 4;
        this.add((Component)this.mainPanel, gbp);
    }

    public void handleTextFieldX(String name, Object value) {
        switch (name) {
            case "F": {
                this.flowRate = (Double)value;
                this.sender.sendCommand(null, "setFlow", new Object[]{this.flowRate});
                break;
            }
            case "P": {
                this.tankPress = (Double)value;
                this.sender.sendCommand(null, "setTankPressure", new Object[]{this.tankPress});
                break;
            }
            case "T": {
                this.tempSetPoint = (Double)value;
                this.sender.sendCommand(null, "setTemperature", new Object[]{this.tempSetPoint});
                break;
            }
            case "U": {
                this.tempSetPoint = (Double)value;
                this.sender.sendCommand(null, "setTemperatureWithRamp", new Object[]{this.tempSetPoint, this.rampRate});
                break;
            }
            case "R": {
                this.rampRate = (Double)value;
                this.rampRateTf.update(value, true);
            }
        }
    }

    public void handleButton(String name) {
        switch (name) {
            case "Q": {
                this.sender.sendCommand(null, "quitControllingTemperature", new Object[0]);
            }
        }
    }

    static {
        stateColors.put(ChillerState.OFFLINE, UiConstants.BLUE);
        stateColors.put(ChillerState.SETPOINT, UiConstants.GREEN);
        stateColors.put(ChillerState.CONTROLLING, UiConstants.YELLOW);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            ChillerControlPanel.this.statusPanel.disablePanel();
            ChillerControlPanel.this.flowRateTf.setDisabled();
            ChillerControlPanel.this.tankPressTf.setDisabled();
            ChillerControlPanel.this.tempSetPointTf.setDisabled();
            ChillerControlPanel.this.tempWithRampTf.setDisabled();
            ChillerControlPanel.this.rampRateTf.setDisabled();
            ChillerControlPanel.this.quitControlBtn.setEnabled(false);
            ChillerControlPanel.this.repaint();
        }
    }

    class UpdateChillerState
    implements Runnable {
        private final ChillerControlState cs;

        UpdateChillerState(ChillerControlState cs) {
            this.cs = cs;
        }

        @Override
        public void run() {
            ChillerControlPanel.this.statusPanel.updatePanel(this.cs.getFastPeriod());
            ChillerControlPanel.this.chillerStateLbl.setText(this.cs.getChillerState().name());
            ChillerControlPanel.this.chillerStateLbl.setForeground(stateColors.getOrDefault(this.cs.getChillerState(), Color.BLACK));
            if (!Double.isNaN(this.cs.getFlowSet())) {
                ChillerControlPanel.this.flowRate = this.cs.getFlowSet();
            }
            ChillerControlPanel.this.flowRateTf.update((Object)ChillerControlPanel.this.flowRate, true);
            if (!Double.isNaN(this.cs.getTankSet())) {
                ChillerControlPanel.this.tankPress = this.cs.getTankSet();
            }
            ChillerControlPanel.this.tankPressTf.update((Object)ChillerControlPanel.this.tankPress, true);
            if (!Double.isNaN(this.cs.getSetPoint())) {
                ChillerControlPanel.this.tempSetPoint = this.cs.getSetPoint();
            }
            ChillerControlPanel.this.tempSetPointTf.update((Object)ChillerControlPanel.this.tempSetPoint, true);
            if (!Double.isNaN(this.cs.getDefaultRamp())) {
                ChillerControlPanel.this.defaultRampLbl.setText(String.valueOf(this.cs.getDefaultRamp()));
            }
            ChillerControlPanel.this.tempWithRampTf.update((Object)ChillerControlPanel.this.tempSetPoint, true);
            ChillerControlPanel.this.rampRateTf.update((Object)ChillerControlPanel.this.rampRate, true);
            ChillerControlPanel.this.quitControlBtn.setEnabled(true);
            ChillerControlPanel.this.repaint();
        }
    }
}

