/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IFitParameterSettings;
import hep.aida.IFitResult;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IModelFunction;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.IRangeSet;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.histogram.Cloud;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Cloud3D;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.VariableAxis;
import hep.aida.ref.tuple.AbstractTuple;
import hep.aida.ref.tuple.Tuple;
import hep.aida.ref.xml.AidaObjectProxy;
import hep.aida.ref.xml.ascii.AidaAsciiXMLWriter;
import hep.aida.ref.xml.binary.AidaWBXML;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.freehep.wbxml.WBXMLTagWriter;
import org.freehep.wbxml.WBXMLWriter;

public class AidaXMLWriter {
    protected String[] skip;
    protected WBXMLTagWriter xml;
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";

    public AidaXMLWriter(Writer writer) throws IOException {
        this(writer, null);
    }

    AidaXMLWriter(Writer writer, String[] skip) throws IOException {
        this.xml = new AidaAsciiXMLWriter(writer);
        this.xml.openDoc("1.0", "ISO-8859-1", false);
        this.init(skip);
    }

    AidaXMLWriter(DataOutputStream dos) throws IOException {
        this(dos, null);
    }

    AidaXMLWriter(DataOutputStream dos, String[] skip) throws IOException {
        this.xml = new WBXMLWriter((OutputStream)dos, AidaWBXML.attributes.length - 1);
        this.xml.openDoc("BinaryAIDA/1.0", "UTF-8", false);
        this.init(skip);
    }

    private void init(String[] skip) throws IOException {
        this.skip = skip;
        this.xml.referToDTD("aida", "http://aida.freehep.org/schemas/3.3/aida.dtd");
        this.xml.setAttribute(0, "3.3");
        this.xml.openTag(0);
        this.xml.setAttribute(13, "FreeHEP");
        this.xml.setAttribute(0, "1.1");
        this.xml.printTag(1);
    }

    public void close() throws IOException {
        this.xml.closeTag();
        this.xml.close();
    }

    void toXML(ITree tree) {
        String[] objNames = tree.listObjectNames("/", true);
        String[] objTypes = null;
        if (this.skip != null && this.skip.length > 0) {
            objTypes = tree.listObjectTypes("/", true);
        }
        for (int i = 0; i < objNames.length; ++i) {
            if (objNames[i].endsWith("/") && !objNames[i].endsWith("\\/")) continue;
            String dirName = AidaUtils.parseDirName(objNames[i]);
            if (this.skip != null && this.skip.length > 0 && AidaUtils.findInArray(objTypes[i], this.skip) >= 0) continue;
            IManagedObject obj = tree.find(objNames[i]);
            if (obj instanceof AidaObjectProxy.ObjectProvider) {
                obj = ((AidaObjectProxy.ObjectProvider)obj).getManagedObject();
            }
            this.toXML(obj, dirName);
        }
    }

    public void toXML(IManagedObject o, String path) {
        try {
            if (o != null && this.skip != null && this.skip.length > 0 && AidaUtils.findInArray(o.type(), this.skip) >= 0) {
                return;
            }
            if (o instanceof AidaObjectProxy.ObjectProvider) {
                o = ((AidaObjectProxy.ObjectProvider)o).getManagedObject();
            }
            if (o instanceof IHistogram1D) {
                this.toXML((IHistogram1D)o, path);
            } else if (o instanceof IHistogram2D) {
                this.toXML((IHistogram2D)o, path);
            } else if (o instanceof IHistogram3D) {
                this.toXML((IHistogram3D)o, path);
            } else if (o instanceof ICloud1D) {
                this.toXML((ICloud1D)o, path);
            } else if (o instanceof ICloud2D) {
                this.toXML((ICloud2D)o, path);
            } else if (o instanceof ICloud3D) {
                this.toXML((ICloud3D)o, path);
            } else if (o instanceof ITuple) {
                this.toXML((ITuple)o, path);
            } else if (o instanceof IDataPointSet) {
                this.toXML((IDataPointSet)o, path);
            } else if (o instanceof IProfile1D) {
                this.toXML((IProfile1D)o, path);
            } else if (o instanceof IProfile2D) {
                this.toXML((IProfile2D)o, path);
            } else if (o instanceof IFunction) {
                this.toXML((IFunction)o, path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void toXML(IFitResult f, String path) throws IOException {
        String[] names;
        String[] con;
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        this.xml.setAttribute(73, f.fittedParameterNames().length);
        this.xml.setAttribute(74, f.engineName());
        this.xml.setAttribute(75, f.fitMethodName());
        this.xml.setAttribute(76, f.isValid());
        this.xml.setAttribute(77, f.quality());
        this.xml.setAttribute(78, f.fitStatus());
        this.xml.setAttribute(79, f.ndf());
        this.xml.setAttribute(80, f.dataDescription());
        this.xml.openTag(45);
        if (f.fittedFunction() != null) {
            this.toXML(f.fittedFunction(), path);
        }
        if ((con = f.constraints()) != null && con.length > 0) {
            this.writeFitConstrains(con);
        }
        if ((names = f.fittedParameterNames()) != null && names.length > 0) {
            this.writeFittedParameters(f);
            this.writeFitCovarianceMatrix(f);
        }
        this.xml.closeTag();
    }

    private void writeFittedParameters(IFitResult f) throws IOException {
        String[] names = f.fittedParameterNames();
        double[] vals = f.fittedParameters();
        double[] ep = f.errorsPlus();
        double[] em = f.errorsMinus();
        for (int i = 0; i < names.length; ++i) {
            this.xml.setAttribute(81, names[i]);
            this.xml.setAttribute(82, vals[i]);
            this.xml.setAttribute(83, ep[i]);
            if (ep[i] != em[i]) {
                this.xml.setAttribute(84, em[i]);
            }
            IFitParameterSettings fps = f.fitParameterSettings(names[i]);
            this.xml.setAttribute(85, fps.isFixed());
            double stepSize = fps.stepSize();
            if (!Double.isNaN(stepSize)) {
                this.xml.setAttribute(86, stepSize);
            }
            if (fps.isBound()) {
                if (!Double.isNaN(fps.lowerBound())) {
                    this.xml.setAttribute(87, fps.lowerBound());
                }
                if (!Double.isNaN(fps.upperBound())) {
                    this.xml.setAttribute(88, fps.upperBound());
                }
            }
            this.xml.printTag(46);
        }
    }

    private void writeFitCovarianceMatrix(IFitResult f) throws IOException {
        String[] names = f.fittedParameterNames();
        this.xml.openTag(47);
        for (int i = 0; i < names.length; ++i) {
            for (int j = 0; j < names.length; ++j) {
                this.xml.setAttribute(89, i);
                this.xml.setAttribute(90, j);
                this.xml.setAttribute(91, f.covMatrixElement(i, j));
                this.xml.printTag(48);
            }
        }
        this.xml.closeTag();
    }

    private void writeFitConstrains(String[] con) throws IOException {
        if (con == null) {
            return;
        }
        for (int i = 0; i < con.length; ++i) {
            if (con[i] == null || con[i].trim().equals("")) continue;
            this.xml.setAttribute(92, con[i]);
            this.xml.printTag(49);
        }
    }

    private void toXML(IHistogram1D h, String path) throws IOException {
        String name = ((IManagedObject)h).name();
        this.xml.setAttribute(14, name);
        String title = h.title();
        if (title != null && title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        this.xml.openTag(2);
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.axis(), X);
        this.xml.setAttribute(22, h.entries());
        this.xml.openTag(7);
        this.xml.setAttribute(18, X);
        this.xml.setAttribute(24, h.mean());
        this.xml.setAttribute(25, h.rms());
        this.xml.printTag(8);
        this.xml.closeTag();
        this.xml.openTag(9);
        int bins = h.axis().bins();
        for (int i = -2; i < bins; ++i) {
            double height = h.binHeight(i);
            double error = h.binError(i);
            int entries = h.binEntries(i);
            if (height == 0.0 || error == 0.0) continue;
            this.xml.setAttribute(27, i);
            if (h instanceof Histogram1D) {
                this.xml.setAttribute(28, ((Histogram1D)h).binMean(i));
                this.xml.setAttribute(29, ((Histogram1D)h).binRms(i));
            }
            if (height != (double)entries) {
                this.xml.setAttribute(30, height);
                this.xml.setAttribute(31, error);
            }
            this.xml.setAttribute(22, entries);
            this.xml.printTag(10);
        }
        this.xml.closeTag();
        this.xml.closeTag();
    }

    private void toXML(IHistogram2D h, String path) throws IOException {
        String name = ((IManagedObject)h).name();
        this.xml.setAttribute(14, name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        this.xml.openTag(3);
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.xAxis(), X);
        this.writeHistogramAxis(h.yAxis(), Y);
        this.xml.setAttribute(22, h.entries());
        this.xml.openTag(7);
        this.xml.setAttribute(18, X);
        this.xml.setAttribute(24, h.meanX());
        this.xml.setAttribute(25, h.rmsX());
        this.xml.printTag(8);
        this.xml.setAttribute(18, Y);
        this.xml.setAttribute(24, h.meanY());
        this.xml.setAttribute(25, h.rmsY());
        this.xml.printTag(8);
        this.xml.closeTag();
        this.xml.openTag(11);
        int xbins = h.xAxis().bins();
        int ybins = h.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            for (int j = -2; j < ybins; ++j) {
                double height = h.binHeight(i, j);
                double error = h.binError(i, j);
                int entries = h.binEntries(i, j);
                if (height == 0.0 || error == 0.0) continue;
                this.xml.setAttribute(33, i);
                this.xml.setAttribute(34, j);
                if (h instanceof Histogram2D) {
                    this.xml.setAttribute(36, ((Histogram2D)h).binMeanX(i, j));
                    this.xml.setAttribute(37, ((Histogram2D)h).binMeanY(i, j));
                    this.xml.setAttribute(39, ((Histogram2D)h).binRmsX(i, j));
                    this.xml.setAttribute(40, ((Histogram2D)h).binRmsY(i, j));
                }
                if (height != (double)entries) {
                    this.xml.setAttribute(30, height);
                    this.xml.setAttribute(31, error);
                }
                this.xml.setAttribute(22, entries);
                this.xml.printTag(12);
            }
        }
        this.xml.closeTag();
        this.xml.closeTag();
    }

    private void toXML(IHistogram3D h, String path) throws IOException {
        String name = ((IManagedObject)h).name();
        this.xml.setAttribute(14, name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        this.xml.openTag(4);
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.xAxis(), X);
        this.writeHistogramAxis(h.yAxis(), Y);
        this.writeHistogramAxis(h.zAxis(), Z);
        this.xml.setAttribute(22, h.entries());
        this.xml.openTag(7);
        this.xml.setAttribute(18, X);
        this.xml.setAttribute(24, h.meanX());
        this.xml.setAttribute(25, h.rmsX());
        this.xml.printTag(8);
        this.xml.setAttribute(18, Y);
        this.xml.setAttribute(24, h.meanY());
        this.xml.setAttribute(25, h.rmsY());
        this.xml.printTag(8);
        this.xml.setAttribute(18, Z);
        this.xml.setAttribute(24, h.meanZ());
        this.xml.setAttribute(25, h.rmsZ());
        this.xml.printTag(8);
        this.xml.closeTag();
        this.xml.openTag(13);
        int xbins = h.xAxis().bins();
        int ybins = h.yAxis().bins();
        int zbins = h.zAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            for (int j = -2; j < ybins; ++j) {
                for (int k = -2; k < zbins; ++k) {
                    double height = h.binHeight(i, j, k);
                    double error = h.binError(i, j, k);
                    int entries = h.binEntries(i, j, k);
                    if (height == 0.0 || error == 0.0) continue;
                    this.xml.setAttribute(33, i);
                    this.xml.setAttribute(34, j);
                    this.xml.setAttribute(35, k);
                    if (h instanceof Histogram3D) {
                        this.xml.setAttribute(36, ((Histogram3D)h).binMeanX(i, j, k));
                        this.xml.setAttribute(37, ((Histogram3D)h).binMeanY(i, j, k));
                        this.xml.setAttribute(38, ((Histogram3D)h).binMeanZ(i, j, k));
                        this.xml.setAttribute(39, ((Histogram3D)h).binRmsX(i, j, k));
                        this.xml.setAttribute(40, ((Histogram3D)h).binRmsY(i, j, k));
                        this.xml.setAttribute(41, ((Histogram3D)h).binRmsZ(i, j, k));
                    }
                    if (height != (double)entries) {
                        this.xml.setAttribute(30, height);
                        this.xml.setAttribute(31, error);
                    }
                    this.xml.setAttribute(22, entries);
                    this.xml.printTag(14);
                }
            }
        }
        this.xml.closeTag();
        this.xml.closeTag();
    }

    private void toXML(ICloud1D c, String path) throws IOException {
        String options;
        this.xml.setAttribute(14, ((IManagedObject)c).name());
        this.xml.setAttribute(43, ((Cloud)c).maxEntries());
        String title = c.title();
        if (title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        if ((options = ((Cloud)c).getOptions()) != null && !options.equals("")) {
            this.xml.setAttribute(17, options);
        }
        if (c instanceof Cloud1D) {
            double ue;
            Cloud1D cl = (Cloud1D)c;
            this.xml.setAttribute(50, cl.conversionBins());
            double le = cl.conversionLowerEdge();
            if (!Double.isNaN(le)) {
                this.xml.setAttribute(54, le);
            }
            if (!Double.isNaN(ue = cl.conversionUpperEdge())) {
                this.xml.setAttribute(58, ue);
            }
        }
        IHistogram1D hist = null;
        try {
            hist = c.histogram();
            this.xml.setAttribute(44, c.lowerEdge());
            this.xml.setAttribute(47, c.upperEdge());
        }
        catch (RuntimeException le) {
            // empty catch block
        }
        this.xml.openTag(22);
        IAnnotation annotation = c.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        if (hist != null) {
            this.toXML(hist, path);
        } else {
            this.xml.openTag(25);
            for (int i = 0; i < c.entries(); ++i) {
                this.xml.setAttribute(62, c.value(i));
                double w = c.weight(i);
                if (w != 1.0) {
                    this.xml.setAttribute(65, w);
                }
                this.xml.printTag(28);
            }
            this.xml.closeTag();
        }
        this.xml.closeTag();
    }

    private void toXML(ICloud2D c, String path) throws IOException {
        String options;
        this.xml.setAttribute(14, ((IManagedObject)c).name());
        this.xml.setAttribute(43, ((Cloud)c).maxEntries());
        String title = c.title();
        if (title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        if ((options = ((Cloud)c).getOptions()) != null && !options.equals("")) {
            this.xml.setAttribute(17, options);
        }
        if (c instanceof Cloud2D) {
            double uey;
            double uex;
            Cloud2D cl = (Cloud2D)c;
            this.xml.setAttribute(51, cl.conversionBinsX());
            double lex = cl.conversionLowerEdgeX();
            if (!Double.isNaN(lex)) {
                this.xml.setAttribute(55, lex);
            }
            if (!Double.isNaN(uex = cl.conversionUpperEdgeX())) {
                this.xml.setAttribute(59, uex);
            }
            this.xml.setAttribute(52, cl.conversionBinsY());
            double ley = cl.conversionLowerEdgeY();
            if (!Double.isNaN(ley)) {
                this.xml.setAttribute(56, ley);
            }
            if (!Double.isNaN(uey = cl.conversionUpperEdgeY())) {
                this.xml.setAttribute(60, uey);
            }
        }
        IHistogram2D hist = null;
        try {
            hist = c.histogram();
            this.xml.setAttribute(44, c.lowerEdgeX());
            this.xml.setAttribute(47, c.upperEdgeX());
            this.xml.setAttribute(45, c.lowerEdgeY());
            this.xml.setAttribute(48, c.upperEdgeY());
        }
        catch (RuntimeException lex) {
            // empty catch block
        }
        this.xml.openTag(23);
        IAnnotation annotation = c.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        if (hist != null) {
            this.toXML(hist, path);
        } else {
            this.xml.openTag(26);
            for (int i = 0; i < c.entries(); ++i) {
                this.xml.setAttribute(62, c.valueX(i));
                this.xml.setAttribute(63, c.valueY(i));
                double w = c.weight(i);
                if (w != 1.0) {
                    this.xml.setAttribute(65, w);
                }
                this.xml.printTag(29);
            }
            this.xml.closeTag();
        }
        this.xml.closeTag();
    }

    private void toXML(ICloud3D c, String path) throws IOException {
        String options;
        this.xml.setAttribute(14, ((IManagedObject)c).name());
        this.xml.setAttribute(43, ((Cloud)c).maxEntries());
        String title = c.title();
        if (title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        if ((options = ((Cloud)c).getOptions()) != null && !options.equals("")) {
            this.xml.setAttribute(17, options);
        }
        if (c instanceof Cloud3D) {
            double uez;
            double uey;
            double uex;
            Cloud3D cl = (Cloud3D)c;
            this.xml.setAttribute(51, cl.conversionBinsX());
            double lex = cl.conversionLowerEdgeX();
            if (!Double.isNaN(lex)) {
                this.xml.setAttribute(55, lex);
            }
            if (!Double.isNaN(uex = cl.conversionUpperEdgeX())) {
                this.xml.setAttribute(59, uex);
            }
            this.xml.setAttribute(52, cl.conversionBinsY());
            double ley = cl.conversionLowerEdgeY();
            if (!Double.isNaN(ley)) {
                this.xml.setAttribute(56, ley);
            }
            if (!Double.isNaN(uey = cl.conversionUpperEdgeY())) {
                this.xml.setAttribute(60, uey);
            }
            this.xml.setAttribute(53, cl.conversionBinsZ());
            double lez = cl.conversionLowerEdgeZ();
            if (!Double.isNaN(lez)) {
                this.xml.setAttribute(57, lez);
            }
            if (!Double.isNaN(uez = cl.conversionUpperEdgeZ())) {
                this.xml.setAttribute(61, uez);
            }
        }
        IHistogram3D hist = null;
        try {
            hist = c.histogram();
            this.xml.setAttribute(44, c.lowerEdgeX());
            this.xml.setAttribute(47, c.upperEdgeX());
            this.xml.setAttribute(45, c.lowerEdgeY());
            this.xml.setAttribute(48, c.upperEdgeY());
            this.xml.setAttribute(46, c.lowerEdgeZ());
            this.xml.setAttribute(49, c.upperEdgeZ());
        }
        catch (RuntimeException lex) {
            // empty catch block
        }
        this.xml.openTag(24);
        IAnnotation annotation = c.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        if (hist != null) {
            this.toXML(hist, path);
        } else {
            this.xml.openTag(27);
            for (int i = 0; i < c.entries(); ++i) {
                this.xml.setAttribute(62, c.valueX(i));
                this.xml.setAttribute(63, c.valueY(i));
                this.xml.setAttribute(64, c.valueZ(i));
                double w = c.weight(i);
                if (w != 1.0) {
                    this.xml.setAttribute(65, w);
                }
                this.xml.printTag(30);
            }
            this.xml.closeTag();
        }
        this.xml.closeTag();
    }

    private void toXML(ITuple tuple, String path) throws IOException {
        this.xml.setAttribute(14, ((IManagedObject)tuple).name());
        this.xml.setAttribute(15, tuple.title());
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        String options = null;
        if (tuple instanceof Tuple) {
            options = ((Tuple)tuple).getOptions();
        }
        if (options != null && !options.equals("")) {
            this.xml.setAttribute(17, options);
        }
        this.xml.openTag(15);
        IAnnotation annotation = tuple.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeTupleColumns(tuple);
        this.xml.openTag(18);
        this.writeTupleEntries(tuple);
        this.xml.closeTag();
        this.xml.closeTag();
    }

    private void toXML(IDataPointSet dps, String path) throws IOException {
        this.xml.setAttribute(14, ((IManagedObject)dps).name());
        this.xml.setAttribute(15, dps.title());
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        this.xml.setAttribute(66, dps.dimension());
        this.xml.openTag(33);
        IAnnotation annotation = dps.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        for (int i = 0; i < dps.size(); ++i) {
            IDataPoint point = dps.point(i);
            this.xml.openTag(34);
            for (int j = 0; j < point.dimension(); ++j) {
                double em;
                IMeasurement m = point.coordinate(j);
                this.xml.setAttribute(7, m.value());
                double ep = m.errorPlus();
                if (!Double.isNaN(ep)) {
                    this.xml.setAttribute(67, ep);
                }
                if (!Double.isNaN(em = m.errorMinus())) {
                    this.xml.setAttribute(68, em);
                }
                this.xml.printTag(35);
            }
            this.xml.closeTag();
        }
        this.xml.closeTag();
    }

    private void toXML(IProfile1D h, String path) throws IOException {
        String name = ((IManagedObject)h).name();
        this.xml.setAttribute(14, name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        this.xml.openTag(31);
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.axis(), X);
        this.xml.setAttribute(22, h.entries());
        this.xml.openTag(7);
        this.xml.setAttribute(18, X);
        this.xml.setAttribute(24, h.mean());
        this.xml.setAttribute(25, h.rms());
        this.xml.printTag(8);
        this.xml.closeTag();
        this.xml.openTag(9);
        int bins = h.axis().bins();
        for (int i = -2; i < bins; ++i) {
            double height = h.binHeight(i);
            double error = h.binError(i);
            if (height == 0.0 || error == 0.0) continue;
            this.xml.setAttribute(27, i);
            this.xml.setAttribute(28, h.binMean(i));
            this.xml.setAttribute(25, h.binRms(i));
            this.xml.setAttribute(30, height);
            this.xml.setAttribute(31, error);
            this.xml.setAttribute(22, h.binEntries(i));
            this.xml.printTag(10);
        }
        this.xml.closeTag();
        this.xml.closeTag();
    }

    private void toXML(IProfile2D h, String path) throws IOException {
        String name = ((IManagedObject)h).name();
        this.xml.setAttribute(14, name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.xml.setAttribute(15, title);
        }
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        this.xml.openTag(32);
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.xAxis(), X);
        this.writeHistogramAxis(h.yAxis(), Y);
        this.xml.setAttribute(22, h.entries());
        this.xml.openTag(7);
        this.xml.setAttribute(18, X);
        this.xml.setAttribute(24, h.meanX());
        this.xml.setAttribute(25, h.rmsX());
        this.xml.printTag(8);
        this.xml.setAttribute(18, Y);
        this.xml.setAttribute(24, h.meanY());
        this.xml.setAttribute(25, h.rmsY());
        this.xml.printTag(8);
        this.xml.closeTag();
        this.xml.openTag(11);
        int xbins = h.xAxis().bins();
        int ybins = h.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            for (int j = -2; j < ybins; ++j) {
                double height = h.binHeight(i, j);
                double error = h.binError(i, j);
                if (height == 0.0 || error == 0.0) continue;
                this.xml.setAttribute(33, i);
                this.xml.setAttribute(34, j);
                this.xml.setAttribute(36, h.binMeanX(i, j));
                this.xml.setAttribute(37, h.binMeanY(i, j));
                this.xml.setAttribute(25, h.binRms(i, j));
                this.xml.setAttribute(30, height);
                this.xml.setAttribute(31, error);
                this.xml.setAttribute(22, h.binEntries(i, j));
                this.xml.printTag(12);
            }
        }
        this.xml.closeTag();
        this.xml.closeTag();
    }

    private void toXML(IAnnotation annotation) throws IOException {
        this.xml.openTag(36);
        for (int i = 0; i < annotation.size(); ++i) {
            String key = annotation.key(i);
            this.xml.setAttribute(69, key);
            this.xml.setAttribute(12, annotation.value(key));
            if (annotation instanceof Annotation) {
                this.xml.setAttribute(70, ((Annotation)annotation).isSticky(key));
            }
            this.xml.printTag(37);
        }
        this.xml.closeTag();
    }

    private void writeHistogramAxis(IAxis axis, String direction) throws IOException {
        this.xml.setAttribute(18, direction);
        this.xml.setAttribute(19, axis.lowerEdge());
        this.xml.setAttribute(20, axis.upperEdge());
        this.xml.setAttribute(21, axis.bins());
        if (axis instanceof VariableAxis) {
            this.xml.openTag(5);
            for (int i = 0; i < axis.bins() - 1; ++i) {
                this.xml.setAttribute(7, axis.binUpperEdge(i));
                this.xml.printTag(6);
            }
            this.xml.closeTag();
        } else {
            this.xml.printTag(5);
        }
    }

    private void writeTupleEntries(ITuple tup) throws IOException {
        tup.start();
        for (int j = 0; j < tup.rows(); ++j) {
            tup.next();
            this.xml.openTag(19);
            for (int i = 0; i < tup.columns(); ++i) {
                Class colType = tup.columnType(i);
                if (colType == ITuple.class) {
                    ITuple tupp = (ITuple)tup.getObject(i);
                    if (tupp == null) {
                        this.xml.printTag(21);
                        continue;
                    }
                    this.xml.openTag(21);
                    this.writeTupleEntries(tupp);
                    this.xml.closeTag();
                    continue;
                }
                if (colType == Integer.TYPE) {
                    this.xml.setAttribute(9, tup.getInt(i));
                } else if (colType == Short.TYPE) {
                    this.xml.setAttribute(11, tup.getShort(i));
                } else if (colType == Long.TYPE) {
                    this.xml.setAttribute(10, tup.getLong(i));
                } else if (colType == Float.TYPE) {
                    this.xml.setAttribute(8, tup.getFloat(i));
                } else if (colType == Double.TYPE) {
                    this.xml.setAttribute(7, tup.getDouble(i));
                } else if (colType == Boolean.TYPE) {
                    this.xml.setAttribute(4, tup.getBoolean(i));
                } else if (colType == Byte.TYPE) {
                    this.xml.setAttribute(5, tup.getByte(i));
                } else if (colType == Character.TYPE) {
                    this.xml.setAttribute(6, tup.getChar(i));
                } else if (colType == String.class) {
                    this.xml.setAttribute(12, tup.getString(i));
                } else if (colType == Object.class) {
                    this.xml.setAttribute(12, tup.getObject(i).toString());
                }
                this.xml.printTag(20);
            }
            this.xml.closeTag();
        }
    }

    private void writeTupleColumns(ITuple tuple) throws IOException {
        this.xml.openTag(16);
        int columns = tuple.columns();
        for (int i = 0; i < columns; ++i) {
            String def;
            Class colType;
            block8: {
                colType = tuple.columnType(i);
                def = null;
                if (tuple instanceof AbstractTuple) {
                    try {
                        def = ((AbstractTuple)tuple).columnDefaultString(i);
                    }
                    catch (Exception e) {
                        if (colType == Boolean.TYPE) {
                            def = "false";
                        }
                        if (colType == ITuple.class) break block8;
                        def = "0";
                    }
                }
            }
            String tupName = tuple.columnName(i);
            if (def != null && !def.equals("")) {
                tupName = tupName + "=" + def;
            }
            if (colType == ITuple.class) {
                tupName = def;
            }
            if (colType == ITuple.class) {
                this.xml.setAttribute(42, "ITuple");
                tupName = tupName.substring(0, tupName.indexOf("="));
                this.xml.setAttribute(14, tupName);
                this.xml.openTag(17);
                this.writeTupleColumns(tuple.findTuple(i));
                this.xml.closeTag();
                continue;
            }
            this.xml.setAttribute(42, String.class.isAssignableFrom(colType) ? "string" : colType.getName());
            this.xml.setAttribute(14, tupName);
            this.xml.printTag(17);
        }
        this.xml.closeTag();
    }

    private void toXML(IFunction function, String path) throws IOException {
        IModelFunction model = null;
        if (function instanceof IModelFunction) {
            model = (IModelFunction)function;
        }
        this.xml.setAttribute(14, ((IManagedObject)function).name());
        this.xml.setAttribute(15, function.title());
        if (path != null && !path.equals("")) {
            this.xml.setAttribute(16, path);
        }
        if (model != null) {
            this.xml.setAttribute(71, model.isNormalized());
        }
        this.xml.openTag(38);
        this.xml.openTag(39);
        this.xml.print(function.codeletString());
        this.xml.closeTag();
        if (model != null) {
            this.xml.openTag(40);
            for (int i = 0; i < function.dimension(); ++i) {
                this.xml.setAttribute(14, model.variableName(i));
                this.xml.openTag(41);
                IRangeSet rangeSet = model.normalizationRange(i);
                double[] lb = rangeSet.lowerBounds();
                double[] ub = rangeSet.upperBounds();
                for (int j = 0; j < lb.length; ++j) {
                    this.xml.setAttribute(19, lb[j]);
                    this.xml.setAttribute(20, ub[j]);
                    this.xml.printTag(42);
                }
                this.xml.closeTag();
            }
            this.xml.closeTag();
        }
        this.xml.openTag(43);
        String[] parNames = function.parameterNames();
        double[] parValues = function.parameters();
        for (int i = 0; i < function.numberOfParameters(); ++i) {
            this.xml.setAttribute(14, parNames[i]);
            this.xml.setAttribute(7, parValues[i]);
            this.xml.printTag(44);
        }
        this.xml.closeTag();
        this.xml.closeTag();
    }
}

