/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IEvaluator;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AIDATestSuite;
import hep.aida.test.AidaTestCase;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;

public class TestRoot
extends AidaTestCase {
    protected ITree tree;
    private double relPrecision;

    public TestRoot(String testName) {
        super(testName);
        this.setRelPrecision(1.0E-4);
    }

    protected void setRelPrecision(double relPrecision) {
        this.relPrecision = relPrecision;
    }

    protected void tearDown() throws Exception {
        this.tree.close();
        super.tearDown();
    }

    protected String convertName(int id) {
        return id >= 0 ? "/h" + id : "/h_" + id;
    }

    public void test1DHistogramCopy() {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(null);
        IHistogram1D hist = (IHistogram1D)this.tree.find(this.convertName(110));
        IHistogram1D clone = hf.createCopy(((IManagedObject)hist).name(), hist);
        AidaTestCase.assertEquals(hist, clone);
    }

    public void test2DHistogramCopy() {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(null);
        IHistogram2D hist = (IHistogram2D)this.tree.find(this.convertName(210));
        IHistogram2D clone = hf.createCopy(((IManagedObject)hist).name(), hist);
        AidaTestCase.assertEquals(hist, clone);
    }

    public void test1DHistogramAccess() {
        IHistogram1D hist = (IHistogram1D)this.tree.find(this.convertName(110));
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals((String)"TEST OF HBOOK1", (String)hist.title().trim());
        Assert.assertEquals((int)5000, (int)hist.entries());
        Assert.assertEquals((int)0, (int)hist.extraEntries());
        Assert.assertEquals((double)0.49817, (double)hist.mean(), (double)this.relPrecision);
        Assert.assertEquals((double)0.22046, (double)hist.rms(), (double)this.relPrecision);
    }

    public void test2DHistogramAccess() {
        IHistogram2D hist = (IHistogram2D)this.tree.find(this.convertName(210));
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals((String)"TEST OF HBOOK2", (String)hist.title().trim());
        Assert.assertEquals((int)5000, (int)hist.entries());
        Assert.assertEquals((int)0, (int)hist.extraEntries());
        Assert.assertEquals((double)0.4806, (double)hist.meanX(), (double)this.relPrecision);
        Assert.assertEquals((double)0.48094, (double)hist.meanY(), (double)this.relPrecision);
        Assert.assertEquals((double)0.21781, (double)hist.rmsX(), (double)this.relPrecision);
        Assert.assertEquals((double)0.21768, (double)hist.rmsY(), (double)this.relPrecision);
    }

    public void testData() throws Exception {
        int[] bin = new int[]{0, 0, 2, 1, 5, 6, 11, 14, 17, 26, 36, 58, 85, 114, 164, 208, 250, 292, 373, 424, 497, 547, 611, 613, 641, 655, 634, 617, 531, 461, 422, 364, 305, 266, 214, 154, 107, 93, 65, 39, 34, 17, 10, 6, 7, 1, 0, 1, 2, 0};
        ITuple tuple = (ITuple)this.tree.find(this.convertName(30));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 50, -4.0, 4.0);
        IEvaluator x = tf.createEvaluator("X");
        tuple.project(hist, x);
        Assert.assertEquals((int)10000, (int)hist.entries());
        Assert.assertEquals((double)-1.007E-4, (double)hist.mean(), (double)this.relPrecision);
        Assert.assertEquals((double)0.9941, (double)hist.rms(), (double)this.relPrecision);
        int nBins = hist.axis().bins();
        Assert.assertEquals((int)50, (int)nBins);
        for (int i = 0; i < nBins; ++i) {
            Assert.assertEquals((int)bin[i], (int)hist.binEntries(i));
        }
        temp.close();
    }

    public void testFolderAccess() {
        IHistogram1D hist = (IHistogram1D)this.tree.find("BS" + this.convertName(100));
        Assert.assertNotNull((Object)hist);
        Assert.assertEquals((String)"BREM P M", (String)hist.title().trim());
        Assert.assertEquals((int)15896, (int)hist.entries());
        Assert.assertEquals((int)0, (int)hist.extraEntries());
        Assert.assertEquals((double)0.28203, (double)1.0E-4, (double)hist.mean());
        Assert.assertEquals((double)0.10821, (double)1.0E-4, (double)hist.rms());
    }

    public void testTuple() {
        ITuple tuple = (ITuple)this.tree.find(this.convertName(30));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 40, 0.0, 10.0);
        IEvaluator x = tf.createEvaluator("Z");
        tuple.project(hist, x);
        Assert.assertEquals((int)9934, (int)hist.entries());
        Assert.assertEquals((double)1.907, (double)hist.mean(), (double)1.0E-4);
        Assert.assertEquals((double)1.8271, (double)hist.rms(), (double)1.0E-4);
    }

    public void testTupleAge() {
        ITuple tuple = (ITuple)this.tree.find("STAFF" + this.convertName(10));
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree temp = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(temp);
        ITupleFactory tf = af.createTupleFactory(temp);
        IHistogram1D hist = hf.createHistogram1D("test", 44, 20.5, 64.5);
        IEvaluator x = tf.createEvaluator("Age");
        tuple.project(hist, x);
        Assert.assertEquals((int)3354, (int)hist.entries());
        Assert.assertEquals((double)47.153, (double)hist.mean(), (double)1.0E-4);
        Assert.assertEquals((double)8.643, (double)hist.rms(), (double)1.0E-4);
    }

    public void testTupleNation() {
        ITuple tuple = (ITuple)this.tree.find("STAFF" + this.convertName(10));
        int nationIndex = tuple.findColumn("Nation");
        int n = 0;
        tuple.start();
        while (tuple.next()) {
            String nation = tuple.getString(nationIndex);
            if (!nation.equals("CH")) continue;
            ++n;
        }
        Assert.assertEquals((int)465, (int)n);
    }

    public void testWalkTree() {
        String[] names = this.tree.listObjectNames("/", true);
        Assert.assertEquals((int)266, (int)names.length);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.openFile();
    }

    protected void openFile() throws IOException {
        File f = AIDATestSuite.getTestFile("pawdemo.root");
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        this.tree = tf.create(f.getAbsolutePath(), "root", true, false, null);
    }
}

