/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.command;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.ConsoleService;
import org.lsst.ccs.gconsole.services.command.DefaultCommandHandle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.scheduler.Scheduler;

@Plugin(name="Command Service Plugin", id="command-service", description="Command service utility.")
public final class CommandService
extends ConsolePlugin
implements ConsoleService {
    private final CommandSender defaultSender;
    private final DefaultCommandHandle defaultHandle = new DefaultCommandHandle();

    public CommandService() {
        this.defaultSender = this.getSender();
        this.defaultSender.setCommandHandle(this.defaultHandle);
    }

    public static CommandService getService() {
        return Console.getConsole().getSingleton(CommandService.class);
    }

    public CommandSender getSender() {
        AgentMessagingLayer messenger = Console.getConsole().getMessagingAccess();
        Executor callbackExecutor = run -> SwingUtilities.invokeLater(run);
        Executor workerExecutor = run -> new SwingWorker(){

            protected Object doInBackground() throws Exception {
                run.run();
                return null;
            }
        }.execute();
        Scheduler timer = Console.getConsole().getScheduler();
        CommandSender sender = new CommandSender(messenger, callbackExecutor, workerExecutor, timer);
        sender.setCommandHandle(this.defaultHandle);
        return sender;
    }

    @Deprecated
    public CommandTask execute(CommandHandle handle, Duration timeout, String command, Object ... args) {
        return this.defaultSender.execute(handle, timeout, command, args);
    }

    @Deprecated
    public CommandTask execute(CommandHandle handle, String command, Object ... args) {
        return this.defaultSender.execute(handle, command, args);
    }

    @Deprecated
    public CommandTask execute(Duration timeout, String command, Object ... args) {
        return this.defaultSender.execute(timeout, command, args);
    }

    @Deprecated
    public CommandTask execute(String command, Object ... args) {
        return this.defaultSender.execute(command, args);
    }

    public CommandTask sendRaw(String destination, String command, Object ... args) {
        return this.defaultSender.sendRaw(destination, command, args);
    }

    public CommandTask sendEncoded(String destination, String command, String ... args) {
        return this.defaultSender.sendEncoded(destination, command, args);
    }

    public CommandTask send(String destination, String commandName, String arguments) {
        return this.defaultSender.send(destination, commandName, arguments);
    }

    public CommandTask send(String destination, String command) {
        return this.defaultSender.send(destination, command);
    }

    public CommandTask send(String shellCommand) {
        return this.defaultSender.send(shellCommand);
    }

    public void watch(Consumer<Boolean> watcher, String command, int numberOfArguments) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

