/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.GroupView;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

public final class TabbedGroupView
extends GroupView {
    public static final String CREATOR_PATH = "Built-In/Grouped/Tabbed";
    private static final String GROUP_KEY = "_GROUP_";
    private JPanel root;
    private final HashMap<String, JPanel> groupToPane = new HashMap();

    @Create(category="MonitorView", name="Group Tabbed", path="Built-In/Grouped/Tabbed", description="Monitoring data view that divides channels into groups, and displays one group at a time. Tabs are used to select the group to display, and tree views are used for each group.")
    public TabbedGroupView(@Par(def="0", desc="Depth of group hierarchy. If 0, the filter is expected to provide explicit group names (separated by '//' from the rest of the display path. Otherwise, should be 1 or 2, and the first 1 or 2 slash-separtated segments of the display path will be used as group names.") int depth, @Par(def="false", desc="Place tabs horizontally (left and right from the view) insted of vertically (at the top and bottom).") boolean horizontalTabs) {
        this.descriptor = new Descriptor();
        this.getDescriptor().setName("Group Tabbed");
        if (depth < 0 || depth > 2) {
            throw new IllegalArgumentException("Illegal group tree depth, must be between 0 and 2.");
        }
        this.getDescriptor().setDepth(depth);
        this.getDescriptor().setHorizontalTabs(horizontalTabs);
    }

    @Override
    public JComponent getPanel() {
        if (this.root == null) {
            this.root = new JPanel(new BorderLayout());
            this.rebuild();
            this.selectGroup(null);
        }
        return this.root;
    }

    private void rebuild() {
        if (this.root == null) {
            return;
        }
        this.groupToPane.clear();
        this.root.removeAll();
        this.buildSubgroups(this.root, null, "");
        this.selectGroup(this.currentGroup);
    }

    private void buildSubgroups(JComponent parent, String prefix, String segment) {
        String[] gg = this.getSubgroups(prefix);
        if (gg != null) {
            if (gg.length == 0) {
                JPanel comp = new JPanel(new BorderLayout());
                this.groupToPane.put(prefix, comp);
                comp.putClientProperty(GROUP_KEY, prefix);
                if (parent instanceof JTabbedPane) {
                    ((JTabbedPane)parent).addTab(segment, comp);
                } else {
                    parent.add((Component)comp, "Center");
                }
            } else {
                JTabbedPane tp;
                if (parent instanceof JTabbedPane) {
                    tp = new JTabbedPane(this.getDescriptor().isHorizontalTabs() ? 4 : 3, 0);
                    ((JTabbedPane)parent).addTab(segment, tp);
                } else {
                    tp = new JTabbedPane(this.getDescriptor().isHorizontalTabs() ? 2 : 1, 0);
                    parent.add((Component)tp, "Center");
                }
                tp.addChangeListener(e -> {
                    try {
                        JTabbedPane sourcePane = (JTabbedPane)e.getSource();
                        Component c = sourcePane.getSelectedComponent();
                        while (c instanceof JTabbedPane) {
                            c = ((JTabbedPane)c).getSelectedComponent();
                        }
                        String group = (String)((JComponent)c).getClientProperty(GROUP_KEY);
                        this.selectGroup(group);
                    }
                    catch (ClassCastException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                });
                for (String g : gg) {
                    if (g.isEmpty()) {
                        JPanel comp = new JPanel(new BorderLayout());
                        this.groupToPane.put(prefix, comp);
                        comp.putClientProperty(GROUP_KEY, prefix);
                        tp.addTab("     ", comp);
                        continue;
                    }
                    this.buildSubgroups(tp, prefix == null ? g : prefix + "/" + g, g);
                }
            }
        }
    }

    @Override
    protected String[] getPath(String group) {
        String[] ss = super.getPath(group);
        if (ss.length > 2) {
            StringJoiner sj = new StringJoiner("/");
            for (int i = 1; i < ss.length; ++i) {
                sj.add(ss[i]);
            }
            return new String[]{ss[0], sj.toString()};
        }
        return ss;
    }

    @Override
    protected void selectGroup(String group) {
        if (this.root == null) {
            return;
        }
        super.selectGroup(group);
    }

    @Override
    protected void groupsAdded(List<String> groups) {
        this.rebuild();
    }

    @Override
    protected void groupsRemoved(List<String> groups) {
        this.rebuild();
    }

    @Override
    protected void groupSelected() {
        if (this.root == null || this.currentGroup != null && this.currentGroup.isEmpty()) {
            return;
        }
        JPanel pane = this.groupToPane.get(this.currentGroup);
        AbstractMonitorView view = this.getView(this.currentGroup);
        JComponent viewPanel = view.getPanel();
        if (pane.getComponentCount() != 1 || viewPanel != pane.getComponent(0)) {
            pane.removeAll();
            pane.add((Component)viewPanel, "Center");
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor;
    }

    @Create(category="MonitorView", name="Tabbed Tables", path="Built-In/Grouped/Tabbed, Explicit Groups, Tables", description="Tabbed view that expects explicitly defined groups from the filter, and displays each group in a sectioned table.")
    public static TabbedGroupView createTabbedExplicitGroupsSectionedTables() {
        Descriptor viewDesc = new Descriptor();
        Creator.Descriptor creDesc = new Creator.Descriptor("MonitorView", CREATOR_PATH, "0", "false");
        viewDesc.setCreator(creDesc);
        viewDesc.setDepth(0);
        viewDesc.setDefaultView(new SectionedTableView.Descriptor());
        return (TabbedGroupView)PersistenceService.getService().make(viewDesc);
    }

    public static class Descriptor
    extends GroupView.Descriptor {
        private boolean horizontalTabs;

        public boolean isHorizontalTabs() {
            return this.horizontalTabs;
        }

        public void setHorizontalTabs(boolean horizontalTabs) {
            this.horizontalTabs = horizontalTabs;
        }

        @Override
        public Descriptor clone() {
            return (Descriptor)super.clone();
        }
    }
}

