/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.MonitorTaskPanel;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.CompressorSummaryLine;

public class RefrigControlPanel
extends JPanel
implements CommandSender.ReplyHandler {
    private static final String CMND_GET_STATE = "getSystemState";
    private final CommandSender sender;
    private boolean cmndError = false;
    private final JPanel compressorPanel = UiUtilities.newBorderedPanel((String)"Compressor Control");
    private SystemStatusPanel statusPanel;
    private MonitorTaskPanel monTaskPanel;
    private int numColdPanels = 0;
    private int numCryoPanels = 0;
    private int numMonTasks = 0;
    private final CompressorSummaryLine[] coldLines = new CompressorSummaryLine[2];
    private final CompressorSummaryLine[] cryoLines = new CompressorSummaryLine[6];
    private static final long serialVersionUID = 1L;

    public RefrigControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        RefrigState rs = (RefrigState)reply;
        if (!this.cmndError) {
            if (this.numMonTasks > 0) {
                this.remove((Component)this.monTaskPanel);
            }
            this.monTaskPanel.initPanel(rs.getMonitorTasks());
            this.numMonTasks = rs.getNumMonTasks();
            if (this.numMonTasks > 0) {
                GridBagConstraints gbm = new GridBagConstraints();
                gbm.insets = new Insets(5, 0, 0, 0);
                gbm.anchor = 11;
                gbm.gridx = 0;
                gbm.gridy = 1;
                this.add((Component)this.monTaskPanel, gbm);
            }
            this.layoutCompressorPanel(rs.getNumColdComps(), rs.getNumCryoComps());
        }
        this.cmndError = false;
        this.updatePanel(rs);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.cmndError = true;
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int comp;
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl");
        this.monTaskPanel = new MonitorTaskPanel("Monitor Task Control", this.sender, "MonitorControl");
        for (comp = 0; comp < this.coldLines.length; ++comp) {
            this.coldLines[comp] = new CompressorSummaryLine(0, this.sender);
        }
        for (comp = 0; comp < this.cryoLines.length; ++comp) {
            this.cryoLines[comp] = new CompressorSummaryLine(1, this.sender);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(4, 0, 4, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.statusPanel, gbm);
        gbm.gridy = 2;
        this.add((Component)this.compressorPanel, gbm);
    }

    private void layoutCompressorPanel(int numColdComps, int numCryoComps) {
        int j;
        int j2;
        for (j2 = 0; j2 < this.numColdPanels; ++j2) {
            this.compressorPanel.remove(this.coldLines[j2]);
        }
        for (j2 = 0; j2 < this.numCryoPanels; ++j2) {
            this.compressorPanel.remove(this.cryoLines[j2]);
        }
        this.numColdPanels = numColdComps;
        this.numCryoPanels = numCryoComps;
        this.compressorPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(4, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        for (j = 0; j < this.numColdPanels; ++j) {
            gbm.insets.bottom = j == this.numColdPanels + this.numCryoPanels - 1 ? 4 : 0;
            this.compressorPanel.add((Component)this.coldLines[j], gbm);
            ++gbm.gridy;
        }
        for (j = 0; j < this.numCryoPanels; ++j) {
            gbm.insets.bottom = j == this.numCryoPanels - 1 ? 4 : 0;
            this.compressorPanel.add((Component)this.cryoLines[j], gbm);
            ++gbm.gridy;
        }
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.statusPanel.disablePanel();
            RefrigControlPanel.this.monTaskPanel.disablePanel();
            for (CompressorSummaryLine comp : RefrigControlPanel.this.coldLines) {
                comp.disableSystem();
            }
            for (CompressorSummaryLine comp : RefrigControlPanel.this.cryoLines) {
                comp.disableSystem();
            }
            RefrigControlPanel.this.repaint();
        }
    }

    class UpdateRefrigState
    implements Runnable {
        private final RefrigState rs;

        UpdateRefrigState(RefrigState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            RefrigControlPanel.this.statusPanel.updatePanel(this.rs.getTickMillis());
            RefrigControlPanel.this.monTaskPanel.updatePanel(this.rs.getMonitorTasks());
            for (CompState cs : this.rs.getColdStates()) {
                RefrigControlPanel.this.coldLines[cs.getIndex()].updateControlPanel(cs);
            }
            for (CompState cs : this.rs.getCryoStates()) {
                RefrigControlPanel.this.cryoLines[cs.getIndex()].updateControlPanel(cs);
            }
            RefrigControlPanel.this.repaint();
        }
    }
}

