/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.ColdCompValves;
import org.lsst.ccs.subsystem.refrig.constants.CompConditions;
import org.lsst.ccs.subsystem.refrig.constants.CompLatches;
import org.lsst.ccs.subsystem.refrig.constants.CompSwConds;
import org.lsst.ccs.subsystem.refrig.constants.CompSwitches;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.constants.VfdState;
import org.lsst.ccs.subsystem.refrig.data.ColdCompState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.CryoCompState;

public class CompressorControlPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final int SW_TYPE_POWER = 0;
    private static final int SW_TYPE_VALVE_NC = 1;
    private static final int SW_TYPE_VALVE_NO = 2;
    private static final int[] switchTypes = new int[8];
    private static final int compStateWidth;
    private static final int switchStateWidth;
    private static final int latchStateWidth;
    private static final int conditionStateWidth;
    private static final int swCondStateWidth;
    private static final int horzInset;
    private static final int vertInset;
    private String comp;
    private final CommandSender sender;
    private final int type;
    private final Collection<Integer> validSwitches;
    private final Collection<Integer> validLatches;
    private final Collection<Integer> validConditions;
    private final Collection<Integer> validSwConds;
    private final JPanel headPanel = new JPanel();
    private JLabel compName;
    private JLabel compState;
    private final JPanel switchPanel = UiUtilities.newBorderedPanel((String)"Switches");
    private final JLabel[] switchStatus = new JLabel[8];
    private final ButtonGroup[] switchBG = new ButtonGroup[8];
    private final JRadioButton[] switchOffRB = new JRadioButton[8];
    private final JRadioButton[] switchOnRB = new JRadioButton[8];
    private final JPanel valvePanel = UiUtilities.newBorderedPanel((String)"Cold Valve Control");
    private TextFieldX[] valvePosition = new TextFieldX[3];
    private final JPanel vfdPanel = UiUtilities.newBorderedPanel((String)"VFD Control");
    private JLabel vfdState;
    private JButton vfdReset;
    private TextFieldX vfdFrequency;
    private final JPanel latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
    private final JLabel[] latchStatus = new JLabel[10];
    private JButton plcReset;
    private final JPanel conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
    private final JLabel[] conditionStatus = new JLabel[16];
    private final JPanel swCondPanel = UiUtilities.newBorderedPanel((String)"CCS Error Conditions");
    private final JLabel[] swCondStatus = new JLabel[13];
    private final UiUtilities uiUtils;
    private static final long serialVersionUID = 1L;

    public CompressorControlPanel(int type, CommandSender cons) {
        this.type = type;
        this.sender = cons;
        this.validSwitches = type == 0 ? ColdCompState.SWITCHES : CryoCompState.SWITCHES;
        this.validLatches = type == 0 ? ColdCompState.LATCHES : CryoCompState.LATCHES;
        this.validConditions = type == 0 ? ColdCompState.CONDITIONS : CryoCompState.CONDITIONS;
        this.validSwConds = type == 0 ? ColdCompState.SW_CONDITIONS : CryoCompState.SW_CONDITIONS;
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        this.disableSystem();
    }

    public void updateControlPanel(CompState rs) {
        Color color;
        SwitchState state;
        this.comp = rs.getName();
        this.compName.setText(this.comp);
        this.compName.setEnabled(true);
        CompressorState cState = rs.getCompressorState();
        Color cColor = cState == CompressorState.OFFLINE ? UiConstants.BLUE : (cState == CompressorState.STOPPED ? Color.BLACK : (cState == CompressorState.RUNNING ? UiConstants.GREEN : (cState == CompressorState.WAITING ? UiConstants.YELLOW : UiConstants.RED)));
        this.compState.setText(cState.name());
        this.compState.setForeground(cColor);
        this.compState.setEnabled(true);
        Iterator iterator = rs.getValidSwitches().iterator();
        while (iterator.hasNext()) {
            int sw = (Integer)iterator.next();
            state = rs.getSwitchState(sw);
            String text = state.name();
            int swType = switchTypes[sw];
            if (swType != 0) {
                String string = state == SwitchState.ON ? (swType == 1 ? "OPEN" : "SHUT") : (state == SwitchState.OFF ? (swType == 1 ? "SHUT" : "OPEN") : (text = text));
            }
            Color color2 = state == SwitchState.OFF ? (swType == 2 ? UiConstants.GREEN : Color.black) : (state == SwitchState.ON ? (swType == 2 ? Color.black : UiConstants.GREEN) : UiConstants.BLUE);
            this.switchStatus[sw].setText(text);
            this.switchStatus[sw].setForeground(color2);
            this.switchStatus[sw].setEnabled(true);
            JRadioButton selButton = state == SwitchState.ON ? this.switchOnRB[sw] : this.switchOffRB[sw];
            selButton.setSelected(true);
            this.switchOffRB[sw].setEnabled(true);
            this.switchOnRB[sw].setEnabled(true);
        }
        if (this.type == 0) {
            ColdCompState crs = (ColdCompState)rs;
            for (int valve = 0; valve < 3; ++valve) {
                this.valvePosition[valve].update((Object)String.format("%.1f", 100.0 * crs.getValvePosition(valve)), true);
            }
            VfdState vState = crs.getVfdState();
            cColor = vState == VfdState.FAULT ? UiConstants.RED : (vState == VfdState.ALARM ? UiConstants.YELLOW : (vState == VfdState.RUNNING || vState == VfdState.REVERSE ? UiConstants.GREEN : (vState == VfdState.OFFLINE ? UiConstants.BLUE : Color.BLACK)));
            this.vfdState.setText(vState.name());
            this.vfdState.setForeground(cColor);
            this.vfdState.setEnabled(true);
            this.vfdFrequency.update((Object)crs.getVfdFrequency(), true);
        }
        iterator = rs.getValidLatches().iterator();
        while (iterator.hasNext()) {
            int cond = (Integer)iterator.next();
            state = rs.getLatchState(cond);
            color = state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.WARNING ? UiConstants.YELLOW : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
            this.latchStatus[cond].setText(state.name());
            this.latchStatus[cond].setForeground(color);
            this.latchStatus[cond].setEnabled(true);
        }
        this.plcReset.setEnabled(true);
        iterator = rs.getValidConditions().iterator();
        while (iterator.hasNext()) {
            int cond = (Integer)iterator.next();
            state = rs.getConditionState(cond);
            color = state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN);
            this.conditionStatus[cond].setText(state.name());
            this.conditionStatus[cond].setForeground(color);
            this.conditionStatus[cond].setEnabled(true);
        }
        iterator = rs.getValidSwConditions().iterator();
        while (iterator.hasNext()) {
            int cond = (Integer)iterator.next();
            state = rs.getSwConditionState(cond);
            Color color3 = state == SwCondState.OFFLINE ? UiConstants.BLUE : (state == SwCondState.CLEAR ? UiConstants.GREEN : (color = state == SwCondState.DLYPEND ? UiConstants.PURPLE : UiConstants.RED));
            if (this.swCondStatus[cond] == null) {
                System.out.println("Can't handle sw condition " + cond + " for compressor " + rs.getName());
                continue;
            }
            this.swCondStatus[cond].setText(state.name());
            this.swCondStatus[cond].setForeground(color);
            this.swCondStatus[cond].setEnabled(true);
        }
        this.repaint();
    }

    public final void disableSystem() {
        int cond;
        this.compName.setEnabled(false);
        this.compState.setEnabled(false);
        Object object = this.validSwitches.iterator();
        while (object.hasNext()) {
            int sw = object.next();
            this.switchStatus[sw].setEnabled(false);
            this.switchOffRB[sw].setEnabled(false);
            this.switchOnRB[sw].setEnabled(false);
        }
        if (this.type == 0) {
            for (TextFieldX vPosition : this.valvePosition) {
                vPosition.setDisabled();
            }
            this.vfdFrequency.setDisabled();
            this.vfdState.setEnabled(false);
        }
        object = this.validLatches.iterator();
        while (object.hasNext()) {
            cond = (Integer)object.next();
            this.latchStatus[cond].setEnabled(false);
        }
        this.plcReset.setEnabled(false);
        object = this.validConditions.iterator();
        while (object.hasNext()) {
            cond = (Integer)object.next();
            this.conditionStatus[cond].setEnabled(false);
        }
        object = this.validSwConds.iterator();
        while (object.hasNext()) {
            cond = (Integer)object.next();
            this.swCondStatus[cond].setEnabled(false);
        }
        this.repaint();
    }

    private void initComponents() {
        this.compName = UiUtilities.newLabel((String)"MM99", (int)0);
        this.compState = UiUtilities.newLabel((String)"X", (int)compStateWidth);
        for (int sw : this.validSwitches) {
            this.switchStatus[sw] = UiUtilities.newLabel((String)"XXX", (int)switchStateWidth);
            int swType = switchTypes[sw];
            this.switchOffRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "Off" : (swType == 1 ? "Shut" : "Open"), "F" + sw);
            this.switchOnRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "On" : (swType == 1 ? "Open" : "Shut"), "T" + sw);
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(this.switchOffRB[sw]);
            bg.add(this.switchOnRB[sw]);
        }
        if (this.type == 0) {
            this.vfdState = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(VfdState.class));
            this.vfdReset = this.uiUtils.newButton("Reset Fault", "V", true);
            this.vfdFrequency = this.uiUtils.newTextFieldX("00.0000", "F", 2, true);
            for (int valve = 0; valve < 3; ++valve) {
                this.valvePosition[valve] = this.uiUtils.newTextFieldX("0000.00", "V" + valve, 2, true);
            }
        }
        for (int cond : this.validLatches) {
            this.latchStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)latchStateWidth);
        }
        this.plcReset = this.uiUtils.newButton("Reset", "P", true);
        for (int cond : this.validConditions) {
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)conditionStateWidth);
        }
        for (int cond : this.validSwConds) {
            this.swCondStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)swCondStateWidth);
        }
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.anchor = 17;
        gbh.gridx = 0;
        gbh.gridy = 0;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"Compressor:  ", (int)0), gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.compName, gbh);
        ++gbh.gridx;
        gbh.insets.left = 30;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"State:  ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 0;
        this.headPanel.add((Component)this.compState, gbh);
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, vertInset, horzInset);
        gbs.gridy = -1;
        int ncols = 2;
        int colm = 0;
        for (int sw : this.validSwitches) {
            int swType = switchTypes[sw];
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = gbs.gridy == 0 ? vertInset : 0;
            gbs.insets.left = colm == 0 ? horzInset : 40;
            this.switchPanel.add((Component)UiUtilities.newLabel((String)(CompSwitches.DESCS[sw] + ":"), (int)0), gbs);
            gbs.insets.left = horzInset;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)(swType == 2 ? this.switchOnRB[sw] : this.switchOffRB[sw]), gbs);
            ++gbs.gridx;
            gbs.insets.left = 0;
            this.switchPanel.add((Component)(swType == 2 ? this.switchOffRB[sw] : this.switchOnRB[sw]), gbs);
            ++gbs.gridx;
            colm = (colm + 1) % ncols;
        }
        if (this.type == 0) {
            GridBagConstraints gbd = new GridBagConstraints();
            gbd.anchor = 17;
            gbd.insets = new Insets(vertInset, horzInset, vertInset, horzInset);
            gbd.gridy = -1;
            ncols = 3;
            colm = 0;
            for (int valve = 0; valve < 3; ++valve) {
                if (colm == 0) {
                    gbd.gridx = 0;
                    ++gbd.gridy;
                }
                gbd.insets.top = gbd.gridy == 0 ? vertInset : -vertInset;
                gbd.insets.left = colm == 0 ? horzInset : 30;
                this.valvePanel.add((Component)UiUtilities.newLabel((String)(ColdCompValves.DESCS[valve] + ":"), (int)0), gbd);
                ++gbd.gridx;
                gbd.insets.left = horzInset;
                this.valvePanel.add((Component)this.valvePosition[valve], gbd);
                ++gbd.gridx;
                gbd.insets.left = 0;
                this.valvePanel.add((Component)UiUtilities.newLabel((String)"%", (int)0), gbd);
                ++gbd.gridx;
                colm = (colm + 1) % ncols;
            }
        }
        if (this.type == 0) {
            GridBagConstraints gbf = new GridBagConstraints();
            gbf.anchor = 17;
            gbf.insets = new Insets(vertInset, horzInset, vertInset, horzInset);
            gbf.gridx = 0;
            gbf.gridy = 0;
            this.vfdPanel.add((Component)UiUtilities.newLabel((String)"State:", (int)0), gbf);
            ++gbf.gridx;
            this.vfdPanel.add((Component)this.vfdState, gbf);
            ++gbf.gridx;
            gbf.insets.left = 30;
            this.vfdPanel.add((Component)this.vfdReset, gbf);
            ++gbf.gridx;
            this.vfdPanel.add((Component)UiUtilities.newLabel((String)"Frequency:", (int)0), gbf);
            ++gbf.gridx;
            gbf.insets.left = horzInset;
            this.vfdPanel.add((Component)this.vfdFrequency, gbf);
            ++gbf.gridx;
            gbf.insets.left = 0;
            this.vfdPanel.add((Component)UiUtilities.newLabel((String)"Hz", (int)0), gbf);
        }
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 17;
        gbl.insets = new Insets(0, 0, vertInset, horzInset);
        gbl.gridy = -1;
        ncols = 1;
        colm = 0;
        for (int cond : this.validLatches) {
            if (colm == 0) {
                gbl.gridx = 0;
                ++gbl.gridy;
            }
            gbl.insets.top = gbl.gridy == 0 ? vertInset : 0;
            gbl.insets.left = colm == 0 ? horzInset : 30;
            this.latchPanel.add((Component)UiUtilities.newLabel((String)(CompLatches.DESCS[cond] + ":"), (int)0), gbl);
            gbl.insets.left = horzInset;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbl);
            ++gbl.gridx;
            colm = (colm + 1) % ncols;
        }
        gbl.anchor = 11;
        gbl.gridwidth = 2 * ncols;
        gbl.gridx = 0;
        ++gbl.gridy;
        gbl.insets.top = vertInset;
        this.latchPanel.add((Component)this.plcReset, gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, vertInset, horzInset);
        gbc.gridy = -1;
        ncols = 2;
        colm = 0;
        for (int cond : this.validConditions) {
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? vertInset : 0;
            gbc.insets.left = colm == 0 ? horzInset : 30;
            this.conditionPanel.add((Component)UiUtilities.newLabel((String)(CompConditions.DESCS[cond] + ":"), (int)0), gbc);
            gbc.insets.left = horzInset;
            ++gbc.gridx;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % ncols;
        }
        GridBagConstraints gbw = new GridBagConstraints();
        gbw.anchor = 17;
        gbw.insets = new Insets(0, 0, vertInset, horzInset);
        gbw.gridy = -1;
        ncols = 2;
        colm = 0;
        for (int cond : this.validSwConds) {
            if (colm == 0) {
                gbw.gridx = 0;
                ++gbw.gridy;
            }
            gbw.insets.top = gbw.gridy == 0 ? vertInset : 0;
            gbw.insets.left = colm == 0 ? horzInset : 30;
            this.swCondPanel.add((Component)UiUtilities.newLabel((String)(CompSwConds.DESCS[cond] + ":"), (int)0), gbw);
            gbw.insets.left = horzInset;
            ++gbw.gridx;
            this.swCondPanel.add((Component)this.swCondStatus[cond], gbw);
            ++gbw.gridx;
            colm = (colm + 1) % ncols;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(12, 6, 6, 6);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.gridwidth = 2;
        this.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        gbm.insets.top = 6;
        if (this.type == 0) {
            this.add((Component)this.valvePanel, gbm);
            ++gbm.gridy;
            this.add((Component)this.vfdPanel, gbm);
            ++gbm.gridy;
        }
        gbm.gridwidth = 1;
        gbm.gridheight = 2;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridx;
        gbm.gridheight = 1;
        this.add((Component)this.conditionPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.swCondPanel, gbm);
    }

    public void handleRadioButton(String name) {
        char action = name.charAt(0);
        int sw = Integer.valueOf(name.substring(1));
        this.sender.sendCommand(this.comp, "setSwitchOn", new Object[]{CompSwitches.ID_MAP.get(sw), action == 'T'});
    }

    public void handleTextFieldX(String name, Object value) {
        char action = name.charAt(0);
        if (action == 'V') {
            int valve = Integer.valueOf(name.substring(1));
            this.sender.sendCommand(this.comp, "setValvePosition", new Object[]{ColdCompValves.ID_MAP.get(valve), (Double)value / 100.0});
        } else if (action == 'F') {
            this.sender.sendCommand(this.comp, "setVfdFrequency", new Object[]{value});
        }
    }

    public void handleButton(String name) {
        char action = name.charAt(0);
        if (action == 'P') {
            this.sender.sendCommand(this.comp, "resetLatches", new Object[0]);
        } else if (action == 'V') {
            this.sender.sendCommand(this.comp, "resetVfdFault", new Object[0]);
        }
    }

    static {
        CompressorControlPanel.switchTypes[0] = 0;
        CompressorControlPanel.switchTypes[2] = 0;
        CompressorControlPanel.switchTypes[1] = 0;
        CompressorControlPanel.switchTypes[3] = 1;
        CompressorControlPanel.switchTypes[4] = 2;
        CompressorControlPanel.switchTypes[5] = 1;
        CompressorControlPanel.switchTypes[6] = 0;
        CompressorControlPanel.switchTypes[7] = 0;
        compStateWidth = UiUtilities.maxEnumLabelWidth(CompressorState.class);
        switchStateWidth = Math.max(UiUtilities.maxEnumLabelWidth(SwitchState.class), UiUtilities.maxLabelWidth((String[])new String[]{"OPEN", "SHUT"}, (String)""));
        latchStateWidth = UiUtilities.maxEnumLabelWidth(LatchState.class);
        conditionStateWidth = UiUtilities.maxEnumLabelWidth(ConditionState.class);
        swCondStateWidth = UiUtilities.maxEnumLabelWidth(SwCondState.class);
        horzInset = UiUtilities.getLabelSize((String)"M").width / 2;
        vertInset = UiUtilities.getLabelSize((String)"M").height / 4;
    }
}

