/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.adapter;

import hep.aida.IAxis;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.tree.Tree;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;

public class MountPointAdapter
extends DefaultFTreeNodeAdapter {
    private AIDAPlugin plugin;
    private Studio app;
    private Commands commands;

    public MountPointAdapter(AIDAPlugin plugin, Studio app) {
        super(100);
        this.plugin = plugin;
        this.app = app;
        this.commands = new Commands();
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        this.commands.setPath(this.plugin.fullPath(nodes[0].path()));
        menu.removeAll();
        JMenuItem item = new JMenuItem("Save");
        item.setActionCommand("commit");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Save As...");
        item.setActionCommand("commitAs");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Close");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Description");
        item.setActionCommand("description");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        return menu;
    }

    public String toolTipMessage(FTreeNode node, String oldMessage) {
        try {
            Tree tree = (Tree)this.plugin.aidaMasterTree().findTree(this.plugin.fullPath(node.path()));
            String description = this.getDescription(tree);
            return description == null ? oldMessage : description;
        }
        catch (Exception x) {
            return oldMessage;
        }
    }

    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        FTreeNode[] nodes = selectedNodes;
        this.commands.setPath(this.plugin.fullPath(nodes[0].path()));
        return this.commands;
    }

    private void setDescription(Tree tree, String description) {
        IManagedObject mo;
        try {
            mo = tree.find("/Tree description");
        }
        catch (IllegalArgumentException x) {
            mo = new Histogram1D("Tree description", "Tree description", (IAxis)new FixedAxis(1, 0.0, 1.0));
            tree.add("/", mo);
        }
        ((Histogram1D)mo).annotation().addItem("Tree description", description);
    }

    private String getDescription(Tree tree) {
        try {
            IManagedObject mo = tree.find("/Tree description");
            return ((Histogram1D)mo).annotation().value("Tree description");
        }
        catch (IllegalArgumentException x) {
            return null;
        }
    }

    public class Commands
    extends CommandProcessor {
        private String path;
        ITree masterTree;

        public Commands() {
            this.masterTree = MountPointAdapter.this.plugin.aidaMasterTree();
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void onClose() throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Commands.this.masterTree.unmount(Commands.this.path);
                }
            });
        }

        public void onCommit() throws IOException {
            ITree tree = this.masterTree.findTree(this.path);
            if (((Tree)tree).hasStore()) {
                tree.commit();
            } else {
                this.commitAs(tree);
            }
        }

        public void onCommitAs() throws IOException {
            ITree tree = this.masterTree.findTree(this.path);
            this.commitAs(tree);
        }

        private void commitAs(ITree tree) throws IOException {
            int rc;
            JFileChooser chooser = new JFileChooser(MountPointAdapter.this.plugin.getLastDir());
            chooser.setDialogTitle("Save As...");
            File f = null;
            int returnVal = chooser.showSaveDialog((Component)MountPointAdapter.this.app);
            if (returnVal != 0) {
                return;
            }
            f = chooser.getSelectedFile();
            MountPointAdapter.this.plugin.setLastDir(f);
            if (f.exists() && (rc = JOptionPane.showConfirmDialog((Component)MountPointAdapter.this.app, "Replace existing file?", null, 2)) != 0) {
                return;
            }
            ((Tree)tree).init(f.getAbsolutePath(), false, true, "xml", "", false);
            tree.commit();
        }

        public void onDescription() throws IOException {
            try {
                final Tree tree = (Tree)this.masterTree.findTree(this.path);
                if (tree.isReadOnly()) {
                    MountPointAdapter.this.app.error("This is read-only tree.");
                    return;
                }
                String description = MountPointAdapter.this.getDescription(tree);
                final JTextArea area = new JTextArea();
                area.setLineWrap(true);
                area.setWrapStyleWord(true);
                if (description != null) {
                    area.setText(description);
                }
                final JScrollPane scrollPane = new JScrollPane(area);
                scrollPane.setVerticalScrollBarPolicy(20);
                scrollPane.setHorizontalScrollBarPolicy(31);
                scrollPane.setPreferredSize(new Dimension(350, 350));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int out = JOptionPane.showConfirmDialog((Component)MountPointAdapter.this.app, scrollPane, "Tree description", 2, -1);
                        if (out == 0) {
                            try {
                                MountPointAdapter.this.setDescription(tree, area.getText());
                            }
                            catch (Exception x) {
                                MountPointAdapter.this.app.error("This tree does not support descriptions", (Throwable)x);
                            }
                        }
                    }
                });
            }
            catch (Exception x) {
                MountPointAdapter.this.app.error("This tree does not support descriptions", (Throwable)x);
            }
        }
    }
}

