/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.IManagedObject;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.ConnectEvent;
import hep.aida.ref.event.Connectable;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.ObserverAdapter;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class AIDAConnectionObserver
implements AIDAListener {
    protected Vector sources = new Vector();

    public AIDAConnectionObserver() {
        this(null);
    }

    public AIDAConnectionObserver(JASHist jasHist) {
        if (jasHist != null) {
            this.setObservables(jasHist);
        }
    }

    public abstract void connectAction(ConnectEvent var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservable(Object thing) {
        if (this.sources.size() > 0) {
            Vector vector = this.sources;
            synchronized (vector) {
                boolean b = this.sources.remove(thing);
                if (thing instanceof IsObservable) {
                    ((IsObservable)thing).removeListener((AIDAListener)this);
                    ConnectEvent event = new ConnectEvent(thing);
                    if (thing instanceof Connectable) {
                        event.setConnected(((Connectable)thing).isConnected());
                    }
                    this.stateChangedAction(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservables() {
        if (this.sources.size() > 0) {
            Vector vector = this.sources;
            synchronized (vector) {
                for (int i = 0; i < this.sources.size(); ++i) {
                    IsObservable o = (IsObservable)this.sources.get(i);
                    if (o == null) continue;
                    o.removeListener((AIDAListener)this);
                }
                this.sources.clear();
                this.stateChangedAction(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObservable(IsObservable observable) {
        if (observable == null) {
            return;
        }
        Vector vector = this.sources;
        synchronized (vector) {
            if (!this.sources.contains(observable)) {
                this.sources.add(observable);
                observable.addListener((AIDAListener)this);
                observable.setValid((AIDAListener)this);
            }
            ConnectEvent event = new ConnectEvent((Object)observable);
            if (observable instanceof Connectable) {
                event.setConnected(((Connectable)observable).isConnected());
            }
            this.stateChangedAction(event);
        }
    }

    public void addObservables(IsObservable[] observables) {
        if (observables == null) {
            return;
        }
        for (int i = 0; i < observables.length; ++i) {
            this.addObservable(observables[i]);
        }
    }

    public void setObservables(JASHist jasHist) {
        Enumeration e2;
        if (jasHist == null) {
            return;
        }
        this.removeObservables();
        IsObservable[] observables = null;
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration e1 = jasHist.getDataSources();
        if (e1 != null) {
            while (e1.hasMoreElements()) {
                IsObservable observable;
                JASHistData data = (JASHistData)e1.nextElement();
                DataSource ds = data.getDataSource();
                if (ds instanceof IsObservable) {
                    list.add(ds);
                    continue;
                }
                if (!(ds instanceof ObserverAdapter) || (observable = ((ObserverAdapter)ds).getObservable()) == null) continue;
                list.add(observable);
            }
        }
        if ((e2 = jasHist.get1DFunctions()) != null) {
            while (e2.hasMoreElements()) {
                IsObservable observable;
                JASHistData data = (JASHistData)e2.nextElement();
                DataSource ds = data.getDataSource();
                if (ds instanceof IsObservable) {
                    list.add(ds);
                    continue;
                }
                if (!(ds instanceof ObserverAdapter) || (observable = ((ObserverAdapter)ds).getObservable()) == null) continue;
                list.add(observable);
            }
        }
        observables = new IsObservable[list.size()];
        observables = list.toArray(observables);
        this.addObservables(observables);
    }

    protected boolean checkConnection() {
        boolean connection = true;
        Object[] array = this.sources.toArray();
        if (array == null || array.length == 0) {
            return connection;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof Connectable) || ((Connectable)array[i]).isConnected()) continue;
            connection = false;
            break;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(EventObject e) {
        if (!(e instanceof ConnectEvent)) {
            return;
        }
        ConnectEvent event = (ConnectEvent)e;
        Object obj = event.getSource();
        boolean connect = event.isConnected();
        IsObservable observable = null;
        String name = null;
        if (obj instanceof IManagedObject) {
            name = ((IManagedObject)obj).name();
        }
        if (!(obj instanceof IsObservable)) {
            throw new RuntimeException("Wrong Data Type: " + obj);
        }
        observable = (IsObservable)obj;
        if (obj != null) {
            Object object = obj;
            synchronized (object) {
                this.stateChangedAction(event);
            }
        } else {
            this.stateChangedAction(event);
        }
    }

    protected void stateChangedAction(ConnectEvent event) {
        boolean connect = this.checkConnection();
        AIDAConnectionObserver.invokeOnSwingThread(new ConnectThread(event, connect, this));
    }

    private static void invokeOnSwingThread(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    class ConnectThread
    implements Runnable {
        ConnectEvent event;
        IsObservable observable;
        boolean connect;
        AIDAListener listener;

        ConnectThread(ConnectEvent event, boolean connect, AIDAListener listener) {
            Object obj;
            this.event = event;
            this.connect = connect;
            this.listener = listener;
            this.observable = null;
            if (event != null && (obj = event.getSource()) instanceof IsObservable) {
                this.observable = (IsObservable)obj;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.observable != null) {
                        AIDAConnectionObserver.this.connectAction(this.event, this.connect);
                        IsObservable isObservable = this.observable;
                        synchronized (isObservable) {
                            this.observable.setValid(this.listener);
                            break block6;
                        }
                    }
                    AIDAConnectionObserver.this.connectAction(this.event, this.connect);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

