package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState1;
import org.lsst.ccs.subsystem.refrig.data.RefrigState0;

/**
 ***************************************************************
 *
 *  Implements the refrigeration long lines test control panel.
 *
 *  @author Owen Saxton
 *
 ***************************************************************
 */
public class TestLongLinesControlPanel extends TestRefrigControlPanel {

    private final static Font f = new java.awt.Font("Tahoma", 1, 12);
    private final static Color RED = new Color(150, 0, 0),
                               GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private String subsys;
    double currentPeriod = 5;
    boolean limitsChanged = false;

    public TestLongLinesControlPanel(CommandSender gui) {
        this.gui = gui;
        initComponents();
        stateLabel.setFont(f);
        stateStatus.setFont(f);
        mainPowerLabel.setFont(f);
        mainPowerStatus.setFont(f);
        mainPowerButton.setFont(f);
        loadTripLabel.setFont(f);
        loadTripStatus.setFont(f);
        loadTripButton.setFont(f);
        loadPowerLabel.setFont(f);
        loadPowerStatus.setFont(f);
        periodLabel.setFont(f);
        periodUnitsLabel.setFont(f);
        (new UpdateRefrigStatus(new RefrigState0(0, 0, 0, 0))).run();
        (new DisableSystem()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        stateLabel = new javax.swing.JLabel();
        stateStatus = new javax.swing.JLabel();
        mainPowerLabel = new javax.swing.JLabel();
        mainPowerStatus = new javax.swing.JLabel();
        mainPowerButton = new javax.swing.JButton();
        periodLabel = new javax.swing.JLabel();
        periodTextField = new javax.swing.JTextField();
        periodUnitsLabel = new javax.swing.JLabel();
        loadTripLabel = new javax.swing.JLabel();
        loadTripStatus = new javax.swing.JLabel();
        loadTripButton = new javax.swing.JButton();
        loadPowerLabel = new javax.swing.JLabel();
        loadPowerStatus = new javax.swing.JLabel();

        stateLabel.setText("DAQ State:");
        stateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        stateStatus.setText("....");

        mainPowerLabel.setText("Main Power:");

        mainPowerStatus.setText("....");

        mainPowerButton.setText("....");
        mainPowerButton.setEnabled(false);
        mainPowerButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mainPowerButtonActionPerformed(evt);
            }
        });

        periodLabel.setText("Update Period:");

        periodTextField.setText("...");
        periodTextField.setMinimumSize(new java.awt.Dimension(50, 19));
        periodTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodTextFieldActionPerformed(evt);
            }
        });

        periodUnitsLabel.setText("sec");

        loadTripLabel.setText("Load Power Trip:");

        loadTripStatus.setText("....");

        loadTripButton.setText("....");
        loadTripButton.setEnabled(false);
        loadTripButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTripButtonActionPerformed(evt);
            }
        });

        loadPowerLabel.setText("Load Power:");

        loadPowerStatus.setText("....");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                            .addGap(41, 41, 41)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(stateLabel)
                                .addComponent(mainPowerLabel)))
                        .addGroup(layout.createSequentialGroup()
                            .addContainerGap()
                            .addComponent(loadTripLabel)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(periodLabel)
                            .addComponent(loadPowerLabel))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(loadPowerStatus, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(mainPowerStatus, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(loadTripStatus, javax.swing.GroupLayout.DEFAULT_SIZE, 68, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(mainPowerButton, javax.swing.GroupLayout.DEFAULT_SIZE, 99, Short.MAX_VALUE)
                            .addComponent(loadTripButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(periodTextField, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(periodUnitsLabel))
                    .addComponent(stateStatus, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap(30, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(stateStatus)
                    .addComponent(stateLabel))
                .addGap(11, 11, 11)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(mainPowerLabel)
                    .addComponent(mainPowerStatus)
                    .addComponent(mainPowerButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadTripButton)
                    .addComponent(loadTripStatus)
                    .addComponent(loadTripLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadPowerLabel)
                    .addComponent(loadPowerStatus))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(periodLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(periodUnitsLabel))
                .addContainerGap(22, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void mainPowerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mainPowerButtonActionPerformed
        setMainPowerStatus(evt.getActionCommand().equals("ON"));
        mainPowerButton.setEnabled(false);
    }//GEN-LAST:event_mainPowerButtonActionPerformed

    private void periodTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodTextFieldActionPerformed
        try {
            double value = Double.valueOf(periodTextField.getText());
            setTickMillis((int)(1000 * value));
            periodTextField.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            periodTextField.setText(String.valueOf(currentPeriod));
        }
    }//GEN-LAST:event_periodTextFieldActionPerformed

    private void loadTripButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTripButtonActionPerformed
        setLoadTripStatus(evt.getActionCommand().equals("ON"));
        loadTripButton.setEnabled(false);
    }//GEN-LAST:event_loadTripButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel loadPowerLabel;
    private javax.swing.JLabel loadPowerStatus;
    private javax.swing.JButton loadTripButton;
    private javax.swing.JLabel loadTripLabel;
    private javax.swing.JLabel loadTripStatus;
    private javax.swing.JButton mainPowerButton;
    private javax.swing.JLabel mainPowerLabel;
    private javax.swing.JLabel mainPowerStatus;
    private javax.swing.JLabel periodLabel;
    private javax.swing.JTextField periodTextField;
    private javax.swing.JLabel periodUnitsLabel;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JLabel stateStatus;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setSubsystem(String name) {
        subsys = name;
    }

    @Override
    public void updateControlPanel(RefrigState1 rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    void setMainPowerStatus(boolean on) {
        gui.sendCommand(subsys, null, "setMainPowerEnable", on ? 1 : 0);
    }

    void setLoadTripStatus(boolean on) {
        gui.sendCommand(subsys, null, "setLoadTripEnable", on ? 1 : 0);
    }

    void setTickMillis(int value) {
        gui.sendCommand(subsys, null, "setTickMillis", value);
    }

    class UpdateRefrigStatus implements Runnable {

        RefrigState0 rs;

        UpdateRefrigStatus(RefrigState1 rs) {
            this.rs = (RefrigState0)rs;
        }

        @Override
        public void run() {
            int st = rs.getSystemState();

            stateStatus.setText("RUNNING");
            stateStatus.setForeground(GREEN);

            boolean on = (st & RefrigState0.MAIN_POWER_STATE) != 0;
            boolean tr = (st & RefrigState0.MAIN_TRIPPED_STATE) != 0;
            mainPowerStatus.setText(on ? "ON" : tr ? "TRIPPED" : "OFF");
            mainPowerStatus.setForeground(on ? GREEN : tr ? RED : Color.black);
            mainPowerButton.setEnabled(true);
            mainPowerButton.setText("Turn " + (on ? "OFF" : "ON"));
            mainPowerButton.setActionCommand(on ? "OFF" : "ON");
            
            on &= (st & RefrigState0.LOAD_POWER_STATE) != 0;
            loadPowerStatus.setText(on ? "ON" : "OFF");
            loadPowerStatus.setForeground(on ? GREEN : Color.black);

            on = (st & RefrigState0.LOAD_TRIP_ENAB_STATE) != 0;
            loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
            loadTripStatus.setForeground(on ? GREEN : Color.black);
            loadTripButton.setEnabled(true);
            loadTripButton.setText(on ? "Disable" : "Enable");
            loadTripButton.setActionCommand(on ? "OFF" : "ON");

            periodTextField.setEnabled(true);
            currentPeriod = rs.getTickMillis() / 1000.0;
            periodTextField.setText(String.valueOf(currentPeriod));
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(RED);
            mainPowerButton.setEnabled(false);
            loadTripButton.setEnabled(false);
            periodTextField.setEnabled(false);
        }
 
    }

    private static final long serialVersionUID = 1L;
}
