/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.CompSwitches;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.ui.CompressorControlPanel;

public class CompressorSummaryLine
extends JPanel
implements UiUtilities.ActionHandler {
    private static final int stateWidth = UiUtilities.maxEnumLabelWidth(CompressorState.class);
    private static final int horzInset = UiUtilities.getLabelSize((String)"M").width / 2;
    private String comp;
    private final UiUtilities uiUtils;
    private final CommandSender sender;
    private final CompressorControlPanel control;
    private JDialog dialog = null;
    private JLabel nameLabel;
    private JLabel nameValue;
    private JLabel stateLabel;
    private JLabel stateValue;
    private JLabel switchLabel;
    private ButtonGroup switchBG;
    private JRadioButton switchOffRB;
    private JRadioButton switchOnRB;
    private JButton controlButton;
    private static final long serialVersionUID = 1L;

    public CompressorSummaryLine(int type, CommandSender sender) {
        this.sender = sender;
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        this.control = new CompressorControlPanel(type, sender);
        this.disableSystem();
    }

    public void updateControlPanel(CompState rs) {
        this.comp = rs.getName();
        this.nameValue.setText(this.comp);
        CompressorState cState = rs.getCompressorState();
        Color cColor = cState == CompressorState.OFFLINE ? UiConstants.BLUE : (cState == CompressorState.STOPPED ? Color.BLACK : (cState == CompressorState.RUNNING ? UiConstants.GREEN : (cState == CompressorState.WAITING ? UiConstants.YELLOW : UiConstants.RED)));
        this.stateValue.setText(cState.name());
        this.stateValue.setForeground(cColor);
        SwitchState state = rs.getSwitchState(0);
        JRadioButton selButton = state == SwitchState.ON ? this.switchOnRB : this.switchOffRB;
        selButton.setSelected(true);
        this.nameValue.setEnabled(true);
        this.stateValue.setEnabled(true);
        this.switchOffRB.setEnabled(true);
        this.switchOnRB.setEnabled(true);
        this.control.updateControlPanel(rs);
        this.repaint();
    }

    public final void disableSystem() {
        this.nameValue.setEnabled(false);
        this.stateValue.setEnabled(false);
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.control.disableSystem();
        this.repaint();
    }

    private void initComponents() {
        this.nameLabel = UiUtilities.newLabel((String)"Comp:  ", (int)0);
        this.nameValue = UiUtilities.newLabel((String)"Cryo6", (int)0);
        this.stateLabel = UiUtilities.newLabel((String)"State:  ", (int)0);
        this.stateValue = UiUtilities.newLabel((String)"X", (int)stateWidth);
        this.switchLabel = UiUtilities.newLabel((String)"Enable:  ", (int)0);
        this.switchOffRB = this.uiUtils.newRadioButton("Off", "F");
        this.switchOnRB = this.uiUtils.newRadioButton("On", "T");
        this.switchBG = new ButtonGroup();
        this.switchBG.add(this.switchOffRB);
        this.switchBG.add(this.switchOnRB);
        this.controlButton = this.uiUtils.newButton("Full control...", "", true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, horzInset, 0, 0);
        gbm.anchor = 17;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.nameLabel, gbm);
        ++gbm.gridx;
        gbm.insets.left = 0;
        this.add((Component)this.nameValue, gbm);
        ++gbm.gridx;
        gbm.insets.left = 25;
        this.add((Component)this.stateLabel, gbm);
        ++gbm.gridx;
        gbm.insets.left = 0;
        this.add((Component)this.stateValue, gbm);
        ++gbm.gridx;
        gbm.insets.left = 25;
        this.add((Component)this.switchLabel, gbm);
        ++gbm.gridx;
        gbm.insets.left = 0;
        this.add((Component)this.switchOffRB, gbm);
        ++gbm.gridx;
        gbm.insets.left = horzInset;
        this.add((Component)this.switchOnRB, gbm);
        ++gbm.gridx;
        gbm.insets.left = 25;
        gbm.insets.right = horzInset;
        this.add((Component)this.controlButton, gbm);
    }

    public void handleRadioButton(String name) {
        char action = name.charAt(0);
        int sw = Integer.valueOf(name.substring(1));
        this.sender.sendCommand(this.comp, "setSwitchOn", new Object[]{CompSwitches.ID_MAP.get(sw), action == 'T'});
    }

    public void handleButton(String name) {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        this.dialog = new JDialog(window, this.comp + " Control", Dialog.ModalityType.MODELESS);
        this.dialog.add((Component)this.control, "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(window);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CompressorSummaryLine.this.dialog.setVisible(false);
                CompressorSummaryLine.this.dialog.dispose();
                CompressorSummaryLine.this.dialog = null;
            }
        });
        this.dialog.setVisible(true);
    }
}

