/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelSingle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class CryoPage {
    private final AgentInfo agent;
    private ImageView view;
    private final MonitorField rtdField;
    private final MonitorField heaterField;
    private final MonitorField otherField;

    public CryoPage(AgentInfo agent) {
        this.agent = agent;
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = 0;
        fv.format = " %1$7.1f ";
        this.rtdField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = " %1$6.1f ";
        this.heaterField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        this.otherField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys()){

            public FormattedValue format(AgentChannel channel) {
                FormattedValue fv = super.format(channel);
                String s = channel.getPath();
                s = s.substring(s.lastIndexOf("/") + 1);
                StringBuilder sb = new StringBuilder();
                if (s.startsWith("C")) {
                    sb.append("Cryo Flex ");
                } else if (s.startsWith("GF")) {
                    sb.append("Grid Flex ");
                } else {
                    sb.append("Grid Bay ");
                }
                sb.append(s.charAt(s.length() - 1));
                sb.append(": %1$7.1f ");
                fv.format = sb.toString();
                return fv;
            }
        };
    }

    public ImageView getView() {
        if (this.view != null) {
            return this.view;
        }
        try {
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/cryo.png"));
            this.view = new ImageView("Cold Plate", back, 0.5, 2.0);
            this.placeRTD(2, 0.687, 0.5798, 1.0f, 0.0f);
            this.placeRTD(3, 0.687, 0.433, 1.0f, 0.0f);
            this.placeRTD(4, 0.687, 0.2846, 1.0f, 0.0f);
            this.placeRTD(12, 0.5945, 0.5798, 1.0f, 0.0f, true);
            this.placeRTD(13, 0.5945, 0.433, 1.0f, 0.0f);
            this.placeRTD(14, 0.5945, 0.2846, 1.0f, 0.0f, true);
            this.placeRTD(21, 0.5009, 0.738, 1.0f, 0.0f);
            this.placeRTD(22, 0.5009, 0.5798, 1.0f, 0.0f);
            this.placeRTD(24, 0.5009, 0.2846, 1.0f, 0.0f);
            this.placeRTD(25, 0.5009, 0.1401, 1.0f, 0.0f);
            this.placeRTD(30, 0.4149, 0.8675, 0.0f, 1.0f);
            this.placeRTD(31, 0.4149, 0.725, 0.0f, 1.0f, true);
            this.placeRTD(33, 0.4149, 0.4202, 0.0f, 1.0f);
            this.placeRTD(34, 0.4149, 0.2726, 0.0f, 1.0f);
            this.placeRTD(41, 0.3214, 0.725, 0.0f, 1.0f);
            this.placeRTD(42, 0.3214, 0.567, 0.0f, 1.0f);
            this.placeRTD(43, 0.3214, 0.4202, 0.0f, 1.0f, true);
            this.placeRTD(51, 0.2259, 0.725, 0.0f, 1.0f);
            this.placeRTD(52, 0.2259, 0.567, 0.0f, 1.0f);
            this.placeRTD(53, 0.2259, 0.4202, 0.0f, 1.0f);
            this.placeHeaterPower(0, 0.837, 0.8268);
            this.placeHeaterPower(1, 0.837, 0.744);
            this.placeHeaterPower(2, 0.837, 0.5964);
            this.placeHeaterPower(3, 0.837, 0.4413);
            this.placeHeaterPower(4, 0.837, 0.3102);
            this.placeHeaterPower(5, 0.837, 0.238);
            String channelPath = this.agent.getName() + "/main/Trim_Htrs/CryoTotal_P";
            DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(channelPath, null, null), this.heaterField);
            CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
            ImageView.Item item = new ImageView.Item((Object)table);
            item.setPosition(0.92, 0.96);
            item.setAlignment(0.0, 1.0);
            item.setMaxSize(0.08, 0.06);
            this.view.add(item);
            DefaultMonitorCell[] cc = new DefaultMonitorCell[]{new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GFX-RTD-01", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GFX-RTD-02", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GFX-RTD-03", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GFX-RTD-04", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/CFX-RTD-01", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/CFX-RTD-02", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/CFX-RTD-03", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/CFX-RTD-04", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GRD-RTD-01", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GRD-RTD-02", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GRD-RTD-03", null, null), this.otherField), new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(this.agent.getName() + "/main/Grid_Temp/GRD-RTD-04", null, null), this.otherField)};
            table = new CellTableView(12, 1, cc);
            item = new ImageView.Item((Object)table);
            item.setPosition(0.109, 0.28);
            item.setAlignment(0.5, 0.0);
            item.setMaxSize(0.183, 0.668);
            this.view.add(item);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.view;
    }

    private void placeRTD(int id, double x, double y, float horAlign, float vertAlign, boolean redBorder) throws IOException {
        String channelPath = String.format("%1$s/main/Cryo_Temp/CYP-RTD-%2$02d", this.agent.getName(), id);
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = 0;
        fv.format = "<html><center>RTD-" + String.format("%02d", id) + ":<br>%1$6.1f";
        MonitorField field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(channelPath, null, null), field);
        CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
        if (redBorder) {
            Insets ins = table.getBorder().getBorderInsets((Component)table);
            table.setBorder((Border)BorderFactory.createMatteBorder(3 * ins.top, 3 * ins.left, 3 * ins.bottom, 3 * ins.right, Color.RED));
        }
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment((double)horAlign, (double)vertAlign);
        item.setMaxSize(0.08, 0.064);
        this.view.add(item);
    }

    private void placeRTD(int id, double x, double y, float horAlign, float vertAlign) throws IOException {
        this.placeRTD(id, x, y, horAlign, vertAlign, false);
    }

    private void placeHeaterPower(int id, double x, double y) throws IOException {
        String channelPath = String.format("%1$s/main/Trim_Htrs/CryoHtr%2$1d_P", this.agent.getName(), id);
        DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(channelPath, null, null), this.heaterField);
        CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment(0.0, 0.0);
        item.setMaxSize(0.126, 0.06);
        this.view.add(item);
    }
}

