/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.plugins.commandbrowser.HintTextField;

public final class ArgInputPanel
extends JPanel
implements ListSelectionListener {
    private DictionaryCommand command;
    private JLabel[] argName;
    private Supplier<String>[] argGetters;
    private final JPanel formPane;
    private final JEditorPane commandDesc;
    private final Map<String, String[]> history = new LinkedHashMap<String, String[]>(4, 0.8f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String[]> eldest) {
            return this.size() > 50;
        }
    };

    public ArgInputPanel() {
        this.setLayout(new BorderLayout());
        this.commandDesc = new JEditorPane();
        this.add((Component)this.commandDesc, "Center");
        this.commandDesc.setBackground(new Color(237, 236, 235));
        this.commandDesc.setEditable(false);
        this.commandDesc.setContentType("text/html");
        this.commandDesc.setText("      ");
        this.formPane = new JPanel();
        this.formPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        this.command = (DictionaryCommand)((JList)lse.getSource()).getSelectedValue();
        this.clear();
        if (this.command != null) {
            this.fill();
        }
    }

    public String getFormattedArgumentValues() {
        StringBuilder res = new StringBuilder();
        for (Supplier<String> argGetter : this.argGetters) {
            res.append(argGetter.get()).append(" ");
        }
        return res.toString();
    }

    public String[] getFormattedValues() {
        String[] res = new String[this.argGetters.length];
        for (int i = 0; i < this.argGetters.length; ++i) {
            res[i] = this.argGetters[i].get();
        }
        if (this.command != null && res.length != 0) {
            this.history.put(this.command.getCommandName(), (String[])res.clone());
        }
        return res;
    }

    private void clear() {
        this.formPane.removeAll();
        this.commandDesc.setText("       ");
    }

    private void fill() {
        this.clear();
        int nArgs = this.command.getArguments().length;
        this.formPane.setLayout(new GridLayout(nArgs, 2));
        this.argName = new JLabel[nArgs];
        this.argGetters = new Supplier[nArgs];
        String[] hist = this.history.get(this.command.getCommandName());
        if (hist != null && hist.length != nArgs) {
            hist = null;
        }
        for (int i = 0; i < nArgs; ++i) {
            DictionaryArgument da = this.command.getArguments()[i];
            this.argName[i] = new JLabel(da.getName());
            this.formPane.add(this.argName[i]);
            if (da.getAllowedValues().isEmpty()) {
                HintTextField htf = new HintTextField(this.command.getArguments()[i].getSimpleType());
                this.argGetters[i] = () -> htf.getText();
                this.formPane.add(htf);
                if (hist == null || hist[i].isEmpty()) continue;
                htf.setText(hist[i]);
                continue;
            }
            JComboBox<String> allowedValuesBox = new JComboBox<String>(da.getAllowedValues().toArray(new String[0]));
            if (hist != null) {
                allowedValuesBox.setSelectedItem(hist[i]);
            }
            this.argGetters[i] = () -> allowedValuesBox.getSelectedItem().toString();
            this.formPane.add(allowedValuesBox);
        }
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(this.command.getType()).append(". Level: ").append(this.command.getLevel());
        sb.append("<h3>").append(this.command.getDescription()).append("</h3>");
        for (DictionaryArgument arg : this.command.getArguments()) {
            sb.append(" <b>").append(arg.getSimpleType()).append("</b> ").append(arg.getName()).append(" : ").append(arg.getDescription()).append("<br>");
        }
        this.commandDesc.setText(sb.toString());
        this.setEnabled(this.isEnabled());
        this.repaint();
        this.validate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.add((Component)this.formPane, "South");
        } else {
            this.remove(this.formPane);
        }
    }
}

