/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;

public class IFunctionWrapper
extends Function {
    private IFunction f;
    private boolean isModel = false;
    private IModelFunction model;
    private boolean hasNormalization = false;
    private double[] vars;

    public IFunctionWrapper(String name, IFunction f) {
        super(name);
        this.f = f;
        if (f instanceof IModelFunction) {
            this.isModel = true;
            this.model = (IModelFunction)f;
            this.hasNormalization = this.model.providesNormalization();
        }
        String[] dependents = f.variableNames();
        this.vars = new double[dependents.length];
        VariableList list = new VariableList();
        for (int i = 0; i < dependents.length; ++i) {
            list.add(new Dependent(dependents[i], -10.0, 10.0));
        }
        String[] parNames = f.parameterNames();
        double[] parValues = f.parameters();
        for (int i = 0; i < parNames.length; ++i) {
            list.add(new Parameter(parNames[i], parValues[i]));
        }
        this.addVariables(list);
        super.setNormalizationParamter(null);
    }

    @Override
    public void variableChanged(Variable var) {
        if (var instanceof Parameter && this.getParameter(var.name()) != null) {
            this.f.setParameter(var.name(), var.value());
        }
    }

    private void loadDependents() {
        for (int i = 0; i < this.f.dimension(); ++i) {
            this.vars[i] = this.getDependent(i).value();
        }
    }

    @Override
    public boolean hasAnalyticalVariableGradient(Variable var) {
        return this.f.providesGradient();
    }

    @Override
    public double functionValue() {
        this.loadDependents();
        return this.f.value(this.vars);
    }

    @Override
    public double value() {
        if (this.isModel && this.hasNormalization) {
            this.loadDependents();
            return this.model.value(this.vars);
        }
        return super.value();
    }

    @Override
    public double[] gradient() {
        this.loadDependents();
        return this.f.gradient(this.vars);
    }

    @Override
    public double[] parameterGradient() {
        if (this.isModel) {
            this.loadDependents();
            return this.model.parameterGradient(this.vars);
        }
        throw new IllegalArgumentException("Cannot provide parameters gradient");
    }

    @Override
    protected void updateNormalization() {
        if (!this.isModel || !this.hasNormalization) {
            super.updateNormalization();
        }
    }

    @Override
    public boolean isNormalized() {
        if (this.isModel && this.hasNormalization) {
            return this.model.isNormalized();
        }
        return super.isNormalized();
    }

    @Override
    public void normalize(boolean normalize) {
        if (this.isModel && this.hasNormalization) {
            this.model.normalize(normalize);
        } else {
            super.normalize(normalize);
        }
    }

    @Override
    public boolean hasAnalyticalNormalization(Dependent dep) {
        return this.hasNormalization;
    }

    @Override
    public double evaluateAnalyticalNormalization(Dependent dep) {
        return 1.0;
    }
}

