/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentStatus;
import org.lsst.ccs.gconsole.plugins.commandbrowser.Browser;
import org.lsst.ccs.gconsole.util.tree.SModel;
import org.lsst.ccs.gconsole.util.tree.SNode;
import org.lsst.ccs.gconsole.util.tree.STree;

public final class ComponentTree
extends STree<Dictionary> {
    private final AgentPanel.Descriptor descriptor;
    private AgentStatus agent;

    ComponentTree(AgentPanel agentPanel) {
        this.descriptor = agentPanel.descriptor;
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new Renderer());
    }

    void updateData(AgentStatus agentHandle) {
        STree.Descriptor d = this.agent == agentHandle ? this.save() : null;
        this.agent = agentHandle;
        if (this.agent == null) {
            this.setModel(new SModel());
        } else {
            TreeMap<String, Dictionary> data = new TreeMap<String, Dictionary>();
            block0: for (Map.Entry<String, Dictionary> e : this.agent.getDictionaries().entrySet()) {
                Dictionary dict = e.getValue();
                if (dict.size() <= 0) continue;
                for (DictionaryCommand com : dict) {
                    if (this.descriptor.isHideSystem() && com.getCategory().equals((Object)Command.CommandCategory.SYSTEM) || this.descriptor.isHideLocked() && Browser.isCommandLocked(com, dict)) continue;
                    data.put(e.getKey(), dict);
                    continue block0;
                }
            }
            SModel<Dictionary> model = new SModel<Dictionary>();
            model.sort(null);
            model.update(data);
            this.setModel(model);
            if (d != null) {
                this.restore(d);
            }
            this.expandLevel(2);
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setForeground(Renderer.greyOut((SNode)value) ? Color.GRAY : Color.BLACK);
            return this;
        }

        static boolean greyOut(SNode<Dictionary> node) {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                if (Renderer.greyOut((SNode)children.nextElement())) continue;
                return false;
            }
            Dictionary d = node.getUserObject();
            if (d != null) {
                for (DictionaryCommand dc : d) {
                    if (Browser.isCommandLocked(dc, d)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

