package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

/**
 *  Implements the cold section line panel.
 *
 *  @author Owen Saxton
 */
public class ColdSectionPanel extends JPanel implements UiUtilities.ActionHandler {

    private static final String[] sectionNames = new String[ThermalState.NUM_COLD_SECTIONS];
    static {
        sectionNames[ThermalState.COLD_SECTION_MINUS_Y] = "-Y";
        sectionNames[ThermalState.COLD_SECTION_PLUS_Y] = "+Y";
    }

    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private final JCheckBox[] coldCbx = new JCheckBox[ThermalState.NUM_COLD_SECTIONS];

    public ColdSectionPanel(CommandSender sender) {
        this.sender = sender;
        uiUtils = new UiUtilities(this);
        initComponents();
    }

    public void updatePanel(ThermalState rs) {
        for (int sect = 0; sect < ThermalState.NUM_COLD_SECTIONS; sect++) {
            coldCbx[sect].setEnabled(true);
            coldCbx[sect].setSelected(rs.isColdSectionEnabled(sect));
        }
    }

    public void disablePanel() {
        for (JCheckBox cbx : coldCbx) {
            cbx.setEnabled(false);
        }
    }

    private void initComponents() {
        for (int sect = 0; sect < ThermalState.NUM_COLD_SECTIONS; sect++) {
            coldCbx[sect] = uiUtils.newCheckBox("Enable " + sectionNames[sect] + " Cold Htrs", String.valueOf(sect));
        }
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridx = 0;
        gbc.gridy = 0;
        for (JCheckBox cbx : coldCbx) {
            add(cbx, gbc);
            gbc.gridx++;
            gbc.insets.left = 20;
        }
    }

    @Override
    public void handleCheckBox(String name, boolean isSelected) {
        sender.sendCommand(null, "enableColdSection", Integer.valueOf(name), isSelected);
    }

    private static final long serialVersionUID = 1L;
}
