package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.RefrigState1;
import org.lsst.ccs.subsystem.refrig.data.RefrigState0;

/**
 **************************************************************
 *
 *  Implements the refrigeration subscale test control panel.
 *
 *  @author Owen Saxton
 *
 **************************************************************
 */
public class TestSubscaleControlPanel0 extends TestRefrigControlPanel {

    private final static Color RED = new Color(150, 0, 0),
                               GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private final TextFieldXX periodTFX, powerTFX, tempTFX;
    private String subsys;
    private boolean enabled;

    public TestSubscaleControlPanel0(CommandSender gui) {
        this.gui = gui;
        initComponents();
        periodTFX = new TextFieldXX(periodTextField, TextFieldXX.TYPE_DOUBLE);
        powerTFX = new TextFieldXX(powerTextField, TextFieldXX.TYPE_DOUBLE);
        tempTFX = new TextFieldXX(tempTextField, TextFieldXX.TYPE_DOUBLE);
        (new UpdateRefrigStatus(new RefrigState0(0, 0, 0, 0))).run();
        (new DisableSystem()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPowerBG = new javax.swing.ButtonGroup();
        loadTripBG = new javax.swing.ButtonGroup();
        loadPowerBG = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        loadPowerLabel = new javax.swing.JLabel();
        powerUnitsLabel = new javax.swing.JLabel();
        mainPowerOffRB = new javax.swing.JRadioButton();
        mainPowerFullRB = new javax.swing.JRadioButton();
        loadTripLabel = new javax.swing.JLabel();
        loadTripDisableRB = new javax.swing.JRadioButton();
        loadTripEnableRB = new javax.swing.JRadioButton();
        loadPowerManualRB = new javax.swing.JRadioButton();
        loadPowerOffRB = new javax.swing.JRadioButton();
        loadPowerAutoRB = new javax.swing.JRadioButton();
        tempTextField = new javax.swing.JTextField();
        tempUnitsLabel = new javax.swing.JLabel();
        mainPowerStatus = new javax.swing.JLabel();
        loadPowerStatus = new javax.swing.JLabel();
        loadTripStatus = new javax.swing.JLabel();
        stateLabel = new javax.swing.JLabel();
        mainPowerHeaterRB = new javax.swing.JRadioButton();
        stateStatus = new javax.swing.JLabel();
        mainPowerLabel = new javax.swing.JLabel();
        periodLabel = new javax.swing.JLabel();
        periodTextField = new javax.swing.JTextField();
        periodUnitsLabel = new javax.swing.JLabel();
        powerTextField = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel2.setForeground(java.awt.Color.blue);
        jPanel2.setFocusable(false);

        loadPowerLabel.setText("Heater Power:");

        powerUnitsLabel.setText("watts");

        mainPowerBG.add(mainPowerOffRB);
        mainPowerOffRB.setText("Off");
        mainPowerOffRB.setFocusable(false);
        mainPowerOffRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mainPowerOffRBActionPerformed(evt);
            }
        });

        mainPowerBG.add(mainPowerFullRB);
        mainPowerFullRB.setText("Full");
        mainPowerFullRB.setFocusable(false);
        mainPowerFullRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mainPowerFullRBActionPerformed(evt);
            }
        });

        loadTripLabel.setText("Heat Load Trip:");

        loadTripBG.add(loadTripDisableRB);
        loadTripDisableRB.setText("Disable");
        loadTripDisableRB.setFocusable(false);
        loadTripDisableRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTripDisableRBActionPerformed(evt);
            }
        });

        loadTripBG.add(loadTripEnableRB);
        loadTripEnableRB.setText("Enable");
        loadTripEnableRB.setFocusable(false);
        loadTripEnableRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTripEnableRBActionPerformed(evt);
            }
        });

        loadPowerBG.add(loadPowerManualRB);
        loadPowerManualRB.setText("Manual");
        loadPowerManualRB.setFocusable(false);
        loadPowerManualRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadPowerManualRBActionPerformed(evt);
            }
        });

        loadPowerBG.add(loadPowerOffRB);
        loadPowerOffRB.setText("Off");
        loadPowerOffRB.setFocusable(false);
        loadPowerOffRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadPowerOffRBActionPerformed(evt);
            }
        });

        loadPowerBG.add(loadPowerAutoRB);
        loadPowerAutoRB.setText("Auto");
        loadPowerAutoRB.setFocusable(false);
        loadPowerAutoRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadPowerAutoRBActionPerformed(evt);
            }
        });

        tempTextField.setText("...");
        tempTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tempTextFieldFocusLost(evt);
            }
        });
        tempTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tempTextFieldActionPerformed(evt);
            }
        });
        tempTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                tempTextFieldKeyTyped(evt);
            }
        });

        tempUnitsLabel.setText("°C");

        mainPowerStatus.setText("...");

        loadPowerStatus.setText("...");

        loadTripStatus.setText("...");

        stateLabel.setText("DAQ State:");
        stateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        mainPowerBG.add(mainPowerHeaterRB);
        mainPowerHeaterRB.setText("Heater");
        mainPowerHeaterRB.setFocusable(false);
        mainPowerHeaterRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mainPowerHeaterRBActionPerformed(evt);
            }
        });

        stateStatus.setText("....");

        mainPowerLabel.setText("Main Power:");

        periodLabel.setText("Update Period:");

        periodTextField.setText("...");
        periodTextField.setMinimumSize(new java.awt.Dimension(50, 19));
        periodTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                periodTextFieldFocusLost(evt);
            }
        });
        periodTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodTextFieldActionPerformed(evt);
            }
        });
        periodTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                periodTextFieldKeyTyped(evt);
            }
        });

        periodUnitsLabel.setText("sec");

        powerTextField.setText("...");
        powerTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                powerTextFieldFocusLost(evt);
            }
        });
        powerTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                powerTextFieldActionPerformed(evt);
            }
        });
        powerTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                powerTextFieldKeyTyped(evt);
            }
        });

        jPanel3.setBackground(java.awt.Color.white);
        jPanel3.setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.Color.blue));
        jPanel3.setForeground(java.awt.Color.blue);

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 14)); // NOI18N
        jLabel1.setForeground(java.awt.Color.blue);
        jLabel1.setText("Subscale");

        jLabel2.setFont(new java.awt.Font("Dialog", 1, 14)); // NOI18N
        jLabel2.setForeground(java.awt.Color.blue);
        jLabel2.setText("Camera");

        jLabel3.setFont(new java.awt.Font("Dialog", 1, 14)); // NOI18N
        jLabel3.setForeground(java.awt.Color.blue);
        jLabel3.setText("Test");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3)
                    .addComponent(jLabel2)
                    .addComponent(jLabel1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3)
                .addContainerGap())
        );

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(loadPowerLabel)
                    .addComponent(loadTripLabel)
                    .addComponent(mainPowerLabel)
                    .addComponent(stateLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(stateStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(70, 70, 70)
                        .addComponent(periodLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(periodTextField, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(6, 6, 6)
                        .addComponent(periodUnitsLabel))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(loadTripStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(1, 1, 1)
                        .addComponent(loadTripDisableRB)
                        .addGap(18, 18, 18)
                        .addComponent(loadTripEnableRB))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(loadPowerStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(1, 1, 1)
                        .addComponent(loadPowerOffRB)
                        .addGap(18, 18, 18)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addComponent(powerTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(4, 4, 4)
                                .addComponent(powerUnitsLabel))
                            .addComponent(loadPowerManualRB))
                        .addGap(27, 27, 27)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addComponent(tempTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(3, 3, 3)
                                .addComponent(tempUnitsLabel))
                            .addComponent(loadPowerAutoRB)))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(mainPowerStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(1, 1, 1)
                        .addComponent(mainPowerOffRB)
                        .addGap(18, 18, 18)
                        .addComponent(mainPowerFullRB)
                        .addGap(18, 18, 18)
                        .addComponent(mainPowerHeaterRB)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(stateLabel)
                            .addComponent(periodLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(periodUnitsLabel)
                            .addComponent(stateStatus, javax.swing.GroupLayout.PREFERRED_SIZE, 17, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(2, 2, 2)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(mainPowerStatus)
                            .addComponent(mainPowerOffRB)
                            .addComponent(mainPowerFullRB)
                            .addComponent(mainPowerLabel)
                            .addComponent(mainPowerHeaterRB))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(loadTripLabel)
                            .addComponent(loadTripStatus)
                            .addComponent(loadTripDisableRB)
                            .addComponent(loadTripEnableRB))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(loadPowerLabel)
                            .addComponent(loadPowerStatus)
                            .addComponent(loadPowerOffRB)
                            .addComponent(loadPowerManualRB)
                            .addComponent(loadPowerAutoRB)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                        .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(6, 6, 6)))
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(powerTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(powerUnitsLabel)
                    .addComponent(tempTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tempUnitsLabel))
                .addGap(8, 8, 8))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(5, 5, 5)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(5, 5, 5))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void periodTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodTextFieldActionPerformed
        Double value = (Double)periodTFX.action();
        if (value != null) {
            gui.sendCommand(subsys, null, "setTickMillis", (int)(1000 * value));
        }
    }//GEN-LAST:event_periodTextFieldActionPerformed

    private void powerTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_powerTextFieldActionPerformed
        Double value = (Double)powerTFX.action();
        if (value != null) {
            gui.sendCommand(subsys, null, "setLoadPower", value);
        }
    }//GEN-LAST:event_powerTextFieldActionPerformed

    private void mainPowerOffRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mainPowerOffRBActionPerformed
        setMainPowerState(0);
    }//GEN-LAST:event_mainPowerOffRBActionPerformed

    private void loadTripDisableRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTripDisableRBActionPerformed
        setLoadTripState(0);
    }//GEN-LAST:event_loadTripDisableRBActionPerformed

    private void mainPowerFullRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mainPowerFullRBActionPerformed
        setMainPowerState(1);
    }//GEN-LAST:event_mainPowerFullRBActionPerformed

    private void loadTripEnableRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTripEnableRBActionPerformed
        setLoadTripState(1);
    }//GEN-LAST:event_loadTripEnableRBActionPerformed

    private void loadPowerManualRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadPowerManualRBActionPerformed
        setLoadPowerState(1);
    }//GEN-LAST:event_loadPowerManualRBActionPerformed

    private void loadPowerOffRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadPowerOffRBActionPerformed
        setLoadPowerState(0);
    }//GEN-LAST:event_loadPowerOffRBActionPerformed

    private void loadPowerAutoRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadPowerAutoRBActionPerformed
        setLoadPowerState(-1);
    }//GEN-LAST:event_loadPowerAutoRBActionPerformed

    private void tempTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tempTextFieldActionPerformed
        Double value = (Double)tempTFX.action();
        if (value != null) {
            gui.sendCommand(subsys, null, "setLoadTemp", value);
        }
    }//GEN-LAST:event_tempTextFieldActionPerformed

    private void mainPowerHeaterRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mainPowerHeaterRBActionPerformed
        setMainPowerState(-1);
    }//GEN-LAST:event_mainPowerHeaterRBActionPerformed

    private void periodTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_periodTextFieldKeyTyped
        periodTFX.keyTyped(evt.getKeyChar());
    }//GEN-LAST:event_periodTextFieldKeyTyped

    private void periodTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_periodTextFieldFocusLost
        periodTFX.focusLost();
    }//GEN-LAST:event_periodTextFieldFocusLost

    private void powerTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_powerTextFieldKeyTyped
        powerTFX.keyTyped(evt.getKeyChar());
    }//GEN-LAST:event_powerTextFieldKeyTyped

    private void powerTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_powerTextFieldFocusLost
        powerTFX.focusLost();
    }//GEN-LAST:event_powerTextFieldFocusLost

    private void tempTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tempTextFieldKeyTyped
        tempTFX.keyTyped(evt.getKeyChar());
    }//GEN-LAST:event_tempTextFieldKeyTyped

    private void tempTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tempTextFieldFocusLost
        tempTFX.focusLost();
    }//GEN-LAST:event_tempTextFieldFocusLost

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JRadioButton loadPowerAutoRB;
    private javax.swing.ButtonGroup loadPowerBG;
    private javax.swing.JLabel loadPowerLabel;
    private javax.swing.JRadioButton loadPowerManualRB;
    private javax.swing.JRadioButton loadPowerOffRB;
    private javax.swing.JLabel loadPowerStatus;
    private javax.swing.ButtonGroup loadTripBG;
    private javax.swing.JRadioButton loadTripDisableRB;
    private javax.swing.JRadioButton loadTripEnableRB;
    private javax.swing.JLabel loadTripLabel;
    private javax.swing.JLabel loadTripStatus;
    private javax.swing.ButtonGroup mainPowerBG;
    private javax.swing.JRadioButton mainPowerFullRB;
    private javax.swing.JRadioButton mainPowerHeaterRB;
    private javax.swing.JLabel mainPowerLabel;
    private javax.swing.JRadioButton mainPowerOffRB;
    private javax.swing.JLabel mainPowerStatus;
    private javax.swing.JLabel periodLabel;
    private javax.swing.JTextField periodTextField;
    private javax.swing.JLabel periodUnitsLabel;
    private javax.swing.JTextField powerTextField;
    private javax.swing.JLabel powerUnitsLabel;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JLabel stateStatus;
    private javax.swing.JTextField tempTextField;
    private javax.swing.JLabel tempUnitsLabel;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setSubsystem(String name) {
        subsys = name;
    }

    @Override
    public void updateControlPanel(RefrigState1 rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    @Override
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void setMainPowerState(int value) {
        mainPowerOffRB.setEnabled(false);
        mainPowerFullRB.setEnabled(false);
        mainPowerHeaterRB.setEnabled(false);
        gui.sendCommand(subsys, null, "setMainPowerEnable", value);
    }

    private void setLoadTripState(int value) {
        loadTripDisableRB.setEnabled(false);
        loadTripEnableRB.setEnabled(false);
        gui.sendCommand(subsys, null, "setLoadTripEnable", value);
    }
    
    private void setLoadPowerState(int value) {
        loadPowerOffRB.setEnabled(false);
        loadPowerManualRB.setEnabled(false);
        loadPowerAutoRB.setEnabled(false);
        gui.sendCommand(subsys, null, "setLoadPowerEnable", value);
    }
    
    class UpdateRefrigStatus implements Runnable {

        private final RefrigState0 rs;

        UpdateRefrigStatus(RefrigState1 rs) {
            this.rs = (RefrigState0)rs;
        }

        @Override
        public void run() {
            if (!enabled) {
                stateStatus.setText("RUNNING");
                stateStatus.setForeground(GREEN);
                mainPowerStatus.setEnabled(true);
                loadTripStatus.setEnabled(true);
                loadPowerStatus.setEnabled(true);
                enabled = true;
            }

            int st = rs.getSystemState();

            boolean on = (st & RefrigState0.MAIN_POWER_STATE) != 0;
            boolean tr = (st & RefrigState0.MAIN_TRIPPED_STATE) != 0;
            boolean heat = (st & RefrigState0.MAIN_LOAD_ONLY_STATE) != 0;
            mainPowerStatus.setText(on ? heat ? "HEATER" : "FULL" : tr ? "TRIPPED" : "OFF");
            mainPowerStatus.setForeground(on ? GREEN : tr ? RED : Color.black);
            JRadioButton selButton = on ? heat ? mainPowerHeaterRB : mainPowerFullRB : mainPowerOffRB;
            selButton.setSelected(true);
            mainPowerOffRB.setEnabled(selButton != mainPowerOffRB);
            mainPowerFullRB.setEnabled(selButton != mainPowerFullRB && !tr);
            mainPowerHeaterRB.setEnabled(selButton != mainPowerHeaterRB && !tr);
            
            on = (st & RefrigState0.LOAD_TRIP_ENAB_STATE) != 0;
            loadTripStatus.setText(on ? "ENABLED" : "DISABLED");
            loadTripStatus.setForeground(on ? GREEN : Color.black);
            selButton = on ? loadTripEnableRB : loadTripDisableRB;
            selButton.setSelected(true);
            loadTripDisableRB.setEnabled(selButton != loadTripDisableRB);
            loadTripEnableRB.setEnabled(selButton != loadTripEnableRB);

            on = (st & RefrigState0.LOAD_POWER_STATE) != 0;
            boolean auto = (st & RefrigState0.LOAD_TEMP_LOOP_STATE) != 0;
            loadPowerStatus.setText(!on ? "OFF" : auto ? "AUTO" : "MANUAL");
            loadPowerStatus.setForeground(!on ? Color.black : auto ? RED : GREEN);
            selButton = !on ? loadPowerOffRB : auto ? loadPowerAutoRB : loadPowerManualRB;
            selButton.setSelected(true);
            loadPowerOffRB.setEnabled(selButton != loadPowerOffRB);
            loadPowerManualRB.setEnabled(selButton != loadPowerManualRB);
            loadPowerAutoRB.setEnabled(selButton != loadPowerAutoRB);

            periodTFX.update(rs.getTickMillis() / 1000.0, true);
            powerTFX.update(rs.getLoadPower(), true);
            tempTFX.update(rs.getLoadTemp(), true);
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(RED);
            mainPowerStatus.setEnabled(false);
            mainPowerOffRB.setEnabled(false);
            mainPowerFullRB.setEnabled(false);
            mainPowerHeaterRB.setEnabled(false);
            loadTripStatus.setEnabled(false);
            loadTripDisableRB.setEnabled(false);
            loadTripEnableRB.setEnabled(false);
            loadPowerStatus.setEnabled(false);
            loadPowerOffRB.setEnabled(false);
            loadPowerManualRB.setEnabled(false);
            loadPowerAutoRB.setEnabled(false);
            periodTFX.disable();
            powerTFX.disable();
            tempTFX.disable();
            enabled = false;
        }
 
    }

    private static final long serialVersionUID = 1L;
}
