/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.AuxHeaterPanel;
import org.lsst.ccs.subsystem.refrig.ui.TrimHeaterPanel;

public class ThermalControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private final TrimHeaterPanel[] trimHeaterPanels = new TrimHeaterPanel[7];
    private final AuxHeaterPanel[] auxHeaterPanels = new AuxHeaterPanel[3];
    private JPanel trimPanel;
    private JPanel auxPanel;
    private final JPanel mainPanel = new JPanel();
    private Integer[] trimHeaters = new Integer[0];
    private Integer[] auxHeaters = new Integer[0];
    private static final long serialVersionUID = 1L;

    public ThermalControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getSystemState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((ThermalState)reply);
    }

    public void updatePanel(ThermalState rs) {
        SwingUtilities.invokeLater(new UpdateThermalState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int htr;
        this.statusPanel = new SystemStatusPanel(this.sender);
        for (htr = 0; htr < 7; ++htr) {
            this.trimHeaterPanels[htr] = new TrimHeaterPanel(htr, this.sender);
        }
        this.trimPanel = UiUtilities.newBorderedPanel((String)"Trim heater control");
        for (htr = 0; htr < 3; ++htr) {
            this.auxHeaterPanels[htr] = new AuxHeaterPanel(htr, this.sender);
        }
        this.auxPanel = UiUtilities.newBorderedPanel((String)"Auxiliary heater control");
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(5, 0, 0, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 11;
        this.mainPanel.add((Component)this.statusPanel, gbm);
        ++gbm.gridy;
        gbm.insets.bottom = 5;
        this.mainPanel.add((Component)this.trimPanel, gbm);
        this.add(this.mainPanel);
    }

    private void updateTrimPanel(Integer[] newTrimHeaters) {
        int n;
        Integer[] integerArray = this.trimHeaters;
        int n2 = integerArray.length;
        for (n = 0; n < n2; ++n) {
            int htr = integerArray[n];
            this.trimPanel.remove(this.trimHeaterPanels[htr]);
        }
        this.trimHeaters = newTrimHeaters;
        GridBagConstraints gbt = new GridBagConstraints();
        gbt.insets = new Insets(5, 0, 0, 0);
        gbt.gridx = 0;
        gbt.gridy = 0;
        gbt.anchor = 11;
        Integer[] integerArray2 = this.trimHeaters;
        n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int htr = integerArray2[i];
            gbt.insets.bottom = gbt.gridy == this.trimHeaters.length - 1 ? 5 : 0;
            this.trimPanel.add((Component)this.trimHeaterPanels[htr], gbt);
            gbt.insets.top = 0;
            ++gbt.gridy;
        }
    }

    private void updateAuxPanel(Integer[] newAuxHeaters) {
        int n;
        if (this.auxHeaters.length > 0) {
            Integer[] integerArray = this.auxHeaters;
            int n2 = integerArray.length;
            for (n = 0; n < n2; ++n) {
                int htr = integerArray[n];
                this.auxPanel.remove(this.auxHeaterPanels[htr]);
            }
            this.mainPanel.remove(this.auxPanel);
        }
        this.auxHeaters = newAuxHeaters;
        if (this.auxHeaters.length > 0) {
            GridBagConstraints gba = new GridBagConstraints();
            gba.insets = new Insets(5, 0, 0, 0);
            gba.gridx = 0;
            gba.gridy = 0;
            gba.anchor = 11;
            Integer[] integerArray = this.auxHeaters;
            n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int htr = integerArray[i];
                gba.insets.bottom = gba.gridy == this.auxHeaters.length - 1 ? 5 : 0;
                this.auxPanel.add((Component)this.auxHeaterPanels[htr], gba);
                gba.insets.top = 0;
                ++gba.gridy;
            }
            GridBagConstraints gbm = new GridBagConstraints();
            gbm.insets = new Insets(5, 0, 0, 0);
            gbm.gridx = 0;
            gbm.gridy = 2;
            gbm.anchor = 11;
            this.mainPanel.add((Component)this.auxPanel, gbm);
        }
    }

    public ThermalControlPanel() {
        this.sender = null;
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int htr;
            int n;
            ThermalControlPanel.this.statusPanel.disablePanel();
            Integer[] integerArray = ThermalControlPanel.this.trimHeaters;
            int n2 = integerArray.length;
            for (n = 0; n < n2; ++n) {
                htr = integerArray[n];
                ThermalControlPanel.this.trimHeaterPanels[htr].disablePanel();
            }
            integerArray = ThermalControlPanel.this.auxHeaters;
            n2 = integerArray.length;
            for (n = 0; n < n2; ++n) {
                htr = integerArray[n];
                ThermalControlPanel.this.auxHeaterPanels[htr].disablePanel();
            }
            ThermalControlPanel.this.repaint();
        }
    }

    class UpdateThermalState
    implements Runnable {
        private final ThermalState rs;

        UpdateThermalState(ThermalState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            int htr;
            int n;
            ThermalControlPanel.this.statusPanel.updatePanel(this.rs.getTickMillis());
            if (this.rs.getTrimHeaters().length != ThermalControlPanel.this.trimHeaters.length) {
                ThermalControlPanel.this.updateTrimPanel(this.rs.getTrimHeaters());
            }
            Integer[] integerArray = ThermalControlPanel.this.trimHeaters;
            int n2 = integerArray.length;
            for (n = 0; n < n2; ++n) {
                htr = integerArray[n];
                ThermalControlPanel.this.trimHeaterPanels[htr].updatePanel(this.rs);
            }
            if (this.rs.getAuxHeaters().length != ThermalControlPanel.this.auxHeaters.length) {
                ThermalControlPanel.this.updateAuxPanel(this.rs.getAuxHeaters());
            }
            integerArray = ThermalControlPanel.this.auxHeaters;
            n2 = integerArray.length;
            for (n = 0; n < n2; ++n) {
                htr = integerArray[n];
                ThermalControlPanel.this.auxHeaterPanels[htr].updatePanel(this.rs);
            }
            ThermalControlPanel.this.repaint();
        }
    }
}

