/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.yaskawa;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;

public class A1000 {
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_ZERO_SPEED = 2;
    public static final int STATUS_REVERSE = 4;
    public static final int STATUS_FAULT_RESET = 8;
    public static final int STATUS_SPEED_AGREE = 16;
    public static final int STATUS_READY = 32;
    public static final int STATUS_ALARM = 64;
    public static final int STATUS_FAULT = 128;
    private static final short REG_COMMAND_MF_IN = 1;
    private static final short REG_FREQ_REFC = 2;
    private static final short REG_VOLTAGE_GAIN = 3;
    private static final short REG_TORQUE_REFC = 4;
    private static final short REG_TORQUE_COMP = 5;
    private static final short REG_PID_TARGET = 6;
    private static final short REG_ANAL_OUT_FM = 7;
    private static final short REG_ANAL_OUT_AM = 8;
    private static final short REG_DIGITAL_OUT = 9;
    private static final short REG_PULSE_OUT = 10;
    private static final short REG_CTRL_SLCTN = 15;
    private static final short REG_ANAL_MONITOR_1 = 27;
    private static final short REG_ANAL_MONITOR_2 = 28;
    private static final short REG_DIG_OUT_OPTN = 29;
    private static final short REG_DRIVE_STATUS_1 = 32;
    private static final short REG_FAULT_1 = 33;
    private static final short REG_LINK_STATUS = 34;
    private static final short REG_FREQ_REF_IN = 35;
    private static final short REG_OUTPUT_FRQ = 36;
    private static final short REG_VOLTAGE_REF = 37;
    private static final short REG_OUTPUT_CUR = 38;
    private static final short REG_OUTPUT_PWR = 39;
    private static final short REG_TORQUE_REF_IN = 40;
    private static final short REG_FAULT_2 = 41;
    private static final short REG_ALARM_1 = 42;
    private static final short REG_INPUT_TRM = 43;
    private static final short REG_DRIVE_STATUS_2 = 44;
    private static final short REG_OUTPUT_TRM = 45;
    private static final short REG_FREQ_REF_BIAS = 47;
    private static final short REG_DC_BUS_VOLTAGE = 49;
    private static final short REG_TORQUE_REF_IN2 = 50;
    private static final short REG_PRODUCT_CODE_1 = 52;
    private static final short REG_PRODUCT_CODE_2 = 53;
    private static final short REG_COMM_ERROR = 61;
    private static final short REG_OUT_FREQ_RPM = 62;
    private static final short REG_OUT_FREQ_PCT = 63;
    private static final short REG_FREQ_REFC_IN = 64;
    private static final short REG_OUTPUT_FREQ = 65;
    private static final short REG_OUTPUT_CURR = 66;
    private static final short REG_CTRL_METHOD_IN = 67;
    private static final short REG_MOTOR_SPEED = 68;
    private static final short REG_VOLTAGE_REFC = 69;
    private static final short REG_BUS_VOLTAGE = 70;
    private static final short REG_OUTPUT_POWER = 71;
    private static final short REG_INPUT_TERM = 73;
    private static final short REG_OUTPUT_TERM = 74;
    private static final short REG_DRIVE_STATUS = 75;
    private static final short REG_ALARM_CODE = 127;
    private static final short REG_ACC_OP_TIME_HI = 152;
    private static final short REG_ACC_OP_TIME_LO = 153;
    private static final short REG_FAN_OP_TIME_HI = 154;
    private static final short REG_FAN_OP_TIME_LO = 155;
    private static final short REG_RATED_CURRENT = 171;
    private static final short REG_MOTOR_SPD_RPM = 172;
    private static final short REG_MOTOR_SPD_PCT = 173;
    private static final short REG_FREQ_REF_S_RPM = 181;
    private static final short REG_FREQ_REF_S_PCT = 182;
    private static final short REG_FREQ_REF_RPM = 183;
    private static final short REG_FREQ_REF_PCT = 184;
    private static final short REG_OP_ERROR_CODE = 191;
    private static final short REG_FAULT_3 = 192;
    private static final short REG_FAULT_4 = 193;
    private static final short REG_FAULT_5 = 194;
    private static final short REG_FAULT_6 = 195;
    private static final short REG_FAULT_7 = 196;
    private static final short REG_FAULT_8 = 197;
    private static final short REG_FAULT_9 = 198;
    private static final short REG_ALARM_2 = 200;
    private static final short REG_ALARM_3 = 201;
    private static final short REG_ALARM_4 = 202;
    private static final short REG_ALARM_5 = 203;
    private static final short REG_ALARM_6 = 204;
    private static final short REG_ALARM_7 = 205;
    private static final short REG_CPF_CONTENTS_1 = 208;
    private static final short REG_CPF_CONTENTS_2 = 209;
    private static final short REG_CPF_CONTENTS_3 = 210;
    private static final short REG_LANGUAGE = 256;
    private static final short LANG_ENGLISH = 0;
    private static final short LANG_JAPANESE = 1;
    private static final short LANG_GERMAN = 2;
    private static final short LANG_FRENCH = 3;
    private static final short LANG_ITALIAN = 4;
    private static final short LANG_SPANISH = 5;
    private static final short LANG_PORTUGUESE = 6;
    private static final short LANG_CHINESE = 7;
    private static final short LANG_CZECH = 8;
    private static final short LANG_RUSSIAN = 9;
    private static final short LANG_TURKISH = 10;
    private static final short LANG_POLISH = 11;
    private static final short LANG_GREEK = 12;
    private static final short REG_ACCESS_LEVEL = 257;
    private static final short ACC_LEVEL_OPR_ONLY = 0;
    private static final short ACC_LEVEL_USR_PARM = 1;
    private static final short ACC_LEVEL_FULL = 2;
    private static final short REG_CTRL_MODE = 258;
    private static final short CTRL_MODE_VF = 0;
    private static final short CTRL_MODE_VF_PG = 1;
    private static final short CTRL_MODE_OLV = 2;
    private static final short CTRL_MODE_CLV = 3;
    private static final short CTRL_MODE_OLV_PM = 5;
    private static final short CTRL_MODE_AOLV_PM = 6;
    private static final short CTRL_MODE_CLV_PM = 7;
    private static final short REG_INIT_PARAMS = 259;
    private static final short INIT_NONE = 0;
    private static final short INIT_USER = 4368;
    private static final short INIT_2WIRE = 8736;
    private static final short INIT_3WIRE = 13104;
    private static final short INIT_OPE04_RESET = 21840;
    private static final short REG_PW_ENTRY = 260;
    private static final short REG_PW_SETTING = 261;
    private static final short REG_FREQ_REF_SRC = 384;
    private static final short FREQ_REF_OPERATOR = 0;
    private static final short FREQ_REF_ANALOG = 1;
    private static final short FREQ_REF_MODBUS = 2;
    private static final short FREQ_REF_OPTN_PCB = 3;
    private static final short FREQ_REF_PULSE = 4;
    private static final short REG_RUN_CMND_SRC = 385;
    private static final short RUN_CMND_OPERATOR = 0;
    private static final short RUN_CMND_DIGITAL = 1;
    private static final short RUN_CMND_MODBUS = 2;
    private static final short RUN_CMND_OPTN_PCB = 3;
    private static final short REG_STOP_METHOD = 386;
    private static final short STOP_METH_RAMP = 0;
    private static final short STOP_METH_COAST = 1;
    private static final short STOP_METH_INJECT = 2;
    private static final short STOP_METH_COAST_TM = 3;
    private static final short REG_REV_PERMIT = 387;
    private static final short REV_ENABLED = 0;
    private static final short REV_DISABLED = 1;
    private static final short REG_DIG_INPUT_CONF = 389;
    private static final short DIG_CONF_DISABLED = 0;
    private static final short DIG_CONF_ENABLED = 1;
    private static final short REG_RUN_CMND_CYCLE = 390;
    private static final short RUN_CYCLE_ENABLED = 0;
    private static final short RUN_CYCLE_DISABLED = 1;
    private static final short REG_RUN_CMND_PROG = 391;
    private static final short PROG_MODE_ONLY = 0;
    private static final short RUN_PROG_OKAY = 1;
    private static final short RUN_MODE_ONLY = 2;
    private static final short REG_INPUT_VOLTAGE = 768;
    private static final short REG_VF_SELECTION = 770;
    private static final short VF_50HZ = 0;
    private static final short VF_60HZ_SAT = 1;
    private static final short VF_50HZ_SAT = 2;
    private static final short VF_72HZ = 3;
    private static final short VF_50HZ_VT1 = 4;
    private static final short VF_50HZ_VT2 = 5;
    private static final short VF_60HZ_VT1 = 6;
    private static final short VF_60HZ_VT2 = 7;
    private static final short VF_50HZ_HST1 = 8;
    private static final short VF_50HZ_HST2 = 9;
    private static final short VF_60HZ_HST1 = 10;
    private static final short VF_60HZ_HST2 = 11;
    private static final short VF_90HZ = 12;
    private static final short VF_120HZ = 13;
    private static final short VF_180HZ = 14;
    private static final short VF_CUSTOM = 15;
    private static final short REG_NODE_ADDRESS = 1061;
    private static final short REG_BAUD_RATE = 1062;
    private static final short BAUD_RATE_1200 = 0;
    private static final short BAUD_RATE_2400 = 1;
    private static final short BAUD_RATE_4800 = 2;
    private static final short BAUD_RATE_9600 = 3;
    private static final short BAUD_RATE_19200 = 4;
    private static final short BAUD_RATE_38400 = 5;
    private static final short BAUD_RATE_57600 = 6;
    private static final short BAUD_RATE_76800 = 7;
    private static final short BAUD_RATE_115200 = 8;
    private static final short REG_COMM_PARITY = 1063;
    private static final short PARITY_NONE = 0;
    private static final short PARITY_EVEN = 1;
    private static final short PARITY_ODD = 2;
    private static final short REG_ERROR_ACTION = 1064;
    private static final short ERROR_RAMP_STOP = 0;
    private static final short ERROR_COAST_STOP = 1;
    private static final short ERROR_FAST_STOP = 2;
    private static final short ERROR_ALARM_ONLY = 3;
    private static final short REG_COMM_FAULT_DET = 1065;
    private static final short FAULT_DETC_OFF = 0;
    private static final short FAULT_DETC_ON = 1;
    private static final short REG_XMIT_WAIT_TIME = 1066;
    private static final short REG_RTS_CONTROL = 1067;
    private static final short RTS_ALWAYS_ON = 0;
    private static final short RTS_ONLY_ON_SEND = 1;
    private static final short REG_ERROR_DET_TIME = 1077;
    private static final short REG_VOLTAGE_UNITS = 1078;
    private static final short VOLT_UNITS_TENTHS = 0;
    private static final short VOLT_UNITS_ONES = 1;
    private static final short REG_ENTER_FUNC = 1084;
    private static final short ENTER_REQUIRED = 0;
    private static final short ENTER_NOT_REQUIRED = 1;
    private static final short REG_RUN_CMND_TYPE = 1085;
    private static final short RUN_CMND_FWD_REV = 0;
    private static final short RUN_CMND_OPER_DIRN = 1;
    private static final short REG_DRIVE_MODEL = 1288;
    private static final short MODEL_4A0002 = 146;
    private static final short MODEL_4A0004 = 147;
    private static final short MODEL_4A0005 = 148;
    private static final short MODEL_4A0007 = 149;
    private static final short MODEL_4A0009 = 150;
    private static final short REG_ENTER_EEPROM = 2304;
    private static final short REG_ENTER_RAM = 2320;
    private static final short REG_ = 0;
    private static final short z = 0;
    private static final Map<Language, Short> languageEnumMap = new HashMap<Language, Short>();
    private static final Map<Short, Language> languageValueMap = new HashMap<Short, Language>();
    private static final Map<AccessLevel, Short> accessLevelEnumMap;
    private static final Map<Short, AccessLevel> accessLevelValueMap;
    private static final Map<ControlMode, Short> controlModeEnumMap;
    private static final Map<Short, ControlMode> controlModeValueMap;
    private static final Map<FreqRefSrc, Short> freqRefSrcEnumMap;
    private static final Map<Short, FreqRefSrc> freqRefSrcValueMap;
    private static final Map<RunCmndSrc, Short> runCmndSrcEnumMap;
    private static final Map<Short, RunCmndSrc> runCmndSrcValueMap;
    private static final Map<StopMethod, Short> stopMethodEnumMap;
    private static final Map<Short, StopMethod> stopMethodValueMap;
    private static final Map<RunProg, Short> runProgEnumMap;
    private static final Map<Short, RunProg> runProgValueMap;
    private static final Map<BaudRate, Short> baudRateEnumMap;
    private static final Map<Short, BaudRate> baudRateValueMap;
    private static final Map<Parity, Short> parityEnumMap;
    private static final Map<Short, Parity> parityValueMap;
    private static final Map<ErrorAction, Short> errorActionEnumMap;
    private static final Map<Short, ErrorAction> errorActionValueMap;
    private static final Map<VoltageUnits, Short> voltageUnitsEnumMap;
    private static final Map<Short, VoltageUnits> voltageUnitsValueMap;
    private static final Map<VfSelection, Short> vfSelectionEnumMap;
    private static final Map<Short, VfSelection> vfSelectionValueMap;
    private static final Map<Short, String> modelNameMap;
    private static final Map<Short, Double> ratedCurrentMap;
    private static final int BAUD_RATE = 115200;
    private static final int DEVC_ADDR = 31;
    private static final short ZERO = 0;
    private static final short ONE = 1;
    private static final short TWO = 2;
    private static final int EXCP_BIT_COUNT = 3;
    private static final int EXCP_SET_DATA = 33;
    private static final int EXCP_WRITE_MODE = 34;
    private static final int EXCP_BUS_UNDERVOLT = 35;
    private static final int EXCP_WRITE_PARAM = 36;
    private static final int EXCP_WRITE_EEPROM = 37;
    private static final Map<Integer, String> excpMap;
    private static final double VOLT_UNITS = 0.1;
    private static final double FREQ_UNITS = 0.01;
    private final Modbus mbus;
    private short devcAddr;
    private double ratedCurrent;
    private VoltageUnits voltageUnits = VoltageUnits.TENTHS;
    private boolean runCmndFwdRev = true;

    public A1000() {
        this.mbus = new Modbus();
        this.mbus.setOptions(Ascii.Option.NO_NET);
        this.mbus.setDefaultParm(115200);
        this.mbus.setAddressMode(true);
        this.mbus.setExceptionMap(excpMap);
    }

    public void open(String device, int address, int baudRate, int dataChar) throws DriverException {
        this.mbus.open(Modbus.ConnType.SERIAL, device, baudRate, dataChar);
        this.devcAddr = address != 0 ? (int)address : 31;
        try {
            this.ratedCurrent = this.getRatedCurrent();
        }
        catch (DriverException e) {
            this.mbus.closeSilent();
            throw e;
        }
    }

    public void open(String device, int address, int baudRate) throws DriverException {
        this.open(device, address, baudRate, 0);
    }

    public void open(String device, int address) throws DriverException {
        this.open(device, address, 115200);
    }

    public void open(String device) throws DriverException {
        this.open(device, 31);
    }

    public void close() throws DriverException {
        this.mbus.close();
    }

    public short[] readRegisters(short addr, short count) throws DriverException {
        return this.mbus.readRegisters(this.devcAddr, addr, count);
    }

    public int readRegister(short addr) throws DriverException {
        return this.mbus.readRegisters(this.devcAddr, addr, (short)1)[0];
    }

    public void writeRegister(short addr, short value) throws DriverException {
        this.mbus.writeRegisters(this.devcAddr, addr, new short[]{value});
    }

    public void writeRegisters(short addr, short[] value) throws DriverException {
        this.mbus.writeRegisters(this.devcAddr, addr, value);
    }

    public void enterParameters() throws DriverException {
        this.writeRegister((short)2320, (short)0);
    }

    public void saveParameters() throws DriverException {
        this.writeRegister((short)2304, (short)0);
    }

    public void setNodeAddress(int address) throws DriverException {
        this.writeRegister((short)1061, (short)address);
    }

    public int getNodeAddress() throws DriverException {
        return this.readRegister((short)1061);
    }

    public void setBaudRate(BaudRate rate) throws DriverException {
        this.writeRegister((short)1062, baudRateEnumMap.get((Object)rate));
    }

    public BaudRate getBaudRate() throws DriverException {
        return baudRateValueMap.get((short)this.readRegister((short)1062));
    }

    public void setParity(Parity parity) throws DriverException {
        this.writeRegister((short)1063, parityEnumMap.get((Object)parity));
    }

    public Parity getParity() throws DriverException {
        return parityValueMap.get((short)this.readRegister((short)1063));
    }

    public String getModelName() throws DriverException {
        return modelNameMap.get((short)this.readRegister((short)1288));
    }

    public double getRatedCurrent() throws DriverException {
        return ratedCurrentMap.get((short)this.readRegister((short)1288));
    }

    public void setLocalControl() throws DriverException {
        this.setRunCmndSrc(RunCmndSrc.DIGITAL);
        this.setFreqRefSrc(FreqRefSrc.ANALOG);
        this.enterParameters();
    }

    public void setRemoteControl() throws DriverException {
        this.setRunCmndSrc(RunCmndSrc.MODBUS);
        this.setFreqRefSrc(FreqRefSrc.MODBUS);
        this.enterParameters();
    }

    public void setAccessLevel(AccessLevel level) throws DriverException {
        this.writeRegister((short)257, accessLevelEnumMap.get((Object)level));
    }

    public AccessLevel getAccessLevel() throws DriverException {
        return accessLevelValueMap.get((short)this.readRegister((short)257));
    }

    public void setControlMode(ControlMode mode) throws DriverException {
        this.writeRegister((short)258, controlModeEnumMap.get((Object)mode));
    }

    public ControlMode getControlMode() throws DriverException {
        return controlModeValueMap.get((short)this.readRegister((short)258));
    }

    public void setFreqRefSrc(FreqRefSrc src) throws DriverException {
        this.writeRegister((short)384, freqRefSrcEnumMap.get((Object)src));
    }

    public FreqRefSrc getFreqRefSrc() throws DriverException {
        return freqRefSrcValueMap.get((short)this.readRegister((short)384));
    }

    public void setRunCmndSrc(RunCmndSrc src) throws DriverException {
        this.writeRegister((short)385, runCmndSrcEnumMap.get((Object)src));
    }

    public RunCmndSrc getRunCmndSrc() throws DriverException {
        return runCmndSrcValueMap.get((short)this.readRegister((short)385));
    }

    public void setStopMethod(StopMethod method) throws DriverException {
        this.writeRegister((short)386, stopMethodEnumMap.get((Object)method));
    }

    public StopMethod getStopMethod() throws DriverException {
        return stopMethodValueMap.get((short)this.readRegister((short)386));
    }

    public void setRunProg(RunProg runProg) throws DriverException {
        this.writeRegister((short)391, runProgEnumMap.get((Object)runProg));
    }

    public RunProg getRunProg() throws DriverException {
        return runProgValueMap.get((short)this.readRegister((short)391));
    }

    public void setErrorAction(ErrorAction action) throws DriverException {
        this.writeRegister((short)1064, errorActionEnumMap.get((Object)action));
    }

    public ErrorAction getErrorAction() throws DriverException {
        return errorActionValueMap.get((short)this.readRegister((short)1064));
    }

    public void setReversePermitted(boolean permit) throws DriverException {
        this.writeRegister((short)387, permit ? (short)0 : 1);
    }

    public boolean isReversePermitted() throws DriverException {
        return this.readRegister((short)387) == 0;
    }

    public void setFaultDetected(boolean detect) throws DriverException {
        this.writeRegister((short)1065, detect ? (short)1 : 0);
    }

    public boolean isFaultDetected() throws DriverException {
        return this.readRegister((short)1065) == 1;
    }

    public void setEnterRequired(boolean require) throws DriverException {
        this.writeRegister((short)1084, require ? (short)0 : 1);
    }

    public boolean isEnterRequired() throws DriverException {
        return this.readRegister((short)1084) == 0;
    }

    public void setRunCmndFwdRev(boolean fwdRev) throws DriverException {
        this.writeRegister((short)1085, fwdRev ? (short)0 : 1);
        this.runCmndFwdRev = fwdRev;
    }

    public boolean isRunCmndFwdRev() throws DriverException {
        return this.readRegister((short)1085) == 0;
    }

    public void setVoltageUnits(VoltageUnits units) throws DriverException {
        this.writeRegister((short)1078, voltageUnitsEnumMap.get((Object)units));
        this.voltageUnits = units;
    }

    public VoltageUnits getVoltageUnits() throws DriverException {
        return voltageUnitsValueMap.get((short)this.readRegister((short)1078));
    }

    public void setInputVoltage(double voltage) throws DriverException {
        this.writeRegister((short)768, (short)voltage);
    }

    public double getInputVoltage() throws DriverException {
        return this.readRegister((short)768);
    }

    public void setVfSelection(VfSelection level) throws DriverException {
        this.writeRegister((short)770, vfSelectionEnumMap.get((Object)level));
    }

    public VfSelection getVfSelection() throws DriverException {
        return vfSelectionValueMap.get((short)this.readRegister((short)770));
    }

    public void setFrequency(double freq) throws DriverException {
        this.writeRegister((short)2, (short)(freq / 0.01));
    }

    public double getFrequency() throws DriverException {
        return 0.01 * (double)this.readRegister((short)2);
    }

    public double getFrequencyApp() throws DriverException {
        return 0.01 * (double)this.readRegister((short)64);
    }

    public double readFrequency() throws DriverException {
        return 0.01 * (double)this.readRegister((short)65);
    }

    public double readVoltage() throws DriverException {
        return 0.1 * (double)this.readRegister((short)69);
    }

    public double readCurrent() throws DriverException {
        return this.ratedCurrent / 8192.0 * (double)this.readRegister((short)66);
    }

    public double readBusVoltage() throws DriverException {
        return this.readRegister((short)70);
    }

    public int getDriveStatus() throws DriverException {
        return this.readRegister((short)75) & 0xFF;
    }

    public void runForward() throws DriverException {
        this.writeRegister((short)1, (short)(this.runCmndFwdRev ? 1 : 3));
    }

    public void runReverse() throws DriverException {
        this.writeRegister((short)1, (short)(this.runCmndFwdRev ? 2 : 1));
    }

    public void stop() throws DriverException {
        this.writeRegister((short)1, (short)0);
    }

    static {
        languageEnumMap.put(Language.ENGLISH, (short)0);
        for (Map.Entry<Language, Short> entry : languageEnumMap.entrySet()) {
            languageValueMap.put(entry.getValue(), entry.getKey());
        }
        accessLevelEnumMap = new HashMap<AccessLevel, Short>();
        accessLevelValueMap = new HashMap<Short, AccessLevel>();
        accessLevelEnumMap.put(AccessLevel.OPR_ONLY, (short)0);
        accessLevelEnumMap.put(AccessLevel.USR_PARM, (short)1);
        accessLevelEnumMap.put(AccessLevel.FULL, (short)2);
        for (Map.Entry<Enum, Short> entry : accessLevelEnumMap.entrySet()) {
            accessLevelValueMap.put(entry.getValue(), (AccessLevel)entry.getKey());
        }
        controlModeEnumMap = new HashMap<ControlMode, Short>();
        controlModeValueMap = new HashMap<Short, ControlMode>();
        controlModeEnumMap.put(ControlMode.VF, (short)0);
        controlModeEnumMap.put(ControlMode.VF_PG, (short)1);
        controlModeEnumMap.put(ControlMode.OLV, (short)2);
        controlModeEnumMap.put(ControlMode.CLV, (short)3);
        controlModeEnumMap.put(ControlMode.CLV_PM, (short)7);
        controlModeEnumMap.put(ControlMode.OLV_PM, (short)5);
        controlModeEnumMap.put(ControlMode.AOLV_PM, (short)6);
        for (Map.Entry<Enum, Short> entry : controlModeEnumMap.entrySet()) {
            controlModeValueMap.put(entry.getValue(), (ControlMode)entry.getKey());
        }
        freqRefSrcEnumMap = new HashMap<FreqRefSrc, Short>();
        freqRefSrcValueMap = new HashMap<Short, FreqRefSrc>();
        freqRefSrcEnumMap.put(FreqRefSrc.OPERATOR, (short)0);
        freqRefSrcEnumMap.put(FreqRefSrc.ANALOG, (short)1);
        freqRefSrcEnumMap.put(FreqRefSrc.MODBUS, (short)2);
        freqRefSrcEnumMap.put(FreqRefSrc.OPTN_PCB, (short)3);
        freqRefSrcEnumMap.put(FreqRefSrc.PULSE, (short)4);
        for (Map.Entry<Enum, Short> entry : freqRefSrcEnumMap.entrySet()) {
            freqRefSrcValueMap.put(entry.getValue(), (FreqRefSrc)entry.getKey());
        }
        runCmndSrcEnumMap = new HashMap<RunCmndSrc, Short>();
        runCmndSrcValueMap = new HashMap<Short, RunCmndSrc>();
        runCmndSrcEnumMap.put(RunCmndSrc.OPERATOR, (short)0);
        runCmndSrcEnumMap.put(RunCmndSrc.DIGITAL, (short)1);
        runCmndSrcEnumMap.put(RunCmndSrc.MODBUS, (short)2);
        runCmndSrcEnumMap.put(RunCmndSrc.OPTN_PCB, (short)3);
        for (Map.Entry<Enum, Short> entry : runCmndSrcEnumMap.entrySet()) {
            runCmndSrcValueMap.put(entry.getValue(), (RunCmndSrc)entry.getKey());
        }
        stopMethodEnumMap = new HashMap<StopMethod, Short>();
        stopMethodValueMap = new HashMap<Short, StopMethod>();
        stopMethodEnumMap.put(StopMethod.COAST, (short)1);
        stopMethodEnumMap.put(StopMethod.COAST_TMR, (short)3);
        stopMethodEnumMap.put(StopMethod.INJECT, (short)2);
        stopMethodEnumMap.put(StopMethod.RAMP, (short)0);
        for (Map.Entry<Enum, Short> entry : stopMethodEnumMap.entrySet()) {
            stopMethodValueMap.put(entry.getValue(), (StopMethod)entry.getKey());
        }
        runProgEnumMap = new HashMap<RunProg, Short>();
        runProgValueMap = new HashMap<Short, RunProg>();
        runProgEnumMap.put(RunProg.PROG_ONLY, (short)0);
        runProgEnumMap.put(RunProg.RUN_PROG, (short)1);
        runProgEnumMap.put(RunProg.RUN_ONLY, (short)2);
        for (Map.Entry<Enum, Short> entry : runProgEnumMap.entrySet()) {
            runProgValueMap.put(entry.getValue(), (RunProg)entry.getKey());
        }
        baudRateEnumMap = new HashMap<BaudRate, Short>();
        baudRateValueMap = new HashMap<Short, BaudRate>();
        baudRateEnumMap.put(BaudRate.B1200, (short)0);
        baudRateEnumMap.put(BaudRate.B2400, (short)1);
        baudRateEnumMap.put(BaudRate.B4800, (short)2);
        baudRateEnumMap.put(BaudRate.B9600, (short)3);
        baudRateEnumMap.put(BaudRate.B19200, (short)4);
        baudRateEnumMap.put(BaudRate.B38400, (short)5);
        baudRateEnumMap.put(BaudRate.B57600, (short)6);
        baudRateEnumMap.put(BaudRate.B76800, (short)7);
        baudRateEnumMap.put(BaudRate.B115200, (short)8);
        for (Map.Entry<Enum, Short> entry : baudRateEnumMap.entrySet()) {
            baudRateValueMap.put(entry.getValue(), (BaudRate)entry.getKey());
        }
        parityEnumMap = new HashMap<Parity, Short>();
        parityValueMap = new HashMap<Short, Parity>();
        parityEnumMap.put(Parity.EVEN, (short)1);
        parityEnumMap.put(Parity.ODD, (short)2);
        parityEnumMap.put(Parity.NONE, (short)0);
        for (Map.Entry<Enum, Short> entry : parityEnumMap.entrySet()) {
            parityValueMap.put(entry.getValue(), (Parity)entry.getKey());
        }
        errorActionEnumMap = new HashMap<ErrorAction, Short>();
        errorActionValueMap = new HashMap<Short, ErrorAction>();
        errorActionEnumMap.put(ErrorAction.RAMP_STOP, (short)0);
        errorActionEnumMap.put(ErrorAction.COAST_STOP, (short)1);
        errorActionEnumMap.put(ErrorAction.FAST_STOP, (short)2);
        errorActionEnumMap.put(ErrorAction.ALARM_ONLY, (short)3);
        for (Map.Entry<Enum, Short> entry : errorActionEnumMap.entrySet()) {
            errorActionValueMap.put(entry.getValue(), (ErrorAction)entry.getKey());
        }
        voltageUnitsEnumMap = new HashMap<VoltageUnits, Short>();
        voltageUnitsValueMap = new HashMap<Short, VoltageUnits>();
        voltageUnitsEnumMap.put(VoltageUnits.ONES, (short)1);
        voltageUnitsEnumMap.put(VoltageUnits.TENTHS, (short)0);
        for (Map.Entry<Enum, Short> entry : voltageUnitsEnumMap.entrySet()) {
            voltageUnitsValueMap.put(entry.getValue(), (VoltageUnits)entry.getKey());
        }
        vfSelectionEnumMap = new HashMap<VfSelection, Short>();
        vfSelectionValueMap = new HashMap<Short, VfSelection>();
        vfSelectionEnumMap.put(VfSelection.HZ50, (short)0);
        vfSelectionEnumMap.put(VfSelection.HZ60_SAT, (short)1);
        vfSelectionEnumMap.put(VfSelection.HZ50_SAT, (short)2);
        vfSelectionEnumMap.put(VfSelection.HZ72, (short)3);
        vfSelectionEnumMap.put(VfSelection.HZ50_VT1, (short)4);
        vfSelectionEnumMap.put(VfSelection.HZ50_VT2, (short)5);
        vfSelectionEnumMap.put(VfSelection.HZ60_VT1, (short)6);
        vfSelectionEnumMap.put(VfSelection.HZ60_VT2, (short)7);
        vfSelectionEnumMap.put(VfSelection.HZ50_HST1, (short)8);
        vfSelectionEnumMap.put(VfSelection.HZ50_HST2, (short)9);
        vfSelectionEnumMap.put(VfSelection.HZ60_HST1, (short)10);
        vfSelectionEnumMap.put(VfSelection.HZ60_HST2, (short)11);
        vfSelectionEnumMap.put(VfSelection.HZ90, (short)12);
        vfSelectionEnumMap.put(VfSelection.HZ120, (short)13);
        vfSelectionEnumMap.put(VfSelection.HZ180, (short)14);
        vfSelectionEnumMap.put(VfSelection.CUSTOM, (short)15);
        for (Map.Entry<Enum, Short> entry : vfSelectionEnumMap.entrySet()) {
            vfSelectionValueMap.put(entry.getValue(), (VfSelection)entry.getKey());
        }
        modelNameMap = new HashMap<Short, String>();
        modelNameMap.put((short)146, "4A0002");
        modelNameMap.put((short)147, "4A0004");
        modelNameMap.put((short)148, "4A0005");
        modelNameMap.put((short)149, "4A0007");
        modelNameMap.put((short)150, "4A0009");
        ratedCurrentMap = new HashMap<Short, Double>();
        ratedCurrentMap.put((short)146, 2.1);
        ratedCurrentMap.put((short)147, 4.1);
        ratedCurrentMap.put((short)148, 5.4);
        ratedCurrentMap.put((short)149, 6.9);
        ratedCurrentMap.put((short)150, 8.8);
        excpMap = new HashMap<Integer, String>();
        excpMap.put(3, "bit count error");
        excpMap.put(33, "illegal data value");
        excpMap.put(34, "illegal write operation");
        excpMap.put(35, "illegal write while in undervoltage");
        excpMap.put(36, "illegal write while processing parameters");
        excpMap.put(37, "illegal write to EEPROM");
    }

    public static enum VfSelection {
        HZ50,
        HZ60_SAT,
        HZ50_SAT,
        HZ72,
        HZ50_VT1,
        HZ50_VT2,
        HZ60_VT1,
        HZ60_VT2,
        HZ50_HST1,
        HZ50_HST2,
        HZ60_HST1,
        HZ60_HST2,
        HZ90,
        HZ120,
        HZ180,
        CUSTOM;

    }

    public static enum VoltageUnits {
        ONES,
        TENTHS;

    }

    public static enum ErrorAction {
        RAMP_STOP,
        COAST_STOP,
        FAST_STOP,
        ALARM_ONLY;

    }

    public static enum Parity {
        EVEN,
        ODD,
        NONE;

    }

    public static enum BaudRate {
        B1200,
        B2400,
        B4800,
        B9600,
        B19200,
        B38400,
        B57600,
        B76800,
        B115200;

    }

    public static enum RunProg {
        PROG_ONLY,
        RUN_PROG,
        RUN_ONLY;

    }

    public static enum StopMethod {
        COAST,
        COAST_TMR,
        INJECT,
        RAMP;

    }

    public static enum RunCmndSrc {
        OPERATOR,
        DIGITAL,
        MODBUS,
        OPTN_PCB;

    }

    public static enum FreqRefSrc {
        OPERATOR,
        ANALOG,
        MODBUS,
        OPTN_PCB,
        PULSE;

    }

    public static enum ControlMode {
        VF,
        VF_PG,
        OLV,
        CLV,
        CLV_PM,
        OLV_PM,
        AOLV_PM;

    }

    public static enum AccessLevel {
        OPR_ONLY,
        USR_PARM,
        FULL;

    }

    public static enum Language {
        ENGLISH;

    }
}

