/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.AuxHeaterPanel;
import org.lsst.ccs.subsystem.refrig.ui.ColdSectionPanel;
import org.lsst.ccs.subsystem.refrig.ui.TrimHeaterPanel;

public class ThermalControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private ColdSectionPanel coldPanel;
    private final TrimHeaterPanel[] trimHeaterPanels = new TrimHeaterPanel[2];
    private final AuxHeaterPanel[] auxHeaterPanels = new AuxHeaterPanel[3];
    private JPanel trimPanel;
    private JPanel auxPanel;
    private final JPanel mainPanel = new JPanel();
    private static final long serialVersionUID = 1L;

    public ThermalControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getSystemState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((ThermalState)reply);
    }

    public void updatePanel(ThermalState rs) {
        SwingUtilities.invokeLater(new UpdateThermalState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.coldPanel = new ColdSectionPanel(this.sender);
        for (int htr = 0; htr < 2; ++htr) {
            this.trimHeaterPanels[htr] = new TrimHeaterPanel(htr, this.sender);
        }
        this.trimPanel = UiUtilities.newBorderedPanel((String)"Trim heater control");
        GridBagConstraints gbt = new GridBagConstraints();
        gbt.insets = new Insets(5, 0, 5, 0);
        gbt.gridx = 0;
        gbt.gridy = 0;
        gbt.anchor = 11;
        this.trimPanel.add((Component)this.coldPanel, gbt);
        ++gbt.gridy;
        gbt.insets.top = 0;
        for (TrimHeaterPanel pnl : this.trimHeaterPanels) {
            gbt.insets.bottom = gbt.gridy == 2 ? 5 : 0;
            this.trimPanel.add((Component)pnl, gbt);
            ++gbt.gridy;
        }
        for (int htr = 0; htr < 3; ++htr) {
            this.auxHeaterPanels[htr] = new AuxHeaterPanel(htr, this.sender);
        }
        this.auxPanel = UiUtilities.newBorderedPanel((String)"Auxiliary heater control");
        GridBagConstraints gba = new GridBagConstraints();
        gba.insets = new Insets(5, 0, 0, 0);
        gba.gridx = 0;
        gba.gridy = 0;
        gba.anchor = 11;
        for (AuxHeaterPanel pnl : this.auxHeaterPanels) {
            gba.insets.bottom = gba.gridy == 2 ? 5 : 0;
            this.auxPanel.add((Component)pnl, gba);
            ++gba.gridy;
            gba.insets.top = 0;
        }
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(5, 0, 0, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 11;
        this.mainPanel.add((Component)this.statusPanel, gbm);
        ++gbm.gridy;
        gbm.insets.bottom = 5;
        this.mainPanel.add((Component)this.trimPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.auxPanel, gbm);
        this.add(this.mainPanel);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.disablePanel();
            ThermalControlPanel.this.coldPanel.disablePanel();
            for (TrimHeaterPanel trimHeaterPanel : ThermalControlPanel.this.trimHeaterPanels) {
                trimHeaterPanel.disablePanel();
            }
            for (JPanel jPanel : ThermalControlPanel.this.auxHeaterPanels) {
                ((AuxHeaterPanel)jPanel).disablePanel();
            }
            ThermalControlPanel.this.repaint();
        }
    }

    class UpdateThermalState
    implements Runnable {
        private final ThermalState rs;

        UpdateThermalState(ThermalState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.updatePanel(this.rs.getTickMillis());
            ThermalControlPanel.this.coldPanel.updatePanel(this.rs);
            for (TrimHeaterPanel trimHeaterPanel : ThermalControlPanel.this.trimHeaterPanels) {
                trimHeaterPanel.updatePanel(this.rs);
            }
            for (JPanel jPanel : ThermalControlPanel.this.auxHeaterPanels) {
                ((AuxHeaterPanel)jPanel).updatePanel(this.rs);
            }
            ThermalControlPanel.this.repaint();
        }
    }
}

