/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

public class ColdSectionPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final String[] sectionNames = new String[2];
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private final JCheckBox[] coldCbx = new JCheckBox[2];
    private static final long serialVersionUID = 1L;

    public ColdSectionPanel(CommandSender sender) {
        this.sender = sender;
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
    }

    public void updatePanel(ThermalState rs) {
        for (int sect = 0; sect < 2; ++sect) {
            this.coldCbx[sect].setEnabled(true);
            this.coldCbx[sect].setSelected(rs.isColdSectionEnabled(sect));
        }
    }

    public void disablePanel() {
        for (JCheckBox cbx : this.coldCbx) {
            cbx.setEnabled(false);
        }
    }

    private void initComponents() {
        for (int sect = 0; sect < 2; ++sect) {
            this.coldCbx[sect] = this.uiUtils.newCheckBox("Enable " + sectionNames[sect] + " Cold Htrs", String.valueOf(sect));
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        for (JCheckBox cbx : this.coldCbx) {
            this.add((Component)cbx, gbc);
            ++gbc.gridx;
            gbc.insets.left = 20;
        }
    }

    public void handleCheckBox(String name, boolean isSelected) {
        this.sender.sendCommand(null, "enableColdSection", new Object[]{Integer.valueOf(name), isSelected});
    }

    static {
        ColdSectionPanel.sectionNames[0] = "-Y";
        ColdSectionPanel.sectionNames[1] = "+Y";
    }
}

