/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.CmprSetState;
import org.lsst.ccs.subsystem.refrig.constants.HexCmprState;
import org.lsst.ccs.subsystem.refrig.constants.HexValves;
import org.lsst.ccs.subsystem.refrig.constants.ValvePosnState;
import org.lsst.ccs.subsystem.refrig.constants.ValveSetState;
import org.lsst.ccs.subsystem.refrig.data.HexValveState;

public class HexValveControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private static final Map<ValveSetState, Color> setStateColors = new HashMap<ValveSetState, Color>();
    private static final Map<ValvePosnState, Color> posnStateColors;
    private static final Map<HexCmprState, Color> hexStateColors;
    private static final String BLOCK = "\u2588";
    private static final int horzInset;
    private static final int vertInset;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private JLabel sysStatus;
    private final JLabel[] valveSetStatus = new JLabel[18];
    private final JLabel[] valvePosnStatus = new JLabel[18];
    private final JRadioButton[] cmprButton = new JRadioButton[6];
    private final ButtonGroup[] hexBG = new ButtonGroup[2];
    private final JLabel[] hexStatus = new JLabel[2];
    private static final long serialVersionUID = 1L;

    public HexValveControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getSystemState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((HexValveState)reply);
    }

    public void updatePanel(HexValveState vs) {
        SwingUtilities.invokeLater(new UpdateValveState(vs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.sysStatus = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxLabelWidth((String[])new String[]{"STOPPED", "RUNNING"}, (String)""));
        for (int hNum = 0; hNum < 2; ++hNum) {
            this.hexBG[hNum] = new ButtonGroup();
            for (int cNum : HexValves.hxCmprSets[hNum]) {
                this.cmprButton[cNum] = this.uiUtils.newRadioButton(HexValves.cmprNumberMap.get(cNum), hNum + "" + cNum);
                this.hexBG[hNum].add(this.cmprButton[cNum]);
            }
            this.hexStatus[hNum] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(HexCmprState.class));
        }
        for (int vNum = 0; vNum < 18; ++vNum) {
            this.valveSetStatus[vNum] = UiUtilities.newLabel((String)BLOCK, (int)0);
            this.valvePosnStatus[vNum] = UiUtilities.newLabel((String)BLOCK, (int)0);
        }
        JPanel mainPanel = UiUtilities.newBorderedPanel(null);
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(vertInset, 2 * horzInset, vertInset, 2 * horzInset);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 11;
        gbm.gridwidth = 4;
        mainPanel.add((Component)this.newSysPanel(), gbm);
        gbm.anchor = 18;
        gbm.gridwidth = 1;
        ++gbm.gridy;
        gbm.insets.bottom = 2 * vertInset;
        for (int hNum = 0; hNum < 2; ++hNum) {
            mainPanel.add((Component)this.newHexPanel(hNum), gbm);
            ++gbm.gridx;
            for (int cNum : HexValves.hxCmprSets[hNum]) {
                mainPanel.add((Component)this.newCmprPanel(cNum), gbm);
                ++gbm.gridx;
            }
            ++gbm.gridy;
            gbm.gridx = 0;
        }
        this.add(mainPanel);
    }

    private JPanel newSysPanel() {
        JPanel panel = new JPanel();
        panel.add(UiUtilities.newLabel((String)"System State:  ", (int)0));
        panel.add(this.sysStatus);
        return panel;
    }

    private JPanel newHexPanel(int hNum) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, vertInset, 0);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)UiUtilities.newLabel((String)(HexValves.hxNumberMap.get(hNum) + ":"), (int)0), gbc);
        ++gbc.gridy;
        panel.add((Component)this.hexStatus[hNum], gbc);
        return panel;
    }

    private JPanel newCmprPanel(int cNum) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, vertInset, 0);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 6;
        panel.add((Component)this.cmprButton[cNum], gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel.add((Component)UiUtilities.newLabel((String)"Liq", (int)0), gbc);
        gbc.gridx += 2;
        panel.add((Component)UiUtilities.newLabel((String)"Vap", (int)0), gbc);
        gbc.gridx += 2;
        panel.add((Component)UiUtilities.newLabel((String)"Rtn", (int)0), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        for (int vNum : HexValves.cmprValveSets[cNum]) {
            panel.add((Component)this.valveSetStatus[vNum], gbc);
            ++gbc.gridx;
            gbc.insets.left = 0;
            panel.add((Component)this.valvePosnStatus[vNum], gbc);
            ++gbc.gridx;
            gbc.insets.left = horzInset;
        }
        return panel;
    }

    public void handleRadioButton(String name) {
        int hNum = Integer.valueOf(name.substring(0, 1));
        int cNum = Integer.valueOf(name.substring(1, 2));
        this.sender.sendCommand(null, "connectHex", new Object[]{HexValves.hxNumberMap.get(hNum), HexValves.cmprNumberMap.get(cNum)});
    }

    static {
        setStateColors.put(ValveSetState.OPEN, UiConstants.GREEN);
        setStateColors.put(ValveSetState.SHUT, Color.BLACK);
        setStateColors.put(ValveSetState.OFFLINE, UiConstants.BLUE);
        posnStateColors = new HashMap<ValvePosnState, Color>();
        posnStateColors.put(ValvePosnState.OPEN, UiConstants.GREEN);
        posnStateColors.put(ValvePosnState.SHUT, Color.BLACK);
        posnStateColors.put(ValvePosnState.BOTH, UiConstants.RED);
        posnStateColors.put(ValvePosnState.NONE, UiConstants.YELLOW);
        posnStateColors.put(ValvePosnState.OFFLINE, UiConstants.BLUE);
        hexStateColors = new HashMap<HexCmprState, Color>();
        hexStateColors.put(HexCmprState.NORMAL, UiConstants.GREEN);
        hexStateColors.put(HexCmprState.SETERROR, UiConstants.RED);
        hexStateColors.put(HexCmprState.POSNERROR, UiConstants.PURPLE);
        hexStateColors.put(HexCmprState.OFFLINE, UiConstants.BLUE);
        horzInset = UiUtilities.getLabelSize((String)"M").width / 2;
        vertInset = UiUtilities.getLabelSize((String)"M").height / 4;
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            HexValveControlPanel.this.sysStatus.setText("STOPPED");
            HexValveControlPanel.this.sysStatus.setForeground(UiConstants.RED);
            for (int hNum = 0; hNum < 2; ++hNum) {
                HexValveControlPanel.this.hexStatus[hNum].setEnabled(false);
            }
            for (int cNum = 0; cNum < 6; ++cNum) {
                HexValveControlPanel.this.cmprButton[cNum].setEnabled(false);
            }
            for (int vNum = 0; vNum < 18; ++vNum) {
                HexValveControlPanel.this.valveSetStatus[vNum].setEnabled(false);
                HexValveControlPanel.this.valvePosnStatus[vNum].setEnabled(false);
            }
            HexValveControlPanel.this.repaint();
        }
    }

    class UpdateValveState
    implements Runnable {
        private final HexValveState vs;

        UpdateValveState(HexValveState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            HexValveControlPanel.this.sysStatus.setText("RUNNING");
            HexValveControlPanel.this.sysStatus.setForeground(UiConstants.GREEN);
            for (int hNum = 0; hNum < 2; ++hNum) {
                HexValveControlPanel.this.hexBG[hNum].clearSelection();
                for (int cNum : HexValves.hxCmprSets[hNum]) {
                    if (this.vs.getCmprState(cNum) == CmprSetState.OPEN) {
                        HexValveControlPanel.this.cmprButton[cNum].setSelected(true);
                    }
                    HexValveControlPanel.this.cmprButton[cNum].setEnabled(true);
                }
                HexCmprState hState = this.vs.getHexState(hNum);
                HexValveControlPanel.this.hexStatus[hNum].setText(hState.toString());
                HexValveControlPanel.this.hexStatus[hNum].setForeground((Color)hexStateColors.get((Object)hState));
                HexValveControlPanel.this.hexStatus[hNum].setEnabled(true);
            }
            for (int vNum = 0; vNum < 18; ++vNum) {
                HexValveControlPanel.this.valveSetStatus[vNum].setForeground((Color)setStateColors.get((Object)this.vs.getSetState(vNum)));
                HexValveControlPanel.this.valveSetStatus[vNum].setEnabled(true);
                HexValveControlPanel.this.valvePosnStatus[vNum].setForeground((Color)posnStateColors.get((Object)this.vs.getPosnState(vNum)));
                HexValveControlPanel.this.valvePosnStatus[vNum].setEnabled(true);
            }
            HexValveControlPanel.this.repaint();
        }
    }
}

