/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import javax.swing.JTextField;

public class TextFieldX {
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;
    private final JTextField textField;
    private final int type;
    private boolean editing;
    private Object currValue;

    public TextFieldX(JTextField tf, int typ) {
        this.textField = tf;
        this.type = typ;
        this.editing = false;
        this.currValue = null;
    }

    public void update(Object value, boolean enable) {
        this.currValue = value;
        if (enable) {
            this.textField.setEnabled(true);
        }
        if (!this.editing) {
            this.textField.setText(String.valueOf(this.currValue));
        }
    }

    public void keyTyped(char key) {
        if (!(this.editing || key < ' ' && key != '\b')) {
            this.setEditing(true);
        }
    }

    public void focusLost() {
        if (this.editing) {
            this.setEditing(false);
            this.textField.setText(String.valueOf(this.currValue));
        }
    }

    public Object action() {
        if (this.editing) {
            this.setEditing(false);
            try {
                Object value = this.type == 2 ? Double.valueOf(this.textField.getText()) : (this.type == 1 ? Integer.valueOf(this.textField.getText()) : this.textField.getText());
                this.textField.setEnabled(false);
                return value;
            }
            catch (NumberFormatException nfe) {
                this.textField.setText(String.valueOf(this.currValue));
                return null;
            }
        }
        return null;
    }

    public void disable() {
        this.setEditing(false);
        this.textField.setEnabled(false);
    }

    private void setEditing(boolean state) {
        this.editing = state;
        this.textField.setForeground(this.editing ? Color.RED : Color.BLACK);
    }
}

