/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.ColdCompState;
import org.lsst.ccs.subsystem.refrig.data.CryoCompState;

public class CompState
implements Serializable {
    public static final int TYPE_COLD = 0;
    public static final int TYPE_CRYO = 1;
    public static final int SW_ENABLE = 0;
    public static final int SW_HEATER = 1;
    public static final int SW_LIGHTS = 2;
    public static final int SW_ORIFICE_VALVE = 3;
    public static final int SW_COOLANT_VALVE = 4;
    public static final int SW_BYPASS_VALVE = 5;
    public static final int SW_SURGE_HEATER = 6;
    public static final int NUM_SWITCHES = 7;
    public static final int LATCH_DISCHARGE_TEMP = 0;
    public static final int LATCH_SUCTION_TEMP = 1;
    public static final int LATCH_LIQUID_TEMP = 2;
    public static final int LATCH_DISCHARGE_PRESS = 3;
    public static final int LATCH_POWER = 4;
    public static final int LATCH_EXT_PERMIT = 5;
    public static final int LATCH_SMOKE_DETC = 6;
    public static final int LATCH_SENSORS_VALID = 7;
    public static final int LATCH_AFTER_COOLER = 8;
    public static final int LATCH_OIL_LEVEL = 9;
    public static final int NUM_LATCHES = 10;
    public static final int COND_KEYSWITCH_ON = 0;
    public static final int COND_CMP_ENABLED = 1;
    public static final int COND_CMP_WAITING = 2;
    public static final int COND_CMP_POWERED = 3;
    public static final int COND_DISC_TEMP_VALID = 4;
    public static final int COND_SUCT_TEMP_VALID = 5;
    public static final int COND_LIQD_TEMP_VALID = 6;
    public static final int COND_DISC_PRESS_VALID = 7;
    public static final int COND_SUCT_PRESS_VALID = 8;
    public static final int COND_CURRENT_VALID = 9;
    public static final int COND_VOLTAGE_VALID = 10;
    public static final int COND_LATCHES_CLEAR = 11;
    public static final int COND_POWER_LED = 12;
    public static final int COND_CURR_SENSOR_ERR = 13;
    public static final int COND_CMP_ON_8HRS = 14;
    public static final int COND_OIL_LEVEL_VALID = 15;
    public static final int NUM_CONDITIONS = 16;
    public static final int SWC_DISC_PRESS = 0;
    public static final int SWC_DISC_TEMP = 1;
    public static final int SWC_SUCT_TEMP = 2;
    public static final int SWC_CMPR_POWER = 3;
    public static final int SWC_PHASE_SEP_TEMP = 4;
    public static final int SWC_PLATE_TEMP = 5;
    public static final int SWC_OIL_LEVEL = 6;
    public static final int SWC_LIQUID_TEMP = 7;
    public static final int NUM_SW_CONDITIONS = 8;
    public static final String KEY = "CompressorState";
    private final int type;
    private final Collection validSwitches;
    private final Collection validLatches;
    private final Collection validConditions;
    private final Collection validSwConditions;
    private String name;
    private int index;
    private CompressorState compState = CompressorState.OFFLINE;
    private final SwitchState[] switchState = new SwitchState[7];
    private final LatchState[] latchState = new LatchState[10];
    private final ConditionState[] conditionState = new ConditionState[16];
    private final SwCondState[] swCondState = new SwCondState[8];
    private static final long serialVersionUID = -5419137656635568916L;

    public CompState(int type) {
        this.type = type;
        this.validSwitches = type == 0 ? ColdCompState.SWITCHES : CryoCompState.SWITCHES;
        this.validLatches = type == 0 ? ColdCompState.LATCHES : CryoCompState.LATCHES;
        this.validConditions = type == 0 ? ColdCompState.CONDITIONS : CryoCompState.CONDITIONS;
        this.validSwConditions = type == 0 ? ColdCompState.SW_CONDITIONS : CryoCompState.SW_CONDITIONS;
        Arrays.fill((Object[])this.switchState, (Object)SwitchState.OFFLINE);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.OFFLINE);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.OFF);
        Arrays.fill((Object[])this.swCondState, (Object)SwCondState.CLEAR);
    }

    public int getType() {
        return this.type;
    }

    public Collection<Integer> getValidSwitches() {
        return this.validSwitches;
    }

    public Collection<Integer> getValidLatches() {
        return this.validLatches;
    }

    public Collection<Integer> getValidConditions() {
        return this.validConditions;
    }

    public Collection<Integer> getValidSwConditions() {
        return this.validSwConditions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setCompressorState(CompressorState value) {
        this.compState = value;
    }

    public CompressorState getCompressorState() {
        return this.compState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setLatchState(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatchState(int latch) {
        return this.latchState[latch];
    }

    public void setConditionState(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getConditionState(int cond) {
        return this.conditionState[cond];
    }

    public void setSwConditionState(int cond, SwCondState state) {
        this.swCondState[cond] = state;
    }

    public SwCondState getSwConditionState(int cond) {
        return this.swCondState[cond];
    }

    public String toString() {
        return super.toString();
    }
}

