/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui.jas;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.ColdPage;
import org.lsst.ccs.subsystem.refrig.ui.CryoPage;
import org.lsst.ccs.subsystem.refrig.ui.ThermalControlPanel;

@Plugin(name="Thermal Control Plugin", description="Thermal Control Plugin")
public class ThermalPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage("thermalType", ThermalControl.class, "Control", true, new String[]{"ThermalState"}));
        OptionalPage.getService().add((OptionalPage)new ColdImageOptionalPage());
        OptionalPage.getService().add((OptionalPage)new CryoImageOptionalPage());
    }

    static class CryoImageOptionalPage
    implements OptionalPage {
        private CryoPage cryoPage;

        CryoImageOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty("thermalType") ? "CCS Subsystems/" + agent.getName() + "/Cryo Plate" : null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            this.cryoPage = new CryoPage(agent);
            JComponent panel = this.cryoPage.getView().getPanel();
            panel.setName(agent.getName() + " Cryo Plate");
            this.cryoPage.getView().install();
            return panel;
        }

        public void opened(String page) {
        }

        public void closed(String page) {
            this.cryoPage.getView().uninstall();
            this.cryoPage = null;
        }
    }

    static class ColdImageOptionalPage
    implements OptionalPage {
        private ColdPage coldPage;

        ColdImageOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty("thermalType") ? "CCS Subsystems/" + agent.getName() + "/Cold Plate" : null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            this.coldPage = new ColdPage(agent);
            JComponent panel = this.coldPage.getView().getPanel();
            panel.setName(agent.getName() + " Cold Plate");
            this.coldPage.getView().install();
            return panel;
        }

        public void opened(String page) {
        }

        public void closed(String page) {
            this.coldPage.getView().uninstall();
            this.coldPage = null;
        }
    }

    public static class ThermalControl
    extends ControlPanel
    implements StatusMessageListener {
        private CommandSender cmdSender;
        private ThermalControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("ThermalState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new ThermalControlPanel(sndr);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getSystemState", new Object[0]));
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((ThermalState)obj);
        }

        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

