/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.ui.CompressorSummaryPanel;

public class RefrigControlPanel
extends JPanel {
    private final CommandSender sender;
    private final JPanel mainPanel = new JPanel();
    private SystemStatusPanel statusPanel;
    private int numColdPanels = 0;
    private int numCryoPanels = 0;
    private final CompressorSummaryPanel[] coldLines = new CompressorSummaryPanel[2];
    private final CompressorSummaryPanel[] cryoLines = new CompressorSummaryPanel[6];
    private static final long serialVersionUID = 1L;

    public RefrigControlPanel(CommandSender cons) {
        this.sender = cons;
        this.initComponents();
        new UpdateRefrigStatus(new RefrigState()).run();
        new DisableSystem().run();
    }

    public void updateControlPanel(RefrigState rs) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    private void initComponents() {
        int comp;
        this.statusPanel = new SystemStatusPanel(this.sender);
        for (comp = 0; comp < this.coldLines.length; ++comp) {
            this.coldLines[comp] = new CompressorSummaryPanel(0, this.sender);
        }
        for (comp = 0; comp < this.cryoLines.length; ++comp) {
            this.cryoLines[comp] = new CompressorSummaryPanel(1, this.sender);
        }
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.mainPanel.add((Component)this.statusPanel, gbm);
        this.add(this.mainPanel);
    }

    private void layoutMainPanel(int numColdComps, int numCryoComps) {
        int j;
        int j2;
        if (numColdComps == this.numColdPanels && numCryoComps == this.numCryoPanels) {
            return;
        }
        for (j2 = 0; j2 < this.numColdPanels; ++j2) {
            this.mainPanel.remove(this.coldLines[j2]);
        }
        for (j2 = 0; j2 < this.numCryoPanels; ++j2) {
            this.mainPanel.remove(this.cryoLines[j2]);
        }
        this.numColdPanels = numColdComps;
        this.numCryoPanels = numCryoComps;
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 1;
        for (j = 0; j < this.numColdPanels; ++j) {
            this.mainPanel.add((Component)this.coldLines[j], gbm);
            ++gbm.gridy;
        }
        for (j = 0; j < this.numCryoPanels; ++j) {
            this.mainPanel.add((Component)this.cryoLines[j], gbm);
            ++gbm.gridy;
        }
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            RefrigControlPanel.this.statusPanel.disableSystem();
            for (CompressorSummaryPanel comp : RefrigControlPanel.this.coldLines) {
                comp.disableSystem();
            }
            for (CompressorSummaryPanel comp : RefrigControlPanel.this.cryoLines) {
                comp.disableSystem();
            }
            RefrigControlPanel.this.repaint();
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        private final RefrigState rs;

        UpdateRefrigStatus(RefrigState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            RefrigControlPanel.this.statusPanel.updateStatus(this.rs.getTickMillis());
            for (CompState cs : this.rs.getColdStates()) {
                RefrigControlPanel.this.coldLines[cs.getIndex()].updateControlPanel(cs);
            }
            for (CompState cs : this.rs.getCryoStates()) {
                RefrigControlPanel.this.cryoLines[cs.getIndex()].updateControlPanel(cs);
            }
            if (this.rs.getNumColdComps() != RefrigControlPanel.this.numColdPanels || this.rs.getNumCryoComps() != RefrigControlPanel.this.numCryoPanels) {
                RefrigControlPanel.this.layoutMainPanel(this.rs.getNumColdComps(), this.rs.getNumCryoComps());
            }
            RefrigControlPanel.this.repaint();
        }
    }
}

