/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.AuxHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.ThermalConstants;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.TextFieldX;

public class AuxHeaterPanel
extends JPanel {
    private static final String[] heaterNames = new String[3];
    private static final int switchLabelWidth;
    private static final int switchStateWidth;
    private static final int textFieldWidth;
    private static final Map<AuxHeaterState, Color> stateColors;
    private final int id;
    private final CommandSender sender;
    private final JLabel switchLabel = new JLabel("");
    private final JLabel switchStatus = new JLabel("OFF");
    private final ButtonGroup switchBG = new ButtonGroup();
    private final JRadioButton switchOffRB = new JRadioButton("Off");
    private final JRadioButton switchOnRB = new JRadioButton("On");
    private final JTextField powerTextField = new JTextField();
    private final TextFieldX powerTFX = new TextFieldX(this.powerTextField, 2);
    private final JLabel powerUnitsLabel = new JLabel("W");
    private static final long serialVersionUID = 1L;

    AuxHeaterPanel(int id, CommandSender sender) {
        this.id = id;
        this.sender = sender;
        this.initComponents();
    }

    public void updatePanel(ThermalState rs) {
        this.switchStatus.setEnabled(true);
        AuxHeaterState pState = rs.getAuxHeaterState(this.id);
        this.switchStatus.setText(pState.name());
        Color color = stateColors.get((Object)pState);
        color = color == null ? UiConstants.PURPLE : color;
        this.switchStatus.setForeground(color);
        boolean isOn = ThermalConstants.auxOnStates.contains((Object)pState);
        JRadioButton selButton = isOn ? this.switchOnRB : this.switchOffRB;
        selButton.setSelected(true);
        this.switchOffRB.setEnabled(isOn);
        this.switchOnRB.setEnabled(pState == AuxHeaterState.OFF);
        this.powerTFX.update(rs.getAuxHeaterPower(this.id), true);
    }

    public void disablePanel() {
        this.switchStatus.setEnabled(false);
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.powerTFX.disable();
    }

    private void initComponents() {
        this.switchLabel.setFont(UiConstants.FONT);
        this.switchLabel.setText(heaterNames[this.id] + ":");
        Dimension d = this.switchLabel.getPreferredSize();
        d.width = switchLabelWidth;
        this.switchLabel.setPreferredSize(d);
        this.switchStatus.setFont(UiConstants.FONT);
        d = this.switchStatus.getPreferredSize();
        d.width = switchStateWidth;
        this.switchStatus.setPreferredSize(d);
        this.switchOffRB.setFont(UiConstants.FONT);
        this.switchOffRB.setFocusable(false);
        this.switchOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuxHeaterPanel.this.setHeaterPowerState(0);
            }
        });
        this.switchOnRB.setFont(UiConstants.FONT);
        this.switchOnRB.setFocusable(false);
        this.switchOnRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuxHeaterPanel.this.setHeaterPowerState(1);
            }
        });
        this.switchBG.add(this.switchOffRB);
        this.switchBG.add(this.switchOnRB);
        d = this.powerTextField.getPreferredSize();
        d.width = textFieldWidth;
        this.powerTextField.setPreferredSize(d);
        this.powerTextField.setHorizontalAlignment(0);
        this.powerTextField.setText("...");
        this.powerTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AuxHeaterPanel.this.powerTFX.focusLost();
            }
        });
        this.powerTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)AuxHeaterPanel.this.powerTFX.action();
                if (value != null) {
                    AuxHeaterPanel.this.sender.sendCommand(null, "setAuxHeaterPower", new Object[]{AuxHeaterPanel.this.id, value});
                }
            }
        });
        this.powerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AuxHeaterPanel.this.powerTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.powerUnitsLabel.setFont(UiConstants.FONT);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets.left = 6;
        this.add((Component)this.switchLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.switchStatus, gbc);
        ++gbc.gridx;
        gbc.insets.top = -6;
        this.add((Component)this.switchOffRB, gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        this.add((Component)this.switchOnRB, gbc);
        ++gbc.gridx;
        gbc.insets.left = 6;
        gbc.insets.top = 0;
        this.add((Component)this.powerTextField, gbc);
        ++gbc.gridx;
        gbc.insets.right = 6;
        this.add((Component)this.powerUnitsLabel, gbc);
    }

    private void setHeaterPowerState(int value) {
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.sender.sendCommand(null, "setAuxHeaterState", new Object[]{this.id, value});
    }

    static {
        AuxHeaterPanel.heaterNames[0] = "-Y";
        AuxHeaterPanel.heaterNames[1] = "+Y";
        AuxHeaterPanel.heaterNames[2] = "Center";
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (String string : heaterNames) {
            label.setText(string + ":");
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchLabelWidth = width;
        width = 0;
        for (AuxHeaterState auxHeaterState : AuxHeaterState.values()) {
            label.setText(auxHeaterState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchStateWidth = width;
        JTextField jTextField = new JTextField(" 1000.0 ");
        textFieldWidth = jTextField.getPreferredSize().width;
        stateColors = new HashMap<AuxHeaterState, Color>();
        stateColors.put(AuxHeaterState.OFF, Color.BLACK);
        stateColors.put(AuxHeaterState.ON, UiConstants.GREEN);
        stateColors.put(AuxHeaterState.OFFLINE, UiConstants.BLUE);
        stateColors.put(AuxHeaterState.DISABLD, UiConstants.RED);
        stateColors.put(AuxHeaterState.VOLTERR, UiConstants.PURPLE);
        stateColors.put(AuxHeaterState.CANTSET, UiConstants.PURPLE);
        stateColors.put(AuxHeaterState.NOLOAD, UiConstants.PURPLE);
    }
}

