package org.lsst.ccs.subsystem.refrig.ui.jas;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.commons.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.commons.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.commons.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.refrig.constants.RefrigAgentProperties;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.ColdPage;
import org.lsst.ccs.subsystem.refrig.ui.CryoPage;
import org.lsst.ccs.subsystem.refrig.ui.ThermalControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "Thermal Control Plugin", description = "Thermal Control Plugin")
public class ThermalPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage.getService().add(new MonOptionalPage(RefrigAgentProperties.THERMAL_TYPE, ThermalControl.class,
                                                          "Control", true, "ThermalState"));
        OptionalPage.getService().add(new ColdImageOptionalPage());
        OptionalPage.getService().add(new CryoImageOptionalPage());
    }
    
    public static class ThermalControl extends ControlPanel implements StatusMessageListener {

        private CommandSender cmdSender;
        private ThermalControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(ThermalState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            cmdSender = sndr;
            return ctrlPanel = new ThermalControlPanel(sndr);
        }

        @Override
        public void initControlPanel() {
            updateControlPanel(cmdSender.sendCommand(null, "getSystemState"));
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((ThermalState)obj);
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
    static class ColdImageOptionalPage implements OptionalPage {
        
        private ColdPage coldPage;

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(RefrigAgentProperties.THERMAL_TYPE)
                     ? "CCS Subsystems/" + agent.getName() + "/Cold Plate" : null;
        }
        
        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            coldPage = new ColdPage(agent);
            JComponent panel = coldPage.getView().getPanel();
            panel.setName(agent.getName() + " Cold Plate");
            coldPage.getView().install();
            return panel;
        }

        @Override
        public void opened(String page) {
//            coldPage.getView().install();
        }

        @Override
        public void closed(String page) {
            coldPage.getView().uninstall();
            coldPage = null;
        }
    }
    
    static class CryoImageOptionalPage implements OptionalPage {
        
        private CryoPage cryoPage;

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(RefrigAgentProperties.THERMAL_TYPE)
                     ? "CCS Subsystems/" + agent.getName() + "/Cryo Plate" : null;
        }
        
        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            cryoPage = new CryoPage(agent);
            JComponent panel = cryoPage.getView().getPanel();
            panel.setName(agent.getName() + " Cryo Plate");
            cryoPage.getView().install();
            return panel;
        }

        @Override
        public void opened(String page) {
//            cryoPage.getView().install();
        }

        @Override
        public void closed(String page) {
            cryoPage.getView().uninstall();
            cryoPage = null;
        }
    }

}
