/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelSingle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

public class ColdPage {
    private final AgentInfo agent;
    private ImageView view;
    private final MonitorField heaterField;

    public ColdPage(AgentInfo agent) {
        this.agent = agent;
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = 0;
        fv.format = " %1$6.2f ";
        this.heaterField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
    }

    public ImageView getView() {
        if (this.view != null) {
            return this.view;
        }
        try {
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/cold.png"));
            this.view = new ImageView("Cold Plate", back, 0.5, 2.0);
            this.placeRTD(0, 0.5583, 0.7698, 0.0f, 0.0f);
            this.placeRTD(2, 0.6119, 0.574, 1.0f, 1.0f);
            this.placeRTD(3, 0.6119, 0.429, 1.0f, 1.0f, true);
            this.placeRTD(5, 0.564, 0.2078, 0.0f, 0.0f, true);
            this.placeRTD(50, 0.1014, 0.7653, 1.0f, 0.0f, true);
            this.placeRTD(52, 0.0443, 0.5889, 0.0f, 0.0f);
            this.placeRTD(53, 0.0443, 0.441, 0.0f, 0.0f);
            this.placeRTD(55, 0.1049, 0.2392, 1.0f, 1.0f, true);
            this.placeHeaterPower(0, 0.7669, 0.83);
            this.placeHeaterPower(1, 0.7669, 0.75);
            this.placeHeaterPower(2, 0.7669, 0.61);
            this.placeHeaterPower(3, 0.7669, 0.45);
            this.placeHeaterPower(4, 0.7669, 0.33);
            this.placeHeaterPower(5, 0.7669, 0.25);
            String channelPath = this.agent.getName() + "/main/Trim_Htrs/ColdTotal_P";
            DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(channelPath, null, null), this.heaterField);
            CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
            ImageView.Item item = new ImageView.Item((Object)table);
            item.setPosition(0.9, 0.9641);
            item.setAlignment(0.0, 1.0);
            item.setMaxSize(0.08, 0.06);
            this.view.add(item);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.view;
    }

    private void placeRTD(int id, double x, double y, float horAlign, float vertAlign, boolean redBorder) throws IOException {
        String channelPath = String.format("%1$s/main/Cold_Temp/CLP-RTD-%2$02d", this.agent.getName(), id);
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = 0;
        fv.format = "<html><center>RTD-" + String.format("%02d", id) + ":<br>%1$6.1f";
        MonitorField field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(channelPath, null, null), field);
        CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
        if (redBorder) {
            Insets ins = table.getBorder().getBorderInsets((Component)table);
            table.setBorder((Border)BorderFactory.createMatteBorder(3 * ins.top, 3 * ins.left, 3 * ins.bottom, 3 * ins.right, Color.RED));
        }
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment((double)horAlign, (double)vertAlign);
        item.setMaxSize(0.08, 0.08);
        this.view.add(item);
    }

    private void placeRTD(int id, double x, double y, float horAlign, float vertAlign) throws IOException {
        this.placeRTD(id, x, y, horAlign, vertAlign, false);
    }

    private void placeHeaterPower(int id, double x, double y) throws IOException {
        String channelPath = String.format("%1$s/main/Trim_Htrs/ColdHtr%2$1d_P", this.agent.getName(), id);
        DefaultMonitorCell c = new DefaultMonitorCell((DisplayChannel)new DisplayChannelSingle(channelPath, null, null), this.heaterField);
        CellTableView table = new CellTableView(1, 1, new DefaultMonitorCell[]{c});
        ImageView.Item item = new ImageView.Item((Object)table);
        item.setPosition(x, y);
        item.setAlignment(0.0, 0.0);
        item.setMaxSize(0.126, 0.06);
        this.view.add(item);
    }
}

