package org.lsst.ccs.subsystem.refrig.ui.jas;

import java.time.Duration;
import org.lsst.ccs.gconsole.base.Console;

/**
 * Class for sending a command and receiving the response.
 * 
 * @author saxton
 */
public class CommandSender {

    private final String dest;
    private final Console console = Console.getConsole();
    private int defTimeout = 5000;

    public CommandSender(String dest) {
        this.dest = dest;

    }
    public Object sendCommand(String target, String cmnd, Object... args) {
        return sendCommand(defTimeout, target, cmnd, args);
    }

    public Object sendCommand(int timeout, String target, String cmnd, Object... args) {
        try {
            String cmd = dest + (target == null ? "" : "/" + target) + "/" + cmnd;
            return console.sendCommand(Duration.ofMillis(timeout), cmd, args);
        }
        catch (Exception e) {
            console.getLoggerUI().error("Command error: ", e);
            return null;
        }
    }

    public void setTimeout(int timeout) {
        defTimeout = timeout;
    }

}
