package org.lsst.ccs.subsystem.refrig.ui.jas;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.filter.GenericFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Refrigeration path-oriented monitoring filter.
 *
 * @author The LSST CCS Team
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Compressor filter",
               path="Subsystems/MySystem/Monitor",
               description="Refrigeration path filter.")
public class CmprMonitorFilterOld extends GenericFilter {

    private static final String FIELDS = 
        MonitorField.VALUE.getKey()+","+
        MonitorField.UNITS.getKey()+","+
        MonitorField.LOW_ALARM.getKey()+","+
        MonitorField.LOW_WARN.getKey()+","+
        MonitorField.ALERT_LOW.getKey()+","+
        MonitorField.HIGH_WARN.getKey()+","+
        MonitorField.HIGH_ALARM.getKey()+","+
        MonitorField.ALERT_HIGH.getKey()+","+
        MonitorField.NAME.getKey()+","+
        MonitorField.DESCR.getKey();

    private static final Set<String> exclusions = new HashSet<>();
    static {
        exclusions.add("state");
        exclusions.add("configuration");
        exclusions.add("runtimeInfo");
        exclusions.add("RefrigState");
        exclusions.add("ThermalState");
    }

    private final String assocAgentName;
    private final Set<String> sections = new HashSet<>();

    public CmprMonitorFilterOld(String agentName) {
        super("MyName", agentName, "", "", true, FIELDS);
        assocAgentName = null;
        //System.out.println("New CmprMonitorFilter: agentName = " + agentName);
    }

    public CmprMonitorFilterOld(String agentName, String assocAgentName) {
        super("MyName", (assocAgentName != null ? assocAgentName + "," : "") + agentName, "", "", true, FIELDS);
        this.assocAgentName = assocAgentName;
        System.out.println("New CmprMonitorFilter: agentName = " + agentName + ", assocAgentName = " + assocAgentName);
    }

    @Override
    public List<String> getDisplayPath(AgentChannel channel) {
        String path = channel.getLocalPath();
        //System.out.println("Channel path: " + path);
        int i1 = path.indexOf("/");
        if (i1 == -1)  return Collections.emptyList();
        String section = path.substring(0, i1).trim();
        if (section.equals("main")) {
            int i2 = path.indexOf("/", i1 + 1);
            if (i2 != -1) {
                section = path.substring(i1 + 1, i2);
                i1 = i2;
            }
        }
        if (exclusions.contains(section)) return Collections.emptyList();
        boolean print = path.indexOf("DischrgPrs") >= 0 || path.indexOf("ReturnPrs") >= 0;
        if (print) {
            System.out.println("getDisplayPath called: full path = " + channel.getPath() + ", section = " + section);
        }
        boolean gotMain = true;
        if (assocAgentName != null) {
            if (channel.getAgentName().equals(assocAgentName)) {
                gotMain = false;
                int i2 = path.indexOf("/", i1 + 1);
                if (i2 != -1) {
                    section = path.substring(i1 + 1, i2);
                    i1 = i2;
                }
                if (!sections.contains(section)) {
                    if (print) {
                        System.out.println("Missing associated section = " + section);
                    }
                    return Collections.emptyList();
                }
            }
            else {
                //sections.add(section);
                if (sections.add(section)) {
                    System.out.println("Added main section = " + section);
                }
            }
        }
        if (gotMain) {
            int i2 = path.indexOf("/", i1 + 1);
            i1 = i2 != -1 ? i2 : i1;
        }
        if (print) {
            System.out.println("getDisplayPath returning: " + section + "//" + path.substring(i1 + 1));
        }
        return Collections.singletonList(section + "//" + path.substring(i1 + 1));
    }

}
