/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.refrig.constants.HeaterControlState;
import org.lsst.ccs.subsystem.refrig.constants.HeaterPowerState;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.TextFieldX;
import org.lsst.ccs.subsystem.refrig.ui.UiConstants;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;

public class TrimHeaterPanel
extends JPanel {
    private static final String[] plateNames = new String[2];
    private static final int powerLabelWidth;
    private static final int powerStateWidth;
    private static final int controlLabelWidth;
    private static final int controlStateWidth;
    private static final int powerFieldWidth;
    private static final int tempFieldWidth;
    private final int id;
    private final CommandSender sender;
    private final JLabel switchLabel = new JLabel();
    private final JLabel switchState = new JLabel("OFF");
    private final ButtonGroup switchBG = new ButtonGroup();
    private final JRadioButton switchOffRB = new JRadioButton("Off");
    private final JRadioButton switchOnRB = new JRadioButton("On");
    private final JLabel controlLabel = new JLabel();
    private final JLabel controlState = new JLabel("OFF");
    private final ButtonGroup controlBG = new ButtonGroup();
    private final JRadioButton controlOffRB = new JRadioButton("Off");
    private final JRadioButton controlPowerRB = new JRadioButton("Power");
    private final JRadioButton controlTempRB = new JRadioButton("Temp");
    private final JTextField powerTextField = new JTextField();
    private final TextFieldX powerTFX = new TextFieldX(this.powerTextField, 2);
    private final JLabel powerUnitsLabel = new JLabel("W");
    private final JTextField tempTextField = new JTextField();
    private final TextFieldX tempTFX = new TextFieldX(this.tempTextField, 2);
    private final JLabel tempUnitsLabel = new JLabel("\u00b0C");
    private static final long serialVersionUID = 1L;

    TrimHeaterPanel(int id, CommandSender sender) {
        this.id = id;
        this.sender = sender;
        this.initComponents();
    }

    public void updatePanel(ThermalState rs) {
        this.switchState.setEnabled(true);
        this.controlState.setEnabled(true);
        HeaterPowerState pState = rs.getTrimHeaterState(this.id);
        this.switchState.setText(pState.name());
        this.switchState.setForeground(pState == HeaterPowerState.ON ? UiConstants.GREEN : (pState == HeaterPowerState.DISABLD ? UiConstants.RED : (pState == HeaterPowerState.OFFLINE ? UiConstants.BLUE : Color.black)));
        JRadioButton selButton = pState == HeaterPowerState.ON ? this.switchOnRB : this.switchOffRB;
        selButton.setSelected(true);
        this.switchOffRB.setEnabled(pState == HeaterPowerState.ON);
        this.switchOnRB.setEnabled(pState == HeaterPowerState.OFF);
        HeaterControlState cState = rs.getTrimHeaterCtrlState(this.id);
        this.controlState.setText(cState.name());
        this.controlState.setForeground(cState == HeaterControlState.POWER ? UiConstants.YELLOW : (cState == HeaterControlState.TEMP ? UiConstants.GREEN : (cState == HeaterControlState.OFFLINE ? UiConstants.BLUE : Color.black)));
        selButton = cState == HeaterControlState.POWER ? this.controlPowerRB : (cState == HeaterControlState.TEMP ? this.controlTempRB : this.controlOffRB);
        selButton.setSelected(true);
        boolean online = cState != HeaterControlState.OFFLINE;
        this.controlOffRB.setEnabled(online && selButton != this.controlOffRB);
        this.controlPowerRB.setEnabled(online && selButton != this.controlPowerRB);
        this.controlTempRB.setEnabled(online && selButton != this.controlTempRB);
        this.powerTFX.update(rs.getTrimHeaterPower(this.id), true);
        this.tempTFX.update(rs.getPlateTemperature(this.id), true);
        this.repaint();
    }

    public void disablePanel() {
        this.switchState.setEnabled(false);
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.controlState.setEnabled(false);
        this.controlOffRB.setEnabled(false);
        this.controlPowerRB.setEnabled(false);
        this.controlTempRB.setEnabled(false);
        this.powerTFX.disable();
        this.tempTFX.disable();
        this.repaint();
    }

    private void initComponents() {
        this.switchLabel.setFont(UiConstants.FONT);
        this.switchLabel.setText(plateNames[this.id] + " Power: ");
        Dimension d = this.switchLabel.getPreferredSize();
        d.width = powerLabelWidth;
        this.switchLabel.setPreferredSize(d);
        this.switchState.setFont(UiConstants.FONT);
        d = this.switchState.getPreferredSize();
        d.width = powerStateWidth;
        this.switchState.setPreferredSize(d);
        this.switchOffRB.setFont(UiConstants.FONT);
        this.switchOffRB.setFocusable(false);
        this.switchOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrimHeaterPanel.this.setHeaterPowerState(0);
            }
        });
        this.switchOnRB.setFont(UiConstants.FONT);
        this.switchOnRB.setFocusable(false);
        this.switchOnRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrimHeaterPanel.this.setHeaterPowerState(1);
            }
        });
        this.switchBG.add(this.switchOffRB);
        this.switchBG.add(this.switchOnRB);
        this.controlLabel.setFont(UiConstants.FONT);
        this.controlLabel.setText(plateNames[this.id] + " Control: ");
        d = this.controlLabel.getPreferredSize();
        d.width = controlLabelWidth;
        this.controlLabel.setPreferredSize(d);
        this.controlState.setFont(UiConstants.FONT);
        d = this.controlState.getPreferredSize();
        d.width = controlStateWidth;
        this.controlState.setPreferredSize(d);
        this.controlOffRB.setFont(UiConstants.FONT);
        this.controlOffRB.setFocusable(false);
        this.controlOffRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrimHeaterPanel.this.setHeaterControlState(0);
            }
        });
        this.controlPowerRB.setFont(UiConstants.FONT);
        this.controlPowerRB.setFocusable(false);
        this.controlPowerRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrimHeaterPanel.this.setHeaterControlState(1);
            }
        });
        this.controlTempRB.setFont(UiConstants.FONT);
        this.controlTempRB.setFocusable(false);
        this.controlTempRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrimHeaterPanel.this.setHeaterControlState(-1);
            }
        });
        this.controlBG.add(this.controlOffRB);
        this.controlBG.add(this.controlPowerRB);
        this.controlBG.add(this.controlTempRB);
        d = this.powerTextField.getPreferredSize();
        d.width = powerFieldWidth;
        this.powerTextField.setPreferredSize(d);
        this.powerTextField.setHorizontalAlignment(0);
        this.powerTextField.setText("...");
        this.powerTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TrimHeaterPanel.this.powerTFX.focusLost();
            }
        });
        this.powerTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)TrimHeaterPanel.this.powerTFX.action();
                if (value != null) {
                    TrimHeaterPanel.this.sender.sendCommand(null, "setTrimHeaterPower", TrimHeaterPanel.this.id, value);
                }
            }
        });
        this.powerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TrimHeaterPanel.this.powerTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.powerUnitsLabel.setFont(UiConstants.FONT);
        d = this.tempTextField.getPreferredSize();
        d.width = tempFieldWidth;
        this.tempTextField.setPreferredSize(d);
        this.tempTextField.setHorizontalAlignment(0);
        this.tempTextField.setText("...");
        this.tempTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TrimHeaterPanel.this.tempTFX.focusLost();
            }
        });
        this.tempTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Double value = (Double)TrimHeaterPanel.this.tempTFX.action();
                if (value != null) {
                    TrimHeaterPanel.this.sender.sendCommand(null, "setPlateTemperature", TrimHeaterPanel.this.id, value);
                }
            }
        });
        this.tempTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                TrimHeaterPanel.this.tempTFX.keyTyped(evt.getKeyChar());
            }
        });
        this.tempUnitsLabel.setFont(UiConstants.FONT);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets.top = 5;
        this.add((Component)this.switchLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.switchState, gbc);
        ++gbc.gridx;
        gbc.insets.top = 1;
        this.add((Component)this.switchOffRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.switchOnRB, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.top = 0;
        this.add((Component)this.controlLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlState, gbc);
        ++gbc.gridx;
        gbc.insets.top = -4;
        this.add((Component)this.controlOffRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.controlPowerRB, gbc);
        ++gbc.gridx;
        gbc.insets.top = 0;
        this.add((Component)this.powerTextField, gbc);
        ++gbc.gridx;
        this.add((Component)this.powerUnitsLabel, gbc);
        ++gbc.gridx;
        gbc.insets.top = -4;
        gbc.insets.left = 8;
        this.add((Component)this.controlTempRB, gbc);
        ++gbc.gridx;
        gbc.insets.top = 0;
        gbc.insets.left = 5;
        this.add((Component)this.tempTextField, gbc);
        ++gbc.gridx;
        gbc.insets.right = 5;
        this.add((Component)this.tempUnitsLabel, gbc);
    }

    private void setHeaterPowerState(int value) {
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.sender.sendCommand(null, "setTrimHeaterPowerEnable", this.id, value);
    }

    private void setHeaterControlState(int value) {
        this.controlOffRB.setEnabled(false);
        this.controlPowerRB.setEnabled(false);
        this.controlTempRB.setEnabled(false);
        this.sender.sendCommand(null, "setTrimHeaterControl", this.id, value);
    }

    static {
        TrimHeaterPanel.plateNames[0] = "Cold";
        TrimHeaterPanel.plateNames[1] = "Cryo";
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (String string : plateNames) {
            label.setText(string + " Power: ");
            width = Math.max(width, label.getPreferredSize().width);
        }
        powerLabelWidth = width;
        width = 0;
        for (String string : HeaterPowerState.values()) {
            label.setText(string.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        powerStateWidth = width;
        width = 0;
        for (String string : plateNames) {
            label.setText(string + " Control: ");
            width = Math.max(width, label.getPreferredSize().width);
        }
        controlLabelWidth = width;
        width = 0;
        for (String string : HeaterControlState.values()) {
            label.setText(string.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        controlStateWidth = width;
        JTextField field = new JTextField(" 999.9 ");
        powerFieldWidth = field.getPreferredSize().width;
        field.setText(" -999.9 ");
        tempFieldWidth = field.getPreferredSize().width;
    }
}

