package org.lsst.ccs.subsystem.refrig.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.refrig.constants.RefrigAgentProperties;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.ThermalControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "Thermal Control Plugin", description = "Thermal Control Plugin")
public class ThermalControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage optPage = new RefrigOptionalPage(RefrigAgentProperties.THERMAL_TYPE, ThermalControl.class);
        Console.getConsole().getOptionalPageService().add(optPage);
    }
    
    static class ThermalControl implements Control, StatusMessageListener {

        private CommandSender cmdSender;
        private ThermalControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(ThermalState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            cmdSender = sndr;
            return ctrlPanel = new ThermalControlPanel(sndr);
        }

        @Override
        public void initControlPanel() {
            updateControlPanel(cmdSender.sendCommand(null, "getSystemState"));
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((ThermalState)obj);
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
