package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;

/**
 *  Implements the system status line panel.
 *
 *  @author Owen Saxton
 */
public class SystemStatusPanel extends JPanel {

    private final CommandSender sender;
    private double mainPeriod = 5.0;

    private final JLabel stateLabel = new JLabel("System State:  ");
    private final JLabel stateStatus = new JLabel("STOPPED");

    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField(" 999.9 ");
    private final JLabel periodUnitsLabel = new JLabel("sec");

    public SystemStatusPanel(CommandSender cons) {
        this.sender = cons;
        initComponents();
        disableSystem();
    }

    public void updateStatus(int tickMillis) {
        stateStatus.setText("RUNNING");
        stateStatus.setForeground(UiConstants.GREEN);
        periodTextField.setEnabled(true);
        mainPeriod = tickMillis / 1000.0;
        periodTextField.setText(String.valueOf(mainPeriod));
        repaint();
    }

    public void disableSystem() {
        stateStatus.setText("STOPPED");
        stateStatus.setForeground(UiConstants.RED);
        periodTextField.setEnabled(false);
        repaint();
    }

    private void initComponents() {

        // System state
        stateLabel.setFont(UiConstants.FONT);
        stateStatus.setFont(UiConstants.FONT);
        Dimension d = stateStatus.getPreferredSize();
        d.width = 150;
        stateStatus.setPreferredSize(d);

        // Update period
        periodLabel.setFont(UiConstants.FONT);
        periodTextField.setPreferredSize(periodTextField.getPreferredSize());
        periodTextField.setHorizontalAlignment(SwingConstants.CENTER);
        periodTextField.setText("...");
        periodTextField.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                setUpdatePeriod();
            }
        });
        periodUnitsLabel.setFont(UiConstants.FONT);

        // Lay out all the sub-panels
        periodPanel.add(periodTextField);
        periodPanel.add(periodUnitsLabel);

        // Add state & period items to panel
        setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 0, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = GridBagConstraints.EAST;
        add(stateLabel, gbh);
        gbh.gridx++;
        gbh.anchor = GridBagConstraints.WEST;
        add(stateStatus, gbh);
        gbh.gridx++;
        gbh.gridwidth = 2;
        gbh.anchor = GridBagConstraints.EAST;
        add(periodLabel, gbh);
        gbh.gridx += 2;
        gbh.gridwidth = 1;
        gbh.anchor = GridBagConstraints.WEST;
        add(periodPanel, gbh);
        gbh.gridx = 0;
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(periodTextField.getText());
            sender.sendCommand(null, "setUpdatePeriod", (int)(1000 * value));
            periodTextField.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            periodTextField.setText(String.valueOf(mainPeriod));
        }
    }

    private static final long serialVersionUID = 1L;
}
