/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.ThermalControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.ui.jas.Control;
import org.lsst.ccs.subsystem.refrig.ui.jas.RefrigOptionalPage;

@Plugin(name="Thermal Control Plugin", description="Thermal Control Plugin")
public class ThermalControlPlugin
extends ConsolePlugin {
    public void initialize() {
        RefrigOptionalPage optPage = new RefrigOptionalPage("thermalType", ThermalControl.class);
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class ThermalControl
    implements Control,
    StatusMessageListener {
        private CommandSender cmdSender;
        private ThermalControlPanel ctrlPanel;

        ThermalControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("ThermalState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new ThermalControlPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getSystemState", new Object[0]));
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((ThermalState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

